/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.io.IOException;
import java.security.acl.Group;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.jboss.security.auth.spi.BaseCertLoginModule;
import org.jboss.security.auth.spi.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertRolesLoginModule
extends BaseCertLoginModule {
    private static final String ROLES_PROPERTIES = "rolesProperties";
    private static final String DEFAULT_ROLES_PROPERTIES = "defaultRolesProperties";
    private static final String ROLE_GROUP_SEPERATOR = "roleGroupSeperator";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"rolesProperties", "defaultRolesProperties", "roleGroupSeperator"};
    private String defaultRolesRsrcName = "defaultRoles.properties";
    private String rolesRsrcName = "roles.properties";
    private Properties roles;
    private char roleGroupSeperator = (char)46;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.addValidOptions(ALL_VALID_OPTIONS);
        super.initialize(subject, callbackHandler, sharedState, options);
        this.trace = this.log.isTraceEnabled();
        if (this.trace) {
            this.log.trace((Object)"enter: initialize(Subject, CallbackHandler, Map, Map)");
        }
        try {
            String option = (String)options.get(ROLES_PROPERTIES);
            if (option != null) {
                this.rolesRsrcName = option;
            }
            if ((option = (String)options.get(DEFAULT_ROLES_PROPERTIES)) != null) {
                this.defaultRolesRsrcName = option;
            }
            if ((option = (String)options.get(ROLE_GROUP_SEPERATOR)) != null) {
                this.roleGroupSeperator = option.charAt(0);
            }
            this.loadRoles();
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to load users/passwords/role files", (Throwable)e);
        }
        if (this.trace) {
            this.log.trace((Object)"exit: initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    @Override
    public boolean login() throws LoginException {
        if (this.trace) {
            this.log.trace((Object)"enter: login()");
        }
        if (this.roles == null) {
            throw new LoginException("Missing roles.properties file.");
        }
        boolean wasSuccessful = super.login();
        if (this.trace) {
            this.log.trace((Object)"exit: login()");
        }
        return wasSuccessful;
    }

    @Override
    protected Group[] getRoleSets() throws LoginException {
        if (this.trace) {
            this.log.trace((Object)"enter: getRoleSets()");
        }
        String targetUser = this.getUsername();
        Group[] roleSets = Util.getRoleSets(targetUser, this.roles, this.roleGroupSeperator, (AbstractServerLoginModule)this);
        if (this.trace) {
            this.log.trace((Object)"exit: getRoleSets()");
        }
        return roleSets;
    }

    private void loadRoles() throws IOException {
        this.roles = Util.loadProperties(this.defaultRolesRsrcName, this.rolesRsrcName, this.log);
    }
}

