/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.info.plugins;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.common.beans.property.finder.PropertyEditorFinder;
import org.jboss.config.plugins.property.PropertyConfiguration;
import org.jboss.config.spi.Configuration;

public class BeanInfoUtil {
    private static Configuration configuration = AccessController.doPrivileged(new PrivilegedAction<Configuration>(){

        @Override
        public Configuration run() {
            return new PropertyConfiguration(System.getProperties());
        }
    });

    protected static Object getNestedTarget(BeanInfo beanInfo, Object target, String[] propertys) throws Throwable {
        if (propertys == null) {
            throw new IllegalArgumentException("Null propertys.");
        }
        for (int i = 0; i < propertys.length; ++i) {
            if (beanInfo == null) {
                throw new IllegalArgumentException("Null bean info");
            }
            PropertyInfo propertyInfo = beanInfo.getProperty(propertys[i]);
            Object result = propertyInfo.get(target);
            if (i < propertys.length - 1) {
                if (result == null) {
                    throw new IllegalArgumentException("Null target in nested property (" + Arrays.asList(propertys) + "): " + target + "." + propertys[i]);
                }
                beanInfo = configuration.getBeanInfo(result.getClass());
            }
            target = result;
        }
        return target;
    }

    protected static PropertyInfo getNestedPropertyInfo(BeanInfo beanInfo, Object target, String[] propertys) throws Throwable {
        if (propertys == null || propertys.length == 0) {
            throw new IllegalArgumentException("Illegal propertys: " + Arrays.asList(propertys) + ", " + target);
        }
        PropertyInfo propertyInfo = null;
        for (int i = 0; i < propertys.length; ++i) {
            if (beanInfo == null) {
                throw new IllegalArgumentException("Null bean info");
            }
            propertyInfo = beanInfo.getProperty(propertys[i]);
            if (i >= propertys.length - 1) continue;
            Object result = propertyInfo.get(target);
            if (result == null) {
                throw new IllegalArgumentException("Null target in nested property (" + Arrays.asList(propertys) + "): " + target + "." + propertys[i]);
            }
            beanInfo = configuration.getBeanInfo(result.getClass());
            target = result;
        }
        return propertyInfo;
    }

    public static Object get(BeanInfo beanInfo, Object target, String name) throws Throwable {
        if (target == null) {
            throw new IllegalArgumentException("Null target");
        }
        if (name == null) {
            throw new IllegalArgumentException("Null property name");
        }
        String[] propertys = name.split("\\.");
        return BeanInfoUtil.getNestedTarget(beanInfo, target, propertys);
    }

    public static void set(BeanInfo beanInfo, Object target, String name, Object value) throws Throwable {
        if (target == null) {
            throw new IllegalArgumentException("Null target");
        }
        if (name == null) {
            throw new IllegalArgumentException("Null property name");
        }
        String[] propertys = name.split("\\.");
        int size = propertys.length - 1;
        if (size > 0) {
            String[] allButLast = new String[size];
            System.arraycopy(propertys, 0, allButLast, 0, size);
            Object result = BeanInfoUtil.getNestedTarget(beanInfo, target, allButLast);
            if (result == null) {
                throw new IllegalArgumentException("Cannot set value on null target: " + target + "." + name);
            }
            target = result;
            beanInfo = configuration.getBeanInfo(target.getClass());
        } else if (beanInfo == null) {
            throw new IllegalArgumentException("Null bean info.");
        }
        PropertyInfo propertyInfo = beanInfo.getProperty(propertys[size]);
        propertyInfo.set(target, value);
    }

    public static PropertyInfo getPropertyInfo(BeanInfo beanInfo, Object target, String name) throws Throwable {
        if (target == null) {
            throw new IllegalArgumentException("Null target");
        }
        if (name == null) {
            throw new IllegalArgumentException("Null property name");
        }
        String[] propertys = name.split("\\.");
        return BeanInfoUtil.getNestedPropertyInfo(beanInfo, target, propertys);
    }

    static {
        PropertyEditorFinder.getInstance();
    }
}

