/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jbc2.util;

import java.util.Collections;
import java.util.Set;
import org.hibernate.cache.CacheException;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Option;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.optimistic.DataVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheHelper {
    public static final String ITEM = "item";
    public static final String DUMMY = "dummy";
    private static final Logger log = LoggerFactory.getLogger(CacheHelper.class);

    private CacheHelper() {
    }

    public static boolean isClusteredInvalidation(Cache cache) {
        return CacheHelper.isClusteredInvalidation(cache.getConfiguration().getCacheMode());
    }

    public static boolean isClusteredInvalidation(Configuration.CacheMode cacheMode) {
        return cacheMode == Configuration.CacheMode.INVALIDATION_ASYNC || cacheMode == Configuration.CacheMode.INVALIDATION_SYNC;
    }

    public static boolean isClusteredReplication(Cache cache) {
        return CacheHelper.isClusteredReplication(cache.getConfiguration().getCacheMode());
    }

    public static boolean isClusteredReplication(Configuration.CacheMode cacheMode) {
        return cacheMode == Configuration.CacheMode.REPL_ASYNC || cacheMode == Configuration.CacheMode.REPL_SYNC;
    }

    public static boolean isSynchronous(Cache cache) {
        return CacheHelper.isSynchronous(cache.getConfiguration().getCacheMode());
    }

    public static boolean isSynchronous(Configuration.CacheMode cacheMode) {
        return cacheMode == Configuration.CacheMode.REPL_SYNC || cacheMode == Configuration.CacheMode.INVALIDATION_SYNC;
    }

    public static Set getChildrenNames(Cache cache, Fqn fqn) {
        Node node = cache.getRoot().getChild(fqn);
        return node != null ? node.getChildrenNames() : Collections.emptySet();
    }

    public static Object get(Cache cache, Fqn region, Object key) throws CacheException {
        try {
            return cache.get(new Fqn(region, new Object[]{key}), (Object)ITEM);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static Object getAllowingTimeout(Cache cache, Fqn region, Object key) throws CacheException {
        try {
            return cache.get(new Fqn(region, new Object[]{key}), (Object)ITEM);
        }
        catch (TimeoutException ignored) {
            return null;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static void put(Cache cache, Fqn region, Object key, Object value) throws CacheException {
        CacheHelper.put(cache, region, key, value, null);
    }

    public static void put(Cache cache, Fqn region, Object key, Object value, Option option) throws CacheException {
        try {
            CacheHelper.setInvocationOption(cache, option);
            cache.put(new Fqn(region, new Object[]{key}), (Object)ITEM, value);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static void putAllowingTimeout(Cache cache, Fqn region, Object key, Object value, Option option) throws CacheException {
        try {
            CacheHelper.setInvocationOption(cache, option);
            cache.put(new Fqn(region, new Object[]{key}), (Object)ITEM, value);
        }
        catch (TimeoutException allowed) {
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static boolean putForExternalRead(Cache cache, Fqn region, Object key, Object value) throws CacheException {
        return CacheHelper.putForExternalRead(cache, region, key, value, null);
    }

    public static boolean putForExternalRead(Cache cache, Fqn region, Object key, Object value, Option option) throws CacheException {
        try {
            CacheHelper.setInvocationOption(cache, option);
            cache.putForExternalRead(new Fqn(region, new Object[]{key}), (Object)ITEM, value);
            return true;
        }
        catch (TimeoutException te) {
            log.debug("ignoring write lock acquisition failure");
            return false;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public static void remove(Cache cache, Fqn region, Object key) throws CacheException {
        CacheHelper.remove(cache, region, key, null);
    }

    public static void remove(Cache cache, Fqn region, Object key, Option option) throws CacheException {
        try {
            CacheHelper.setInvocationOption(cache, option);
            cache.removeNode(new Fqn(region, new Object[]{key}));
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static void removeAll(Cache cache, Fqn region) throws CacheException {
        CacheHelper.removeAll(cache, region, null);
    }

    public static void removeAll(Cache cache, Fqn region, Option option) throws CacheException {
        try {
            CacheHelper.setInvocationOption(cache, option);
            cache.removeNode(region);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static void removeNode(Cache cache, Fqn region, Object key, Option option) throws CacheException {
        try {
            CacheHelper.setInvocationOption(cache, option);
            cache.removeNode(new Fqn(region, new Object[]{key}));
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static Node addNode(Cache cache, Fqn fqn, boolean localOnly, boolean resident, DataVersion version) throws CacheException {
        try {
            Option option = null;
            if (localOnly || version != null) {
                option = new Option();
                option.setCacheModeLocal(localOnly);
                option.setDataVersion(version);
            }
            Node root = cache.getRoot();
            CacheHelper.setInvocationOption(cache, option);
            Node added = null;
            if (version == null) {
                added = root.addChild(fqn);
            } else {
                cache.put(fqn, (Object)DUMMY, (Object)DUMMY);
                added = root.getChild(fqn);
            }
            if (resident) {
                added.setResident(true);
            }
            return added;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static void setInvocationOption(Cache cache, Option option) {
        if (option != null) {
            cache.getInvocationContext().setOptionOverrides(option);
        }
    }

    public static void setDataVersionOption(Cache cache, DataVersion version) {
        Option option = new Option();
        option.setDataVersion(version);
        CacheHelper.setInvocationOption(cache, option);
    }

    public static Fqn getInternalFqn(Fqn region) {
        return Fqn.fromRelativeElements((Fqn)region, (Object[])new Internal[]{Internal.NODE});
    }

    public static void sendEvictNotification(Cache cache, Fqn region, Object member, Object key, Option option) {
        CacheHelper.setInvocationOption(cache, option);
        Fqn f = Fqn.fromRelativeElements((Fqn)region, (Object[])new Object[]{Internal.NODE, member == null ? Internal.LOCAL : member, key});
        cache.put(f, (Object)ITEM, (Object)DUMMY);
    }

    public static void sendEvictAllNotification(Cache cache, Fqn region, Object member, Option option) {
        CacheHelper.setInvocationOption(cache, option);
        Fqn f = Fqn.fromRelativeElements((Fqn)region, (Object[])new Object[]{Internal.NODE, member == null ? Internal.LOCAL : member});
        cache.put(f, (Object)ITEM, (Object)DUMMY);
    }

    public static enum Internal {
        NODE,
        LOCAL;

    }
}

