/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tanukisoftware.wrapper.WrapperInfo;
import org.tanukisoftware.wrapper.WrapperJNIError;
import org.tanukisoftware.wrapper.WrapperLicenseError;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperPrintStream;
import org.tanukisoftware.wrapper.WrapperProcess;
import org.tanukisoftware.wrapper.WrapperProcessConfig;
import org.tanukisoftware.wrapper.WrapperProperties;
import org.tanukisoftware.wrapper.WrapperServiceException;
import org.tanukisoftware.wrapper.WrapperShuttingDownException;
import org.tanukisoftware.wrapper.WrapperSystemPropertyUtil;
import org.tanukisoftware.wrapper.WrapperUser;
import org.tanukisoftware.wrapper.WrapperWin32Service;
import org.tanukisoftware.wrapper.event.WrapperControlEvent;
import org.tanukisoftware.wrapper.event.WrapperEvent;
import org.tanukisoftware.wrapper.event.WrapperEventListener;
import org.tanukisoftware.wrapper.event.WrapperLogFileChangedEvent;
import org.tanukisoftware.wrapper.event.WrapperPingEvent;
import org.tanukisoftware.wrapper.event.WrapperServiceControlEvent;
import org.tanukisoftware.wrapper.event.WrapperTickEvent;
import org.tanukisoftware.wrapper.jmx.WrapperManagerTesting;
import org.tanukisoftware.wrapper.resources.ResourceManager;
import org.tanukisoftware.wrapper.security.WrapperEventPermission;
import org.tanukisoftware.wrapper.security.WrapperPermission;
import org.tanukisoftware.wrapper.security.WrapperServicePermission;

public final class WrapperManager
implements Runnable {
    private static final String WRAPPER_CONNECTION_THREAD_NAME = "Wrapper-Connection";
    private static final int DEFAULT_PORT = 15003;
    private static final int DEFAULT_SO_TIMEOUT = 10000;
    private static final int DEFAULT_CPU_TIMEOUT = 10000;
    private static final int TICK_MS = 100;
    private static final int TIMER_FAST_THRESHOLD = 1728000;
    private static final int TIMER_SLOW_THRESHOLD = 1728000;
    private static final byte WRAPPER_MSG_START = 100;
    private static final byte WRAPPER_MSG_STOP = 101;
    private static final byte WRAPPER_MSG_RESTART = 102;
    private static final byte WRAPPER_MSG_PING = 103;
    private static final byte WRAPPER_MSG_STOP_PENDING = 104;
    private static final byte WRAPPER_MSG_START_PENDING = 105;
    private static final byte WRAPPER_MSG_STARTED = 106;
    private static final byte WRAPPER_MSG_STOPPED = 107;
    private static final byte WRAPPER_MSG_KEY = 110;
    private static final byte WRAPPER_MSG_BADKEY = 111;
    private static final byte WRAPPER_MSG_LOW_LOG_LEVEL = 112;
    private static final byte WRAPPER_MSG_PING_TIMEOUT = 113;
    private static final byte WRAPPER_MSG_SERVICE_CONTROL_CODE = 114;
    private static final byte WRAPPER_MSG_PROPERTIES = 115;
    private static final byte WRAPPER_MSG_CHILD_LAUNCH = -124;
    private static final byte WRAPPER_MSG_CHILD_TERM = -123;
    private static final byte WRAPPER_MSG_LOGFILE = -122;
    private static final byte WRAPPER_MSG_APPEAR_ORPHAN = -119;
    private static final byte WRAPPER_MSG_LOG = 116;
    public static final int WRAPPER_CTRL_C_EVENT = 200;
    public static final int WRAPPER_CTRL_CLOSE_EVENT = 201;
    public static final int WRAPPER_CTRL_LOGOFF_EVENT = 202;
    public static final int WRAPPER_CTRL_SHUTDOWN_EVENT = 203;
    public static final int WRAPPER_CTRL_TERM_EVENT = 204;
    public static final int WRAPPER_CTRL_HUP_EVENT = 205;
    public static final int WRAPPER_CTRL_USR1_EVENT = 206;
    public static final int WRAPPER_CTRL_USR2_EVENT = 207;
    public static final int WRAPPER_LOG_LEVEL_DEBUG = 1;
    public static final int WRAPPER_LOG_LEVEL_INFO = 2;
    public static final int WRAPPER_LOG_LEVEL_STATUS = 3;
    public static final int WRAPPER_LOG_LEVEL_WARN = 4;
    public static final int WRAPPER_LOG_LEVEL_ERROR = 5;
    public static final int WRAPPER_LOG_LEVEL_FATAL = 6;
    public static final int WRAPPER_LOG_LEVEL_ADVICE = 7;
    public static final int SERVICE_CONTROL_CODE_START = 65536;
    public static final int SERVICE_CONTROL_CODE_STOP = 1;
    public static final int SERVICE_CONTROL_CODE_PAUSE = 2;
    public static final int SERVICE_CONTROL_CODE_CONTINUE = 3;
    public static final int SERVICE_CONTROL_CODE_INTERROGATE = 4;
    public static final int SERVICE_CONTROL_CODE_SHUTDOWN = 5;
    public static final int SERVICE_CONTROL_CODE_POWEREVENT_QUERYSUSPEND = 3328;
    public static final int SERVICE_CONTROL_CODE_POWEREVENT_QUERYSUSPENDFAILED = 3330;
    public static final int SERVICE_CONTROL_CODE_POWEREVENT_SUSPEND = 3332;
    public static final int SERVICE_CONTROL_CODE_POWEREVENT_RESUMECRITICAL = 3334;
    public static final int SERVICE_CONTROL_CODE_POWEREVENT_RESUMESUSPEND = 3335;
    public static final int SERVICE_CONTROL_CODE_POWEREVENT_BATTERYLOW = 3337;
    public static final int SERVICE_CONTROL_CODE_POWEREVENT_POWERSTATUSCHANGE = 3338;
    public static final int SERVICE_CONTROL_CODE_POWEREVENT_OEMEVENT = 3339;
    public static final int SERVICE_CONTROL_CODE_POWEREVENT_RESUMEAUTOMATIC = 3346;
    private static PrintStream m_out;
    private static PrintStream m_err;
    private static WrapperPrintStream m_outInfo;
    private static WrapperPrintStream m_outError;
    private static WrapperPrintStream m_outDebug;
    private static boolean m_windows;
    private static boolean m_securityManagerChecked;
    private static boolean m_disposed;
    private static boolean m_starting;
    private static boolean m_started;
    private static WrapperManager m_instance;
    private static Thread m_hook;
    private static boolean m_hookTriggered;
    private static boolean m_shutdownJVMComplete;
    private static Map m_shutdownLockMap;
    private static int m_shutdownLocks;
    private static String[] m_args;
    private static int m_port;
    private static int m_jvmPort;
    private static int m_jvmPortMin;
    private static int m_jvmPortMax;
    private static String m_key;
    private static int m_soTimeout;
    private static long m_cpuTimeout;
    private static int m_startedTicks;
    private static int m_lowLogLevel;
    private static int m_pingTimeout;
    private static boolean m_ignoreSignals;
    private static Thread m_commRunner;
    private static boolean m_commRunnerStarted;
    private static Thread m_eventRunner;
    private static int m_eventRunnerTicks;
    private static Thread m_startupRunner;
    private static boolean m_useSystemTime;
    private static int m_timerFastThreshold;
    private static int m_timerSlowThreshold;
    private static boolean m_listenerForceStop;
    private static int m_jvmBits;
    private static volatile int m_ticks;
    private static WrapperListener m_listener;
    private static int m_lastPingTicks;
    private static ServerSocket m_serverSocket;
    private static Socket m_socket;
    private static boolean m_appearHung;
    private static boolean m_ignoreUserLogoffs;
    private static boolean m_service;
    private static boolean m_debug;
    private static int m_jvmId;
    private static boolean m_stopping;
    private static Thread m_stoppingThread;
    private static int m_exitCode;
    private static boolean m_libraryOK;
    private static byte[] m_commandBuffer;
    private static File m_logFile;
    private static WrapperProperties m_properties;
    private static List m_wrapperEventListenerMaskList;
    private static WrapperEventListenerMask[] m_wrapperEventListenerMasks;
    private static boolean m_produceCoreEvents;
    private static ResourceManager m_res;
    private static ResourceManager m_error;
    private static ResourceManager m_warning;
    private static ResourceManager m_info;
    private static char PROPERTY_SEPARATOR;
    private static byte[] m_socketReadBuffer;

    private static void privilegedClassInit() {
        block27: {
            m_out = System.out;
            m_err = System.err;
            m_outInfo = new WrapperPrintStream(m_out, "WrapperManager: ");
            m_outError = new WrapperPrintStream(m_out, "WrapperManager Error: ");
            m_outDebug = new WrapperPrintStream(m_out, "WrapperManager Debug: ");
            m_properties = new WrapperProperties();
            m_properties.lock();
            WrapperManager.checkSecurityManager();
            m_debug = WrapperSystemPropertyUtil.getBooleanProperty("wrapper.debug", false);
            if (m_debug) {
                m_outDebug.println("WrapperManager class initialized by thread: " + Thread.currentThread().getName() + "  Using classloader: " + WrapperManager.class.getClassLoader());
            }
            m_outInfo.println("Initializing...");
            m_jvmId = WrapperSystemPropertyUtil.getIntProperty("wrapper.jvmid", 1);
            if (m_debug) {
                m_outDebug.println("JVM #" + m_jvmId);
            }
            if ((m_jvmBits = WrapperSystemPropertyUtil.getIntProperty("sun.arch.data.model", -1)) == -1) {
                m_jvmBits = WrapperSystemPropertyUtil.getIntProperty("com.ibm.vm.bitmode", -1);
            }
            if (m_debug) {
                if (m_jvmBits > 0) {
                    m_outDebug.println("Running a " + m_jvmBits + "-bit JVM.");
                } else {
                    m_outDebug.println("The bit depth of this JVM could not be determined.");
                }
            }
            m_ticks = 0x7FFFFF37;
            m_useSystemTime = WrapperSystemPropertyUtil.getBooleanProperty("wrapper.use_system_time", false);
            m_timerFastThreshold = WrapperSystemPropertyUtil.getIntProperty("wrapper.timer_fast_threshold", 1728000) * 1000 / 100;
            m_timerSlowThreshold = WrapperSystemPropertyUtil.getIntProperty("wrapper.timer_slow_threshold", 1728000) * 1000 / 100;
            boolean disableShutdownHook = WrapperSystemPropertyUtil.getBooleanProperty("wrapper.disable_shutdown_hook", false);
            m_listenerForceStop = WrapperSystemPropertyUtil.getBooleanProperty("wrapper.listener.force_stop", false);
            if (!disableShutdownHook) {
                if (m_debug) {
                    m_outDebug.println("Registering shutdown hook");
                }
                m_hook = new Thread("Wrapper-Shutdown-Hook"){

                    public void run() {
                        m_hookTriggered = true;
                        if (m_debug) {
                            m_outDebug.println("ShutdownHook started");
                        }
                        m_startupRunner = null;
                        WrapperManager.stop(0);
                        if (m_debug) {
                            m_outDebug.println("ShutdownHook complete");
                        }
                    }
                };
                Runtime.getRuntime().addShutdownHook(m_hook);
            }
            if ((m_key = System.getProperty("wrapper.key")) == null) {
                if (m_debug) {
                    m_outDebug.println("Not using wrapper.  (key not specified)");
                }
                m_port = 0;
                m_jvmPort = 0;
                m_jvmPortMin = 0;
                m_jvmPortMax = 0;
                m_service = false;
                m_cpuTimeout = 31557600000L;
            } else {
                String sPort;
                if (m_debug) {
                    m_outDebug.println("Using wrapper");
                }
                if (WrapperSystemPropertyUtil.getBooleanProperty("wrapper.disable_console_input", false)) {
                    System.setIn(new WrapperInputStream());
                }
                if ((sPort = System.getProperty("wrapper.port")) == null) {
                    String msg = m_res.format("MISSING_PORT");
                    m_outError.println(msg);
                    throw new ExceptionInInitializerError(msg);
                }
                try {
                    m_port = Integer.parseInt(sPort);
                }
                catch (NumberFormatException e) {
                    String msg = m_res.format("BAD_PORT", sPort);
                    m_outError.println(msg);
                    throw new ExceptionInInitializerError(msg);
                }
                m_jvmPort = WrapperSystemPropertyUtil.getIntProperty("wrapper.jvm.port", 0);
                m_jvmPortMin = WrapperSystemPropertyUtil.getIntProperty("wrapper.jvm.port.min", 31000);
                m_jvmPortMax = WrapperSystemPropertyUtil.getIntProperty("wrapper.jvm.port.max", 31999);
                m_ignoreSignals = WrapperSystemPropertyUtil.getBooleanProperty("wrapper.ignore_signals", false);
                m_service = WrapperSystemPropertyUtil.getBooleanProperty("wrapper.service", false);
                String sCPUTimeout = System.getProperty("wrapper.cpu.timeout");
                if (sCPUTimeout == null) {
                    m_cpuTimeout = 10000L;
                } else {
                    try {
                        m_cpuTimeout = (long)Integer.parseInt(sCPUTimeout) * 1000L;
                    }
                    catch (NumberFormatException e) {
                        String msg = m_res.format("BAD_CPU_TIMEOUT", sCPUTimeout);
                        m_outError.println(msg);
                        throw new ExceptionInInitializerError(msg);
                    }
                }
            }
            WrapperManager.verifyWrapperVersion();
            if (WrapperSystemPropertyUtil.getBooleanProperty(WrapperManager.class.getName() + ".mbean", true)) {
                WrapperManager.registerMBean(new org.tanukisoftware.wrapper.jmx.WrapperManager(), "org.tanukisoftware.wrapper:type=WrapperManager");
            }
            if (WrapperSystemPropertyUtil.getBooleanProperty(WrapperManager.class.getName() + ".mbean.testing", false)) {
                WrapperManager.registerMBean(new WrapperManagerTesting(), "org.tanukisoftware.wrapper:type=WrapperManagerTesting");
            }
            WrapperManager.initializeNativeLibrary();
            if (m_libraryOK) {
                WrapperManager.verifyNativeLibraryVersion();
                try {
                    System.setProperty("wrapper.java.pid", Integer.toString(WrapperManager.nativeGetJavaPID()));
                }
                catch (Throwable e) {
                    if (!m_debug) break block27;
                    m_outDebug.println("Call to nativeGetJavaPID() failed: " + e);
                }
            }
        }
        m_eventRunnerTicks = WrapperManager.getTicks();
        m_eventRunner = new Thread("Wrapper-Control-Event-Monitor"){

            public void run() {
                if (m_debug) {
                    m_outDebug.println("Control event monitor thread started.");
                }
                try {
                    WrapperTickEventImpl tickEvent = new WrapperTickEventImpl();
                    int lastTickOffset = 0;
                    boolean first = true;
                    boolean stoppingLogged = false;
                    while (true) {
                        int offsetDiff;
                        if (!m_useSystemTime) {
                            int sysTicks = WrapperManager.getSystemTicks();
                            m_ticks++;
                            int tickOffset = sysTicks - m_ticks;
                            offsetDiff = tickOffset - lastTickOffset;
                            if (first) {
                                first = false;
                            } else if (offsetDiff > m_timerSlowThreshold) {
                                m_outInfo.println("The timer fell behind the system clock by " + offsetDiff * 100 + "ms.");
                            } else if (offsetDiff < -m_timerFastThreshold) {
                                m_outInfo.println("The system clock fell behind the timer by " + -1 * offsetDiff * 100 + "ms.");
                            }
                            lastTickOffset = tickOffset;
                        } else {
                            offsetDiff = 0;
                        }
                        int nowTicks = WrapperManager.getTicks();
                        long age = WrapperManager.getTickAge(m_eventRunnerTicks, nowTicks);
                        if (m_cpuTimeout > 0L && age > m_cpuTimeout) {
                            m_outInfo.println("JVM Process has not received any CPU time for " + age / 1000L + " seconds.  Extending timeouts.");
                            m_lastPingTicks = nowTicks;
                        }
                        m_eventRunnerTicks = nowTicks;
                        if (m_produceCoreEvents) {
                            tickEvent.m_ticks = nowTicks;
                            tickEvent.m_tickOffset = offsetDiff;
                            WrapperManager.fireWrapperEvent(tickEvent);
                        }
                        if (m_libraryOK) {
                            if (!WrapperManager.isShuttingDown()) {
                                int event = 0;
                                do {
                                    if ((event = WrapperManager.nativeGetControlEvent()) == 0) continue;
                                    WrapperManager.controlEvent(event);
                                } while (event != 0);
                            } else if (!stoppingLogged) {
                                stoppingLogged = true;
                                if (m_debug) {
                                    m_outDebug.println("Stopped checking for control events.");
                                }
                            }
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {}
                    }
                }
                catch (Throwable throwable) {
                    if (m_debug) {
                        m_outDebug.println("Control event monitor thread stopped.");
                    }
                    throw throwable;
                }
            }
        };
        m_eventRunner.setDaemon(true);
        m_eventRunner.start();
        String fullVersion = System.getProperty("java.fullversion");
        String vendor = System.getProperty("java.vm.vendor", "");
        String os = System.getProperty("os.name", "").toLowerCase();
        if (fullVersion == null) {
            fullVersion = System.getProperty("java.runtime.version") + " " + System.getProperty("java.vm.name");
        }
        if (m_debug) {
            m_outDebug.println("Java Version   : " + fullVersion);
            m_outDebug.println("Java VM Vendor : " + vendor);
            m_outDebug.println("OS Name        : " + System.getProperty("os.name", ""));
            m_outDebug.println("OS Arch        : " + System.getProperty("os.arch", ""));
            m_outDebug.println();
        }
        m_startupRunner = new Thread("Wrapper-Startup-Runner"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (m_debug) {
                    m_outDebug.println("Startup runner thread started.");
                }
                try {
                    while (m_startupRunner != null) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                finally {
                    if (m_debug) {
                        m_outDebug.println("Startup runner thread stopped.");
                    }
                }
            }
        };
        m_startupRunner.setDaemon(false);
        m_startupRunner.start();
        m_instance = new WrapperManager();
    }

    private static native void nativeInit(boolean var0);

    private static native String nativeGetLibraryVersion();

    private static native int nativeGetJavaPID();

    private static native boolean nativeIsProfessionalEdition();

    private static native boolean nativeIsStandardEdition();

    private static native int nativeGetControlEvent();

    private static native void nativeRequestThreadDump();

    private static native void accessViolationInner();

    private static native void nativeSetConsoleTitle(byte[] var0);

    private static native WrapperUser nativeGetUser(boolean var0);

    private static native WrapperUser nativeGetInteractiveUser(boolean var0);

    private static native WrapperWin32Service[] nativeListServices();

    private static native WrapperWin32Service nativeSendServiceControlCode(byte[] var0, int var1);

    private static native WrapperProcess nativeExec(String[] var0, WrapperProcessConfig var1, boolean var2);

    private static native String nativeWrapperGetEnv(String var0) throws NullPointerException;

    private static int getSystemTicks() {
        return (int)(System.currentTimeMillis() / 100L);
    }

    private static int getTicks() {
        if (m_useSystemTime) {
            return WrapperManager.getSystemTicks();
        }
        return m_ticks;
    }

    private static long getTickAge(int start, int end) {
        return (long)(end - start) * 100L;
    }

    private static String loadNativeLibrary(String name, String file) {
        try {
            System.loadLibrary(name);
            if (m_debug) {
                m_outDebug.println("  Loaded native library: " + file);
            }
            return null;
        }
        catch (UnsatisfiedLinkError e) {
            String error;
            if (m_debug) {
                m_outDebug.println("  Unable to load native library: " + file + "  Cause: " + e.getMessage());
            }
            if ((error = e.getMessage()) == null) {
                error = e.toString();
            }
            return error;
        }
        catch (Throwable e) {
            if (m_debug) {
                m_outDebug.println("Loading native library failed: " + file + "  Cause: " + e);
            }
            String error = e.toString();
            return error;
        }
    }

    private static void registerMBean(Object mbean, String name) {
        Class<?> classManagementFactory;
        try {
            classManagementFactory = Class.forName("java.lang.management.ManagementFactory");
        }
        catch (ClassNotFoundException e) {
            if (m_debug) {
                m_outDebug.println("Registering MBeans not supported by current JVM: " + name);
            }
            return;
        }
        try {
            Class<?> classMBeanServer = Class.forName("javax.management.MBeanServer");
            Class<?> classObjectName = Class.forName("javax.management.ObjectName");
            Method methodGetPlatformMBeanServer = classManagementFactory.getMethod("getPlatformMBeanServer", null);
            Constructor<?> constructorObjectName = classObjectName.getConstructor(String.class);
            Method methodRegisterMBean = classMBeanServer.getMethod("registerMBean", Object.class, classObjectName);
            Object mbs = methodGetPlatformMBeanServer.invoke(null, null);
            Object oName = constructorObjectName.newInstance(name);
            methodRegisterMBean.invoke(mbs, mbean, oName);
            if (m_debug) {
                m_outDebug.println("Registered MBean with Platform MBean Server: " + name);
            }
        }
        catch (Throwable t) {
            m_outError.println("Unable to register the " + name + " MBean.");
            t.printStackTrace(m_outError);
        }
    }

    private static File locateFileOnPath(String file, String path) {
        String pathSep = System.getProperty("path.separator");
        StringTokenizer st = new StringTokenizer(path, pathSep);
        while (st.hasMoreTokens()) {
            File libFile = new File(new File(st.nextToken()), file);
            if (!libFile.exists()) continue;
            return libFile;
        }
        return null;
    }

    private static String generateDetailedNativeLibraryBaseName(String baseName, int jvmBits) {
        String arch;
        String os = System.getProperty("os.name", "").toLowerCase();
        if (os.startsWith("windows")) {
            os = "windows";
            m_windows = true;
        } else if (os.equals("sunos")) {
            os = "solaris";
        } else if (os.equals("hp-ux") || os.equals("hp-ux64")) {
            os = "hpux";
        } else if (os.equals("mac os x")) {
            os = "macosx";
        } else if (os.equals("unix_sv")) {
            os = "unixware";
        } else if (os.equals("os/400")) {
            os = "os400";
        } else if (os.equals("z/os")) {
            os = "zos";
        }
        if (os.equals("macosx")) {
            arch = "universal";
        } else {
            arch = System.getProperty("os.arch", "").toLowerCase();
            if (arch.equals("amd64") || arch.equals("athlon") || arch.equals("x86_64") || arch.equals("i686") || arch.equals("i586") || arch.equals("i486") || arch.equals("i386")) {
                arch = "x86";
            } else if (arch.startsWith("ia32") || arch.startsWith("ia64")) {
                arch = "ia";
            } else if (arch.startsWith("sparc")) {
                arch = "sparc";
            } else if (arch.equals("power") || arch.equals("powerpc") || arch.equals("ppc64")) {
                arch = "ppc";
            } else if (arch.startsWith("pa_risc") || arch.startsWith("pa-risc")) {
                arch = "parisc";
            } else if (arch.equals("s390") || arch.equals("s390x")) {
                arch = "390";
            }
        }
        return baseName + "-" + os + "-" + arch + "-" + jvmBits;
    }

    private static void initializeNativeLibrary() {
        String baseName = System.getProperty("wrapper.native_library");
        if (baseName == null) {
            m_outInfo.println("WARNING - The wrapper.native_library system property was not");
            m_outInfo.println("          set. Using the default value, 'wrapper'.");
            baseName = "wrapper";
        }
        String[] detailedNames = new String[4];
        if (m_jvmBits > 0) {
            detailedNames[0] = WrapperManager.generateDetailedNativeLibraryBaseName(baseName, m_jvmBits);
        } else {
            detailedNames[0] = WrapperManager.generateDetailedNativeLibraryBaseName(baseName, 32);
            detailedNames[1] = WrapperManager.generateDetailedNativeLibraryBaseName(baseName, 64);
        }
        String file = System.mapLibraryName(baseName);
        String[] detailedFiles = new String[detailedNames.length];
        for (int i = 0; i < detailedNames.length; ++i) {
            if (detailedNames[i] == null) continue;
            detailedFiles[i] = System.mapLibraryName(detailedNames[i]);
        }
        String[] detailedErrors = new String[detailedNames.length];
        String baseError = null;
        if (m_debug) {
            m_outDebug.println("Load native library.  One or more attempts may fail if platform specific libraries do not exist.  This is NORMAL and is only a problem if they all fail.");
        }
        m_libraryOK = false;
        for (int i = 0; i < detailedNames.length; ++i) {
            if (detailedNames[i] == null) continue;
            detailedErrors[i] = WrapperManager.loadNativeLibrary(detailedNames[i], detailedFiles[i]);
            if (detailedErrors[i] != null) continue;
            m_libraryOK = true;
            break;
        }
        if (!m_libraryOK && (baseError = WrapperManager.loadNativeLibrary(baseName, file)) == null) {
            m_libraryOK = true;
        }
        if (m_libraryOK) {
            if (m_debug) {
                m_outDebug.println("Calling native initialization method.");
            }
            WrapperManager.nativeInit(m_debug);
        } else {
            String libPath = System.getProperty("java.library.path");
            m_outInfo.println();
            if (libPath.equals("")) {
                m_outInfo.println("WARNING - Unable to load the Wrapper's native library because the");
                m_outInfo.println("          java.library.path was set to ''.  Please see the");
                m_outInfo.println("          documentation for the wrapper.java.library.path ");
                m_outInfo.println("          configuration property.");
            } else {
                int i;
                String error = null;
                File libFile = null;
                for (i = 0; i < detailedNames.length; ++i) {
                    if (detailedFiles[i] == null || (libFile = WrapperManager.locateFileOnPath(detailedFiles[i], libPath)) == null) continue;
                    error = detailedErrors[i];
                    break;
                }
                if (libFile == null && (libFile = WrapperManager.locateFileOnPath(file, libPath)) != null) {
                    error = baseError;
                }
                if (libFile == null) {
                    m_outInfo.println("WARNING - Unable to load the Wrapper's native library because none of the");
                    m_outInfo.println("          following files:");
                    for (i = 0; i < detailedNames.length; ++i) {
                        if (detailedFiles[i] == null) continue;
                        m_outInfo.println("            " + detailedFiles[i]);
                    }
                    m_outInfo.println("            " + file);
                    m_outInfo.println("          could be located on the following java.library.path:");
                    String pathSep = System.getProperty("path.separator");
                    StringTokenizer st = new StringTokenizer(libPath, pathSep);
                    while (st.hasMoreTokens()) {
                        File pathElement = new File(st.nextToken());
                        m_outInfo.println("            " + pathElement.getAbsolutePath());
                    }
                    m_outInfo.println("          Please see the documentation for the wrapper.java.library.path");
                    m_outInfo.println("          configuration property.");
                } else {
                    m_outInfo.println("WARNING - Unable to load the Wrapper's native library '" + libFile.getName() + "'.");
                    m_outInfo.println("          The file is located on the path at the following location but");
                    m_outInfo.println("          could not be loaded:");
                    m_outInfo.println("            " + libFile.getAbsolutePath());
                    m_outInfo.println("          Please verify that the file is both readable and executable by the");
                    m_outInfo.println("          current user and that the file has not been corrupted in any way.");
                    m_outInfo.println("          One common cause of this problem is running a 32-bit version");
                    m_outInfo.println("          of the Wrapper with a 64-bit version of Java, or vica versa.");
                    if (m_jvmBits > 0) {
                        m_outInfo.println("          This is a " + m_jvmBits + "-bit JVM.");
                    } else {
                        m_outInfo.println("          The bit depth of this JVM could not be determined.");
                    }
                    m_outInfo.println("          Reported cause:");
                    m_outInfo.println("            " + error);
                }
            }
            m_outInfo.println("          System signals will not be handled correctly.");
            m_outInfo.println();
        }
    }

    private static void verifyWrapperVersion() {
        if (!WrapperManager.isControlledByNativeWrapper()) {
            return;
        }
        String wrapperVersion = System.getProperty("wrapper.version");
        if (wrapperVersion == null) {
            wrapperVersion = "unknown";
        }
        if (wrapperVersion.endsWith("-pro")) {
            wrapperVersion = wrapperVersion.substring(0, wrapperVersion.length() - 4);
        } else if (wrapperVersion.endsWith("-st")) {
            wrapperVersion = wrapperVersion.substring(0, wrapperVersion.length() - 3);
        }
        if (!WrapperInfo.getVersion().equals(wrapperVersion)) {
            m_outInfo.println("WARNING - The Wrapper jar file currently in use is version \"" + WrapperInfo.getVersion() + "\"");
            m_outInfo.println("          while the version of the Wrapper which launched this JVM is ");
            m_outInfo.println("          \"" + wrapperVersion + "\".");
            m_outInfo.println("          The Wrapper may appear to work correctly but some features may");
            m_outInfo.println("          not function correctly.  This configuration has not been tested");
            m_outInfo.println("          and is not supported.");
            m_outInfo.println();
        }
    }

    private static void verifyNativeLibraryVersion() {
        String jniVersion;
        try {
            jniVersion = WrapperManager.nativeGetLibraryVersion();
        }
        catch (Throwable e) {
            if (m_debug) {
                m_outDebug.println("Call to nativeGetLibraryVersion() failed: " + e);
            }
            jniVersion = "unknown";
        }
        String wrapperVersion = System.getProperty("wrapper.version");
        if (wrapperVersion == null) {
            wrapperVersion = "unknown";
        }
        if (!wrapperVersion.equals(jniVersion)) {
            m_outInfo.println("WARNING - The version of the Wrapper which launched this JVM is ");
            m_outInfo.println("          \"" + wrapperVersion + "\" while the version of the native library ");
            m_outInfo.println("          is \"" + jniVersion + "\".");
            m_outInfo.println("          The Wrapper may appear to work correctly but some features may");
            m_outInfo.println("          not function correctly.  This configuration has not been tested");
            m_outInfo.println("          and is not supported.");
            m_outInfo.println();
        }
    }

    public static String getVersion() {
        return WrapperInfo.getVersion();
    }

    public static String getBuildTime() {
        return WrapperInfo.getBuildTime();
    }

    public static int getJVMId() {
        return m_jvmId;
    }

    private static String[] parseCommandLine(String commandLine) {
        Pattern pattern = Pattern.compile("(\".*?\"|\\S+)", 2);
        Matcher match = pattern.matcher(commandLine);
        LinkedList<String> tokenList = new LinkedList<String>();
        int j = 0;
        while (match.find()) {
            tokenList.add(match.group(1));
            ++j;
        }
        String[] result = new String[j];
        Iterator iterator = tokenList.iterator();
        String quoteString = "\"";
        for (int i = 0; i < j; ++i) {
            String field = (String)iterator.next();
            if (!field.startsWith("\"")) {
                // empty if block
            }
            result[i] = field;
        }
        return result;
    }

    public static WrapperProcess exec(String command) throws SecurityException, IOException, NullPointerException, IllegalArgumentException, WrapperJNIError, WrapperLicenseError, UnsatisfiedLinkError {
        WrapperProcess proc = WrapperManager.exec(command, new WrapperProcessConfig());
        return proc;
    }

    public static WrapperProcess exec(String command, WrapperProcessConfig config) throws SecurityException, IOException, NullPointerException, IllegalArgumentException, WrapperJNIError, WrapperLicenseError, UnsatisfiedLinkError {
        if (command == null || command.length() == 0) {
            throw new IllegalArgumentException("no command specified.");
        }
        return WrapperManager.exec(WrapperManager.parseCommandLine(command), config);
    }

    public static WrapperProcess exec(String[] cmdArray) throws SecurityException, IOException, NullPointerException, IndexOutOfBoundsException, IllegalArgumentException, WrapperJNIError, UnsatisfiedLinkError, WrapperLicenseError {
        WrapperProcess proc = WrapperManager.exec(cmdArray, new WrapperProcessConfig());
        return proc;
    }

    public static WrapperProcess exec(String[] cmdArray, WrapperProcessConfig config) throws SecurityException, IOException, NullPointerException, IndexOutOfBoundsException, IllegalArgumentException, WrapperJNIError, WrapperLicenseError, UnsatisfiedLinkError {
        if (!WrapperManager.isProfessionalEdition()) {
            throw new WrapperLicenseError("Requires the Professional Edition.");
        }
        if (cmdArray == null) {
            throw new NullPointerException("cmdArray is null");
        }
        if (cmdArray.length == 0) {
            throw new IndexOutOfBoundsException("cmdArray is empty");
        }
        if (config == null) {
            throw new NullPointerException("config is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkExec(cmdArray[0]);
        }
        if (m_libraryOK) {
            for (int i = 0; i < cmdArray.length; ++i) {
                if (cmdArray[i] != null) continue;
                throw new NullPointerException(MessageFormat.format("cmdarray[{0}]: Invalid element (isNull).", new Integer(i)));
            }
            if (!m_windows && !new File(cmdArray[0]).exists()) {
                boolean found = false;
                String path = WrapperManager.nativeWrapperGetEnv("PATH");
                if (path != null) {
                    String[] paths = path.split(File.pathSeparator);
                    for (int i = 0; i < paths.length; ++i) {
                        File file = new File(paths[i] + File.separator + cmdArray[0]);
                        if (!file.exists()) continue;
                        cmdArray[0] = file.getPath();
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    throw new IOException(MessageFormat.format("''{0}'' not found.", cmdArray[0]));
                }
            }
            if (m_debug) {
                for (int j = 0; j < cmdArray.length; ++j) {
                    m_outDebug.println("args[" + j + "] = " + cmdArray[j]);
                }
            }
            return WrapperManager.nativeExec(cmdArray, config.setEnvironment(config.getEnvironment()), WrapperSystemPropertyUtil.getBooleanProperty("wrapper.child.allowCWDOnSpawn", false));
        }
        throw new WrapperJNIError("Wrapper native library not loaded.");
    }

    public static boolean isProfessionalEdition() {
        if (m_libraryOK) {
            try {
                return WrapperManager.nativeIsProfessionalEdition();
            }
            catch (Throwable e) {
                if (m_debug) {
                    m_outDebug.println("Call to nativeIsProfessionalEdition() failed: " + e);
                }
                return false;
            }
        }
        return false;
    }

    public static boolean isStandardEdition() {
        if (m_libraryOK) {
            try {
                return WrapperManager.nativeIsStandardEdition();
            }
            catch (Throwable e) {
                if (m_debug) {
                    m_outDebug.println("Call to nativeIsStandardEdition() failed: " + e);
                }
                return false;
            }
        }
        return false;
    }

    public static void setConsoleTitle(String title) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("setConsoleTitle"));
        }
        if (m_libraryOK) {
            byte[] titleBytes = title.getBytes();
            byte[] nullTermBytes = new byte[titleBytes.length + 1];
            System.arraycopy(titleBytes, 0, nullTermBytes, 0, titleBytes.length);
            nullTermBytes[titleBytes.length] = 0;
            WrapperManager.nativeSetConsoleTitle(nullTermBytes);
        }
    }

    public static WrapperUser getUser(boolean groups) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("getUser"));
        }
        WrapperUser user = null;
        if (m_libraryOK) {
            user = WrapperManager.nativeGetUser(groups);
        }
        return user;
    }

    public static WrapperUser getInteractiveUser(boolean groups) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("getInteractiveUser"));
        }
        WrapperUser user = null;
        if (m_libraryOK) {
            user = WrapperManager.nativeGetInteractiveUser(groups);
        }
        return user;
    }

    public static Properties getProperties() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("getProperties"));
        }
        return m_properties;
    }

    public static int getWrapperPID() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("getWrapperPID"));
        }
        return WrapperSystemPropertyUtil.getIntProperty("wrapper.pid", 0);
    }

    public static int getJavaPID() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("getJavaPID"));
        }
        return WrapperSystemPropertyUtil.getIntProperty("wrapper.java.pid", 0);
    }

    public static void requestThreadDump() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("requestThreadDump"));
        }
        if (m_libraryOK) {
            WrapperManager.nativeRequestThreadDump();
        } else {
            m_outInfo.println("  wrapper library not loaded.");
        }
    }

    public static void appearHung() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("test.appearHung"));
        }
        m_outInfo.println("WARNING: Making JVM appear to be hung...");
        m_appearHung = true;
    }

    public static void appearOrphan() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("test.appearOrphan"));
        }
        m_outInfo.println("WARNING: Making JVM appear to be orphaned...");
        WrapperManager.sendCommand((byte)-119, "");
    }

    public static void accessViolation() {
        block4: {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new WrapperPermission("test.accessViolation"));
            }
            m_outInfo.println("WARNING: Attempting to cause an access violation...");
            try {
                Class<?> c = Class.forName("java.lang.String");
                Method method = c.getDeclaredMethod(null, null);
            }
            catch (NoSuchMethodException ex) {
            }
            catch (Exception ex) {
                if (ex instanceof NoSuchFieldException) break block4;
                ex.printStackTrace(m_outError);
            }
        }
        m_outInfo.println("  Attempt to cause access violation failed.  JVM is still alive.");
    }

    public static void accessViolationNative() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("test.accessViolationNative"));
        }
        m_outInfo.println("WARNING: Attempting to cause an access violation...");
        if (m_libraryOK) {
            WrapperManager.accessViolationInner();
            m_outInfo.println("  Attempt to cause access violation failed.  JVM is still alive.");
        } else {
            m_outInfo.println("  wrapper library not loaded.");
        }
    }

    public static boolean isControlledByNativeWrapper() {
        return m_key != null;
    }

    public static boolean isLaunchedAsService() {
        return m_service;
    }

    public static boolean isIgnoreUserLogoffs() {
        return m_ignoreUserLogoffs;
    }

    public static boolean isDebugEnabled() {
        return m_debug;
    }

    public static void start(final WrapperListener listener, final String[] args) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                WrapperManager.privilegedStart(listener, args);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void privilegedStart(WrapperListener listener, String[] args) {
        WrapperManager.checkSecurityManager();
        if (args == null) {
            args = new String[]{};
        }
        if (m_debug) {
            StringBuffer sb = new StringBuffer();
            sb.append("args[");
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("\"");
                sb.append(args[i]);
                sb.append("\"");
            }
            sb.append("]");
            m_outDebug.println("WrapperManager.start(" + listener + ", " + sb.toString() + ") " + "called by thread: " + Thread.currentThread().getName());
        }
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            if (m_disposed) {
                throw new IllegalStateException("WrapperManager has already been disposed.");
            }
            if (m_listener != null) {
                throw new IllegalStateException("WrapperManager has already been started with a WrapperListener.");
            }
            if (listener == null) {
                throw new IllegalStateException("A WrapperListener must be specified.");
            }
            m_listener = listener;
            m_args = args;
            WrapperManager.startRunner();
            if (!WrapperManager.isControlledByNativeWrapper()) {
                WrapperManager.startInner(true);
            }
        }
    }

    public static boolean isShuttingDown() {
        return m_stopping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void requestShutdownLock() throws WrapperShuttingDownException {
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            if (m_stopping) {
                throw new WrapperShuttingDownException();
            }
            Thread thisThread = Thread.currentThread();
            ShutdownLock lock = (ShutdownLock)m_shutdownLockMap.get(thisThread);
            if (lock == null) {
                lock = new ShutdownLock(thisThread);
                m_shutdownLockMap.put(thisThread, lock);
            }
            lock.m_count++;
            ++m_shutdownLocks;
            if (m_debug) {
                m_outDebug.println("WrapperManager.requestShutdownLock() called by thread: " + thisThread.getName() + ". New thread lock count: " + lock.m_count + ", total lock count: " + m_shutdownLocks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseShutdownLock() throws IllegalStateException {
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            Thread thisThread = Thread.currentThread();
            ShutdownLock lock = (ShutdownLock)m_shutdownLockMap.get(thisThread);
            if (lock == null) {
                throw new IllegalStateException("requestShutdownLock was not called from this thread.");
            }
            lock.m_count--;
            --m_shutdownLocks;
            if (m_debug) {
                m_outDebug.println("WrapperManager.releaseShutdownLock() called by thread: " + thisThread.getName() + ". New thread lock count: " + lock.m_count + ", total lock count: " + m_shutdownLocks);
            }
            if (lock.m_count <= 0) {
                m_shutdownLockMap.remove(thisThread);
            }
            WrapperManager.class.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForShutdownLocks() {
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            if (m_debug) {
                m_outDebug.println("wait for " + m_shutdownLocks + " shutdown locs to be released.");
            }
            while (m_shutdownLocks > 0) {
                try {
                    (class$org$tanukisoftware$wrapper$WrapperManager == null ? WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager") : class$org$tanukisoftware$wrapper$WrapperManager).wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (m_shutdownLocks <= 0) continue;
                m_outInfo.println("Waiting for " + m_shutdownLocks + " shutdown locks to be released...");
            }
        }
    }

    public static void restart() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("restart"));
        }
        if (m_debug) {
            m_outDebug.println("WrapperManager.restart() called by thread: " + Thread.currentThread().getName());
        }
        WrapperManager.restartInner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restartAndReturn() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("restart"));
        }
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            if (m_stopping) {
                if (m_debug) {
                    m_outDebug.println("WrapperManager.restartAndReturn() called by thread: " + Thread.currentThread().getName() + " already stopping.");
                }
                return;
            }
            if (m_debug) {
                m_outDebug.println("WrapperManager.restartAndReturn() called by thread: " + Thread.currentThread().getName());
            }
        }
        Thread restarter = new Thread("Wrapper-Restarter"){

            public void run() {
                WrapperManager.restartInner();
            }
        };
        restarter.setDaemon(false);
        restarter.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restartInner() {
        boolean stopping;
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            stopping = m_stopping;
            if (!stopping) {
                m_stopping = true;
            }
        }
        if (!stopping) {
            WrapperManager.sendCommand((byte)102, "restart");
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                WrapperManager.privilegedStopInner(0);
                return null;
            }
        });
    }

    public static void stop(final int exitCode) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("stop"));
        }
        if (m_debug) {
            m_outDebug.println("WrapperManager.stop(" + exitCode + ") called by thread: " + Thread.currentThread().getName());
        }
        WrapperManager.stopCommon(exitCode, 1000);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                WrapperManager.privilegedStopInner(exitCode);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAndReturn(final int exitCode) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("stop"));
        }
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            if (m_stopping) {
                if (m_debug) {
                    m_outDebug.println("WrapperManager.stopAndReturn(" + exitCode + ") called by thread: " + Thread.currentThread().getName() + " already stopping.");
                }
                return;
            }
            if (m_debug) {
                m_outDebug.println("WrapperManager.stopAndReturn(" + exitCode + ") called by thread: " + Thread.currentThread().getName());
            }
        }
        Thread stopper = new Thread("Wrapper-Stopper"){

            public void run() {
                WrapperManager.stopCommon(exitCode, 1000);
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        WrapperManager.privilegedStopInner(exitCode);
                        return null;
                    }
                });
            }
        };
        stopper.setDaemon(false);
        stopper.start();
    }

    public static void stopImmediate(final int exitCode) {
        Method haltMethod;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("stopImmediate"));
        }
        if (m_debug) {
            m_outDebug.println("WrapperManager.stopImmediate(" + exitCode + ") called by thread: " + Thread.currentThread().getName());
        }
        WrapperManager.stopCommon(exitCode, 250);
        WrapperManager.signalStopped(exitCode);
        try {
            haltMethod = Runtime.class.getMethod("halt", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            m_outError.println("halt not supported by current JVM.");
            haltMethod = null;
        }
        if (haltMethod != null) {
            Runtime runtime = Runtime.getRuntime();
            try {
                haltMethod.invoke((Object)runtime, new Integer(exitCode));
            }
            catch (IllegalAccessException e) {
                m_outError.println("Unable to call runtime.halt: " + e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t == null) {
                    t = e;
                }
                m_outError.println("Unable to call runtime.halt: " + t);
            }
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    WrapperManager.privilegedStopInner(exitCode);
                    return null;
                }
            });
        }
    }

    public static void signalStarting(int waitHint) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("signalStarting"));
        }
        WrapperManager.sendCommand((byte)105, Integer.toString(waitHint));
    }

    public static void signalStopping(int waitHint) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("signalStopping"));
        }
        m_stopping = true;
        WrapperManager.sendCommand((byte)104, Integer.toString(waitHint));
    }

    public static void signalStopped(int exitCode) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("signalStopped"));
        }
        m_stopping = true;
        WrapperManager.sendCommand((byte)107, Integer.toString(exitCode));
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean hasShutdownHookBeenTriggered() {
        return m_hookTriggered;
    }

    public static void log(int logLevel, String message) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("log"));
        }
        if (logLevel < 1 || logLevel > 7) {
            throw new IllegalArgumentException("The specified logLevel is not valid.");
        }
        if (message == null) {
            throw new IllegalArgumentException("The message parameter can not be null.");
        }
        if (m_lowLogLevel <= logLevel) {
            WrapperManager.sendCommand((byte)(116 + logLevel), message);
        }
    }

    public static WrapperWin32Service[] listServices() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            throw new SecurityException("A SecurityManager has not yet been set.");
        }
        sm.checkPermission(new WrapperPermission("listServices"));
        if (m_libraryOK) {
            return WrapperManager.nativeListServices();
        }
        return null;
    }

    public static WrapperWin32Service sendServiceControlCode(String serviceName, int controlCode) throws WrapperServiceException, SecurityException {
        String action;
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            throw new SecurityException("A SecurityManager has not yet been set.");
        }
        switch (controlCode) {
            case 65536: {
                action = WrapperServicePermission.ACTION_START;
                break;
            }
            case 1: {
                action = WrapperServicePermission.ACTION_STOP;
                break;
            }
            case 2: {
                action = WrapperServicePermission.ACTION_PAUSE;
                break;
            }
            case 3: {
                action = WrapperServicePermission.ACTION_CONTINUE;
                break;
            }
            case 4: {
                action = WrapperServicePermission.ACTION_INTERROGATE;
                break;
            }
            default: {
                if (controlCode >= 128 && controlCode <= 255) {
                    action = WrapperServicePermission.ACTION_USER_CODE;
                    break;
                }
                throw new IllegalArgumentException("The specified controlCode is invalid.");
            }
        }
        sm.checkPermission(new WrapperServicePermission(serviceName, action));
        WrapperWin32Service service = null;
        if (m_libraryOK) {
            service = WrapperManager.nativeSendServiceControlCode(serviceName.getBytes(), controlCode);
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addWrapperEventListener(WrapperEventListener listener, long mask) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            if ((mask & 1L) != 0L) {
                first = false;
                sb.append(WrapperEventPermission.EVENT_TYPE_SERVICE);
            }
            if ((mask & 2L) != 0L) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(WrapperEventPermission.EVENT_TYPE_CONTROL);
            }
            if ((mask & 0xF000000000000000L) != 0L) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(WrapperEventPermission.EVENT_TYPE_CORE);
            }
            sm.checkPermission(new WrapperEventPermission(sb.toString()));
        }
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            WrapperEventListenerMask listenerMask = new WrapperEventListenerMask();
            listenerMask.m_listener = listener;
            listenerMask.m_mask = mask;
            m_wrapperEventListenerMaskList.add(listenerMask);
            m_wrapperEventListenerMasks = null;
        }
        WrapperManager.updateWrapperEventListenerFlags();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeWrapperEventListener(WrapperEventListener listener) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new WrapperPermission("removeWrapperEventListener"));
        }
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            Iterator iter = m_wrapperEventListenerMaskList.iterator();
            while (iter.hasNext()) {
                WrapperEventListenerMask listenerMask = (WrapperEventListenerMask)iter.next();
                if (listenerMask.m_listener != listener) continue;
                iter.remove();
                m_wrapperEventListenerMasks = null;
                break;
            }
        }
        WrapperManager.updateWrapperEventListenerFlags();
    }

    public static File getWrapperLogFile() {
        File logFile = m_logFile;
        if (logFile == null) {
            throw new IllegalStateException("Not yet initialized.");
        }
        return logFile;
    }

    private WrapperManager() {
    }

    private static void checkSecurityManager() {
        if (m_securityManagerChecked) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (m_debug) {
                m_outDebug.println("Detected a SecurityManager: " + securityManager.getClass().getName());
            }
            try {
                securityManager.checkPermission(new AllPermission());
            }
            catch (SecurityException e) {
                m_outDebug.println();
                m_outDebug.println("WARNING - Detected that a SecurityManager has been installed but the ");
                m_outDebug.println("          wrapper.jar has not been granted the java.security.AllPermission");
                m_outDebug.println("          permission.  This will most likely result in SecurityExceptions");
                m_outDebug.println("          being thrown by the Wrapper.");
                m_outDebug.println();
            }
            m_securityManagerChecked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WrapperEventListenerMask[] getWrapperEventListenerMasks() {
        WrapperEventListenerMask[] listenerMasks = m_wrapperEventListenerMasks;
        if (listenerMasks == null) {
            Class clazz = WrapperManager.class;
            synchronized (clazz) {
                if (listenerMasks == null) {
                    listenerMasks = new WrapperEventListenerMask[m_wrapperEventListenerMaskList.size()];
                    m_wrapperEventListenerMaskList.toArray(listenerMasks);
                    m_wrapperEventListenerMasks = listenerMasks;
                }
            }
        }
        return listenerMasks;
    }

    private static void updateWrapperEventListenerFlags() {
        boolean core = false;
        WrapperEventListenerMask[] listenerMasks = WrapperManager.getWrapperEventListenerMasks();
        for (int i = 0; i < listenerMasks.length; ++i) {
            long mask = listenerMasks[i].m_mask;
            core |= (mask & 0xF000000000000000L) != 0L;
        }
        m_produceCoreEvents = core;
    }

    private static void fireWrapperEvent(WrapperEvent event) {
        long eventMask = event.getFlags();
        WrapperEventListenerMask[] listenerMasks = WrapperManager.getWrapperEventListenerMasks();
        for (int i = 0; i < listenerMasks.length; ++i) {
            long listenerMask = listenerMasks[i].m_mask;
            if ((listenerMask & eventMask) == 0L) continue;
            WrapperEventListener listener = listenerMasks[i].m_listener;
            try {
                listener.fired(event);
                continue;
            }
            catch (Throwable t) {
                m_outError.println("Encountered an uncaught exception while notifying WrapperEventListener of an event:");
                t.printStackTrace(m_outError);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopCommon(int exitCode, int delay) {
        boolean stopping;
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            stopping = m_stopping;
            if (!stopping) {
                m_stopping = true;
            }
        }
        if (!stopping) {
            WrapperManager.sendCommand((byte)101, Integer.toString(exitCode));
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dispose() {
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            m_disposed = true;
            WrapperManager.closeSocket();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static void startCompleted() {
        m_startedTicks = WrapperManager.getTicks();
        m_startupRunner = null;
        WrapperManager.checkSecurityManager();
        WrapperManager.signalStarted();
        WrapperManager.class.notifyAll();
    }

    private static void startInner(boolean block) {
        int oldPriority = Thread.currentThread().getPriority();
        Thread.currentThread().setPriority(5);
        m_starting = true;
        if (m_listener == null) {
            if (m_debug) {
                m_outDebug.println("No WrapperListener has been set.  Nothing to start.");
            }
            WrapperManager.startCompleted();
        } else {
            if (m_debug) {
                m_outDebug.println("calling WrapperListener.start()");
            }
            final Integer[] resultF = new Integer[1];
            final Throwable[] tF = new Throwable[1];
            Thread startRunner = new Thread("WrapperListener_start_runner"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (m_debug) {
                        m_outDebug.println("WrapperListener.start runner thread started.");
                    }
                    try {
                        try {
                            resultF[0] = m_listener.start(m_args);
                        }
                        catch (Throwable t) {
                            tF[0] = t;
                        }
                        Object var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        if (tF[0] != null) {
                            m_outError.println("Error in WrapperListener.start callback.  " + tF[0]);
                            tF[0].printStackTrace(m_outError);
                            WrapperManager.privilegedStopInner(1);
                            return;
                        }
                        if (m_debug) {
                            m_outDebug.println("returned from WrapperListener.start()");
                        }
                        if (resultF[0] != null) {
                            int exitCode = resultF[0];
                            if (m_debug) {
                                m_outDebug.println("WrapperListener.start() returned an exit code of " + exitCode + ".");
                            }
                            WrapperManager.stop(exitCode);
                            return;
                        }
                        Class clazz = class$org$tanukisoftware$wrapper$WrapperManager == null ? (class$org$tanukisoftware$wrapper$WrapperManager = WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager")) : class$org$tanukisoftware$wrapper$WrapperManager;
                        synchronized (clazz) {
                            WrapperManager.startCompleted();
                        }
                        if (m_debug) {
                            m_outDebug.println("WrapperListener.start runner thread stopped.");
                        }
                        throw throwable;
                    }
                    if (tF[0] != null) {
                        m_outError.println("Error in WrapperListener.start callback.  " + tF[0]);
                        tF[0].printStackTrace(m_outError);
                        WrapperManager.privilegedStopInner(1);
                        return;
                    }
                    if (m_debug) {
                        m_outDebug.println("returned from WrapperListener.start()");
                    }
                    if (resultF[0] != null) {
                        int exitCode = resultF[0];
                        if (m_debug) {
                            m_outDebug.println("WrapperListener.start() returned an exit code of " + exitCode + ".");
                        }
                        WrapperManager.stop(exitCode);
                        return;
                    }
                    Class clazz = class$org$tanukisoftware$wrapper$WrapperManager == null ? (class$org$tanukisoftware$wrapper$WrapperManager = WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager")) : class$org$tanukisoftware$wrapper$WrapperManager;
                    synchronized (clazz) {
                        WrapperManager.startCompleted();
                    }
                    if (m_debug) {
                        m_outDebug.println("WrapperListener.start runner thread stopped.");
                    }
                }
            };
            startRunner.setDaemon(false);
            startRunner.start();
            Thread.currentThread().setPriority(oldPriority);
            if (block) {
                if (m_debug) {
                    m_outDebug.println("Waiting for WrapperListener.start runner thread to complete.");
                }
                while (startRunner != null && startRunner.isAlive()) {
                    try {
                        (class$org$tanukisoftware$wrapper$WrapperManager == null ? WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager") : class$org$tanukisoftware$wrapper$WrapperManager).wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
    }

    private static void shutdownJVM(int exitCode) {
        if (m_debug) {
            m_outDebug.println("shutdownJVM(" + exitCode + ") Thread:" + Thread.currentThread().getName());
        }
        WrapperManager.waitForShutdownLocks();
        WrapperManager.signalStopped(exitCode);
        WrapperManager.dispose();
        m_shutdownJVMComplete = true;
        if (Thread.currentThread() != m_hook) {
            if (m_debug) {
                m_outDebug.println("calling System.exit(" + exitCode + ")");
            }
            WrapperManager.safeSystemExit(exitCode);
        }
    }

    private static void safeSystemExit(int exitCode) {
        try {
            System.exit(exitCode);
        }
        catch (IllegalThreadStateException e) {
            m_outError.println("Attempted System.exit(" + exitCode + ") call failed: " + e.toString());
            m_outError.println("   Trying Runtime.halt(" + exitCode + ")");
            Runtime.getRuntime().halt(exitCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void privilegedStopInner(int exitCode) {
        boolean block;
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            m_stopping = true;
            if (m_stoppingThread == null) {
                m_stoppingThread = Thread.currentThread();
                block = false;
            } else {
                if (Thread.currentThread() == m_stoppingThread) {
                    throw new IllegalStateException("WrapperManager.stop() can not be called recursively.");
                }
                block = true;
            }
        }
        if (block) {
            if (m_debug) {
                m_outDebug.println("Thread, " + Thread.currentThread().getName() + ", waiting for the JVM to exit.");
                if (Thread.currentThread() == m_hook) {
                    m_outDebug.println("System.exit appears to have been called from within the");
                    m_outDebug.println("  WrapperListener.stop() method.  If possible the application");
                    m_outDebug.println("  should be modified to avoid this behavior.");
                    m_outDebug.println("  To avoid a deadlock, this thread will only wait 5 seconds");
                    m_outDebug.println("  for the application to shutdown.  This may result in the");
                    m_outDebug.println("  application failing to shutdown completely before the JVM");
                    m_outDebug.println("  exists.  Removing the offending System.exit call will");
                    m_outDebug.println("  resolve this.");
                }
            }
            int loops = 0;
            int wait = 50;
            while (true) {
                try {
                    Thread.sleep(wait);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (Thread.currentThread() == m_hook && (m_shutdownJVMComplete || loops > 5000 / wait)) {
                    if (!m_shutdownJVMComplete && m_debug) {
                        m_outDebug.println("Thread, " + Thread.currentThread().getName() + ", continuing after 5 seconds.");
                    }
                    WrapperManager.signalStopped(m_exitCode);
                    return;
                }
                ++loops;
            }
        }
        if (m_debug) {
            m_outDebug.println("Thread, " + Thread.currentThread().getName() + ", handling the shutdown process.");
        }
        m_exitCode = exitCode;
        if (Thread.currentThread() != m_hook && !m_hookTriggered && m_hook != null) {
            Runtime.getRuntime().removeShutdownHook(m_hook);
        }
        int code = exitCode;
        if (m_listenerForceStop && m_starting || m_started) {
            int oldPriority = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(5);
            if (m_listener == null) {
                if (m_debug) {
                    m_outDebug.println("No WrapperListener has been set.  Nothing to stop.");
                }
            } else {
                if (m_debug) {
                    m_outDebug.println("calling listener.stop()");
                }
                if (Thread.currentThread().isDaemon()) {
                    final Integer[] codeF = new Integer[]{new Integer(code)};
                    Thread stopRunner = new Thread("WrapperListener_stop_runner"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            if (m_debug) {
                                m_outDebug.println("WrapperListener.stop runner thread started.");
                            }
                            try {
                                try {
                                    codeF[0] = new Integer(m_listener.stop(codeF[0]));
                                }
                                catch (Throwable t) {
                                    m_outError.println("Error in WrapperListener.stop callback.");
                                    t.printStackTrace(m_outError);
                                }
                                Object var3_2 = null;
                            }
                            catch (Throwable throwable) {
                                Object var3_3 = null;
                                if (m_debug) {
                                    m_outDebug.println("WrapperListener.stop runner thread stopped.");
                                }
                                throw throwable;
                            }
                            if (m_debug) {
                                m_outDebug.println("WrapperListener.stop runner thread stopped.");
                            }
                        }
                    };
                    stopRunner.setDaemon(false);
                    stopRunner.start();
                    if (m_debug) {
                        m_outDebug.println("Waiting for WrapperListener.stop runner thread to complete.");
                    }
                    while (stopRunner != null && stopRunner.isAlive()) {
                        try {
                            stopRunner.join();
                            stopRunner = null;
                        }
                        catch (InterruptedException e) {}
                    }
                    code = codeF[0];
                } else {
                    try {
                        code = m_listener.stop(code);
                    }
                    catch (Throwable t) {
                        m_outError.println("Error in WrapperListener.stop callback.");
                        t.printStackTrace(m_outError);
                    }
                }
                if (m_debug) {
                    m_outDebug.println("returned from listener.stop() -> " + code);
                }
            }
            Thread.currentThread().setPriority(oldPriority);
        }
        WrapperManager.shutdownJVM(code);
    }

    private static void signalStarted() {
        WrapperManager.sendCommand((byte)106, "");
        m_started = true;
    }

    private static void controlEvent(int event) {
        boolean ignore;
        String eventName;
        switch (event) {
            case 200: {
                eventName = "WRAPPER_CTRL_C_EVENT";
                ignore = m_ignoreSignals;
                break;
            }
            case 201: {
                eventName = "WRAPPER_CTRL_CLOSE_EVENT";
                ignore = m_ignoreSignals;
                break;
            }
            case 202: {
                eventName = "WRAPPER_CTRL_LOGOFF_EVENT";
                ignore = false;
                break;
            }
            case 203: {
                eventName = "WRAPPER_CTRL_SHUTDOWN_EVENT";
                ignore = false;
                break;
            }
            case 204: {
                eventName = "WRAPPER_CTRL_TERM_EVENT";
                ignore = m_ignoreSignals;
                break;
            }
            case 205: {
                eventName = "WRAPPER_CTRL_HUP_EVENT";
                ignore = m_ignoreSignals;
                break;
            }
            case 206: {
                eventName = "WRAPPER_CTRL_USR1_EVENT";
                ignore = m_ignoreSignals;
                break;
            }
            case 207: {
                eventName = "WRAPPER_CTRL_USR2_EVENT";
                ignore = m_ignoreSignals;
                break;
            }
            default: {
                eventName = "Unexpected event: " + event;
                ignore = false;
            }
        }
        WrapperControlEvent controlEvent = new WrapperControlEvent(event, eventName);
        if (ignore) {
            controlEvent.consume();
        }
        WrapperManager.fireWrapperEvent(controlEvent);
        if (!controlEvent.isConsumed()) {
            if (ignore) {
                if (m_debug) {
                    m_outDebug.println("Ignoring control event(" + eventName + ")");
                }
            } else {
                if (m_debug) {
                    m_outDebug.println("Processing control event(" + eventName + ")");
                }
                if (m_listener != null) {
                    try {
                        m_listener.controlEvent(event);
                    }
                    catch (Throwable t) {
                        m_outError.println("Error in WrapperListener.controlEvent callback.");
                        t.printStackTrace(m_outError);
                    }
                } else {
                    WrapperManager.stop(0);
                }
            }
        }
    }

    private static void readProperties(String rawProps) {
        WrapperProperties properties = new WrapperProperties();
        int len = rawProps.length();
        int first = 0;
        while (first < len) {
            StringBuffer sb = new StringBuffer();
            boolean foundEnd = false;
            do {
                int pos;
                if ((pos = rawProps.indexOf(PROPERTY_SEPARATOR, first)) >= 0) {
                    if (pos > 0) {
                        sb.append(rawProps.substring(first, pos));
                    }
                    if (pos < len - 1) {
                        if (rawProps.charAt(pos + 1) == PROPERTY_SEPARATOR) {
                            sb.append(PROPERTY_SEPARATOR);
                            first = pos + 2;
                            continue;
                        }
                        foundEnd = true;
                        first = pos + 1;
                        continue;
                    }
                    foundEnd = true;
                    first = pos + 1;
                    continue;
                }
                sb.append(rawProps.substring(first));
                foundEnd = true;
                first = len;
            } while (!foundEnd);
            String property = sb.toString();
            int pos = property.indexOf(61);
            if (pos <= 0) continue;
            String key = property.substring(0, pos);
            String value = pos < property.length() - 1 ? property.substring(pos + 1) : "";
            properties.setProperty(key, value);
            if (!key.equals("wrapper.ignore_user_logoffs")) continue;
            m_ignoreUserLogoffs = value.equalsIgnoreCase("true");
        }
        properties.lock();
        m_properties = properties;
    }

    private static synchronized Socket openSocket() {
        boolean fixedPort;
        int tryPort;
        InetAddress iNetAddress;
        if (m_debug) {
            m_outDebug.println("Open socket to wrapper..." + Thread.currentThread().getName());
        }
        try {
            iNetAddress = InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException e) {
            m_outError.println("Unable to resolve localhost name: " + e);
            m_outError.println("Exiting JVM...");
            WrapperManager.stop(1);
            return null;
        }
        boolean connected = false;
        if (m_jvmPort > 0) {
            tryPort = m_jvmPort;
            fixedPort = true;
        } else {
            tryPort = m_jvmPortMin;
            fixedPort = false;
        }
        SocketException causeException = null;
        do {
            try {
                m_socket = new Socket(iNetAddress, m_port, iNetAddress, tryPort);
                if (m_debug) {
                    m_outDebug.println("Opened Socket from " + tryPort + " to " + m_port);
                }
                connected = true;
                break;
            }
            catch (SocketException e) {
                String eMessage = e.getMessage();
                if (e instanceof ConnectException) {
                    m_outError.println("Failed to connect to the Wrapper at port " + m_port + ".  Cause: " + e);
                    m_outError.println("Exiting JVM...");
                    WrapperManager.stopImmediate(1);
                    continue;
                }
                if (e instanceof BindException || eMessage != null && (eMessage.indexOf("errno: 48") >= 0 || eMessage.indexOf("Address already in use") >= 0)) {
                    if (m_debug) {
                        m_outDebug.println("Unable to open socket to Wrapper from port " + tryPort + ", already in use.");
                    }
                    if (fixedPort) {
                        tryPort = m_jvmPortMin;
                        fixedPort = false;
                    } else {
                        ++tryPort;
                    }
                    if (causeException != null) continue;
                    causeException = e;
                    continue;
                }
                m_outError.println("Unexpected exception opening backend socket: " + e);
                m_socket = null;
                return null;
            }
            catch (IOException e) {
                m_outError.println("Unable to open backend socket: " + e);
                m_socket = null;
                return null;
            }
        } while (tryPort <= m_jvmPortMax);
        if (connected) {
            if (m_jvmPort > 0 && m_jvmPort != tryPort) {
                m_outInfo.println("Port " + m_jvmPort + " already in use, using port " + tryPort + " instead.");
            }
        } else {
            if (m_jvmPortMax > m_jvmPortMin) {
                m_outError.println("Failed to connect to the Wrapper at port " + m_port + " by binding to any ports in the range " + m_jvmPortMin + " to " + m_jvmPortMax + ".  Cause: " + causeException);
            } else {
                m_outError.println("Failed to connect to the Wrapper at port " + m_port + " by binding to port " + m_jvmPortMin + ".  Cause: " + causeException);
            }
            m_outError.println("Exiting JVM...");
            WrapperManager.stopImmediate(1);
        }
        try {
            m_socket.setTcpNoDelay(true);
            if (m_soTimeout > 0) {
                m_socket.setSoTimeout(m_soTimeout);
            }
        }
        catch (IOException e) {
            m_outError.println(e);
        }
        WrapperManager.sendCommand((byte)110, m_key);
        return m_socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void closeSocket() {
        if (m_socket != null) {
            if (m_debug) {
                m_outDebug.println("Closing socket.");
            }
            try {
                try {
                    m_socket.close();
                }
                catch (IOException iOException) {
                    Object var2_1 = null;
                    m_socket = null;
                }
                Object var2 = null;
                m_socket = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                m_socket = null;
                throw throwable;
            }
        }
    }

    private static String getPacketCodeName(byte code) {
        String name;
        switch (code) {
            case 100: {
                name = "START";
                break;
            }
            case 101: {
                name = "STOP";
                break;
            }
            case 102: {
                name = "RESTART";
                break;
            }
            case 103: {
                name = "PING";
                break;
            }
            case 104: {
                name = "STOP_PENDING";
                break;
            }
            case 105: {
                name = "START_PENDING";
                break;
            }
            case 106: {
                name = "STARTED";
                break;
            }
            case 107: {
                name = "STOPPED";
                break;
            }
            case 110: {
                name = "KEY";
                break;
            }
            case 111: {
                name = "BADKEY";
                break;
            }
            case 112: {
                name = "LOW_LOG_LEVEL";
                break;
            }
            case 113: {
                name = "PING_TIMEOUT";
                break;
            }
            case 114: {
                name = "SERVICE_CONTROL_CODE";
                break;
            }
            case 115: {
                name = "PROPERTIES";
                break;
            }
            case 117: {
                name = "LOG(DEBUG)";
                break;
            }
            case 118: {
                name = "LOG(INFO)";
                break;
            }
            case 119: {
                name = "LOG(STATUS)";
                break;
            }
            case 120: {
                name = "LOG(WARN)";
                break;
            }
            case 121: {
                name = "LOG(ERROR)";
                break;
            }
            case 122: {
                name = "LOG(FATAL)";
                break;
            }
            case 123: {
                name = "LOG(ADVICE)";
                break;
            }
            case -122: {
                name = "LOGFILE";
                break;
            }
            case -124: {
                name = "CHILD_LAUNCH";
                break;
            }
            case -123: {
                name = "CHILD_TERM";
                break;
            }
            case -119: {
                name = "APPEAR_ORPHAN";
                break;
            }
            default: {
                name = "UNKNOWN(" + code + ")";
            }
        }
        return name;
    }

    private static synchronized void sendCommand(byte code, String message) {
        Socket socket = m_socket;
        if (m_debug && (code != 103 || !message.equals("silent"))) {
            if (socket == null) {
                m_outDebug.println("Backend socket not connected, not sending packet " + WrapperManager.getPacketCodeName(code) + " : " + message);
            } else {
                m_outDebug.println("Send a packet " + WrapperManager.getPacketCodeName(code) + " : " + message);
            }
        }
        if (!m_appearHung) {
            if (socket == null && WrapperManager.isControlledByNativeWrapper() && !m_stopping) {
                socket = WrapperManager.openSocket();
            }
            if (code == 105 || code == 106) {
                m_lastPingTicks = WrapperManager.getTicks();
            }
            if (socket != null) {
                try {
                    byte[] messageBytes = message.getBytes();
                    if (m_commandBuffer.length < messageBytes.length + 2) {
                        m_commandBuffer = new byte[messageBytes.length + 2];
                    }
                    WrapperManager.m_commandBuffer[0] = code;
                    System.arraycopy(messageBytes, 0, m_commandBuffer, 1, messageBytes.length);
                    int len = messageBytes.length + 2;
                    WrapperManager.m_commandBuffer[len - 1] = 0;
                    OutputStream os = socket.getOutputStream();
                    os.write(m_commandBuffer, 0, len);
                    os.flush();
                }
                catch (IOException e) {
                    m_outError.println(e);
                    e.printStackTrace(m_outError);
                    WrapperManager.closeSocket();
                }
            }
        }
    }

    private static void handleSocket() {
        WrapperPingEvent pingEvent = new WrapperPingEvent();
        try {
            if (m_debug) {
                m_outDebug.println("handleSocket(" + m_socket + ")");
            }
            DataInputStream is = new DataInputStream(m_socket.getInputStream());
            block24: while (!m_disposed) {
                try {
                    byte b;
                    byte code = is.readByte();
                    int i = 0;
                    do {
                        if ((b = is.readByte()) == 0) continue;
                        if (i >= m_socketReadBuffer.length) {
                            byte[] tmp = m_socketReadBuffer;
                            m_socketReadBuffer = new byte[tmp.length + 256];
                            System.arraycopy(tmp, 0, m_socketReadBuffer, 0, tmp.length);
                        }
                        WrapperManager.m_socketReadBuffer[i] = b;
                        ++i;
                    } while (b != 0);
                    String msg = new String(m_socketReadBuffer, 0, i);
                    if (m_appearHung) continue;
                    if (m_debug) {
                        String logMsg = code == 115 ? "(Property Values)" : msg;
                        if (code != 103 || !msg.equals("silent")) {
                            m_outDebug.println("Received a packet " + WrapperManager.getPacketCodeName(code) + " : " + logMsg);
                        }
                    }
                    switch (code) {
                        case 100: {
                            WrapperManager.startInner(false);
                            break;
                        }
                        case 101: {
                            if (m_stopping) continue block24;
                            WrapperManager.privilegedStopInner(0);
                            break;
                        }
                        case 103: {
                            m_lastPingTicks = WrapperManager.getTicks();
                            WrapperManager.sendCommand((byte)103, msg);
                            if (!m_produceCoreEvents) continue block24;
                            WrapperManager.fireWrapperEvent(pingEvent);
                            break;
                        }
                        case 111: {
                            m_outError.println("Authorization key rejected by Wrapper.");
                            m_outError.println("Exiting JVM...");
                            WrapperManager.closeSocket();
                            WrapperManager.privilegedStopInner(1);
                            break;
                        }
                        case 112: {
                            try {
                                m_lowLogLevel = Integer.parseInt(msg);
                                m_debug = m_lowLogLevel <= 1;
                                if (!m_debug) continue block24;
                                m_outDebug.println("LowLogLevel from Wrapper is " + m_lowLogLevel);
                            }
                            catch (NumberFormatException e) {
                                m_outError.println("Encountered an Illegal LowLogLevel from the Wrapper: " + msg);
                            }
                            break;
                        }
                        case 113: {
                            try {
                                m_pingTimeout = Integer.parseInt(msg) * 1000;
                                if (m_debug) {
                                    m_outDebug.println("PingTimeout from Wrapper is " + m_pingTimeout);
                                }
                            }
                            catch (NumberFormatException e) {
                                m_outError.println("Encountered an Illegal PingTimeout from the Wrapper: " + msg);
                            }
                            if (m_pingTimeout <= 0) {
                                m_socket.setSoTimeout(0);
                                break;
                            }
                            if (m_soTimeout >= m_pingTimeout) continue block24;
                            m_socket.setSoTimeout(m_pingTimeout);
                            break;
                        }
                        case 114: {
                            try {
                                int serviceControlCode = Integer.parseInt(msg);
                                if (m_debug) {
                                    m_outDebug.println("ServiceControlCode from Wrapper with code " + serviceControlCode);
                                }
                                WrapperServiceControlEvent event = new WrapperServiceControlEvent(serviceControlCode);
                                WrapperManager.fireWrapperEvent(event);
                            }
                            catch (NumberFormatException e) {
                                m_outError.println("Encountered an Illegal ServiceControlCode from the Wrapper: " + msg);
                            }
                            break;
                        }
                        case 115: {
                            WrapperManager.readProperties(msg);
                            break;
                        }
                        case -122: {
                            m_logFile = new File(msg);
                            WrapperLogFileChangedEvent event = new WrapperLogFileChangedEvent(m_logFile);
                            WrapperManager.fireWrapperEvent(event);
                            break;
                        }
                        default: {
                            m_outInfo.println("Wrapper code received an unknown packet type: " + code);
                        }
                    }
                }
                catch (InterruptedIOException e) {
                    int nowTicks = WrapperManager.getTicks();
                    if (!m_started || m_stopping) continue;
                    if (m_debug) {
                        m_outDebug.println("Read Timed out. (Last Ping was " + WrapperManager.getTickAge(m_lastPingTicks, nowTicks) + " milliseconds ago)");
                    }
                    if (m_appearHung) continue;
                    long lastPingAge = WrapperManager.getTickAge(m_lastPingTicks, nowTicks);
                    long eventRunnerAge = WrapperManager.getTickAge(m_eventRunnerTicks, nowTicks);
                    if (eventRunnerAge >= 10000L || m_pingTimeout <= 0) continue;
                    if (lastPingAge > (long)(4 * m_pingTimeout)) {
                        m_outInfo.println("JVM did not exit.  Give up.");
                        WrapperManager.safeSystemExit(1);
                        continue;
                    }
                    if (lastPingAge <= (long)m_pingTimeout) continue;
                    m_outInfo.println("The Wrapper code did not ping the JVM for " + lastPingAge / 1000L + " seconds.  " + "Quit and let the Wrapper resynch.");
                    if (m_stopping) continue;
                    WrapperManager.sendCommand((byte)102, "restart");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                    WrapperManager.privilegedStopInner(1);
                }
            }
            return;
        }
        catch (SocketException e) {
            if (m_debug && m_socket != null) {
                m_outDebug.println("Closed socket: " + e);
            }
            return;
        }
        catch (IOException e) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startRunner() {
        if (WrapperManager.isControlledByNativeWrapper()) {
            if (m_commRunner == null) {
                m_commRunner = new Thread((Runnable)m_instance, WRAPPER_CONNECTION_THREAD_NAME);
                m_commRunner.setDaemon(true);
                m_commRunner.start();
            }
            Class clazz = WrapperManager.class;
            synchronized (clazz) {
                while (!m_commRunnerStarted) {
                    try {
                        (class$org$tanukisoftware$wrapper$WrapperManager == null ? WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager") : class$org$tanukisoftware$wrapper$WrapperManager).wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        Class clazz = WrapperManager.class;
        synchronized (clazz) {
            m_commRunnerStarted = true;
            WrapperManager.class.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Class clazz;
        if (Thread.currentThread() != m_commRunner) {
            throw new IllegalStateException("Only the comm runner thread is allowed to call this method.");
        }
        if (m_debug) {
            m_outDebug.println("Communications runner thread started.");
        }
        Thread.currentThread().setPriority(10);
        m_lastPingTicks = WrapperManager.getTicks();
        boolean gotPortOnce = false;
        while (!m_disposed) {
            try {
                Object var5_6;
                try {
                    WrapperManager.openSocket();
                    if (!m_commRunnerStarted) {
                        clazz = class$org$tanukisoftware$wrapper$WrapperManager == null ? WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager") : class$org$tanukisoftware$wrapper$WrapperManager;
                        synchronized (clazz) {
                            m_commRunnerStarted = true;
                            (class$org$tanukisoftware$wrapper$WrapperManager == null ? WrapperManager.class$("org.tanukisoftware.wrapper.WrapperManager") : class$org$tanukisoftware$wrapper$WrapperManager).notifyAll();
                        }
                    }
                    if (m_socket != null) {
                        WrapperManager.handleSocket();
                    } else {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                        }
                    }
                    var5_6 = null;
                }
                catch (Throwable throwable) {
                    var5_6 = null;
                    WrapperManager.closeSocket();
                    throw throwable;
                }
                WrapperManager.closeSocket();
                {
                }
            }
            catch (ThreadDeath td) {
                m_outError.println(m_warning.format("SERVER_DAEMON_KILLED"));
            }
            catch (Throwable t) {
                if (WrapperManager.isShuttingDown()) continue;
                m_outError.println(m_error.format("SERVER_DAEMON_DIED"));
                t.printStackTrace(m_outError);
            }
        }
        clazz = WrapperManager.class;
        synchronized (clazz) {
            if (!m_commRunnerStarted) {
                m_commRunnerStarted = true;
                WrapperManager.class.notifyAll();
            }
        }
        if (m_debug) {
            m_outDebug.println(m_info.format("SERVER_DAEMON_SHUT_DOWN"));
        }
    }

    static {
        m_windows = false;
        m_securityManagerChecked = false;
        m_disposed = false;
        m_starting = false;
        m_started = false;
        m_instance = null;
        m_hook = null;
        m_hookTriggered = false;
        m_shutdownJVMComplete = false;
        m_shutdownLockMap = new HashMap();
        m_shutdownLocks = 0;
        m_port = 15003;
        m_soTimeout = 10000;
        m_cpuTimeout = 10000L;
        m_lowLogLevel = 8;
        m_pingTimeout = 30000;
        m_ignoreSignals = false;
        m_commRunnerStarted = false;
        m_appearHung = false;
        m_ignoreUserLogoffs = false;
        m_service = false;
        m_debug = false;
        m_jvmId = 0;
        m_stopping = false;
        m_libraryOK = false;
        m_commandBuffer = new byte[512];
        m_logFile = null;
        m_wrapperEventListenerMaskList = new ArrayList();
        m_wrapperEventListenerMasks = null;
        m_produceCoreEvents = false;
        m_error = m_res = ResourceManager.getResourceManager();
        m_warning = m_res;
        m_info = m_res;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                WrapperManager.privilegedClassInit();
                return null;
            }
        });
        PROPERTY_SEPARATOR = (char)9;
        m_socketReadBuffer = new byte[256];
    }

    private static class WrapperInputStream
    extends InputStream {
        private WrapperInputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            m_out.println("WARNING - System.in has been disabled by the wrapper.disable_console_input property.  Calls will block indefinitely.");
            while (true) {
                WrapperInputStream wrapperInputStream = this;
                synchronized (wrapperInputStream) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static class WrapperTickEventImpl
    extends WrapperTickEvent {
        private int m_ticks;
        private int m_tickOffset;

        private WrapperTickEventImpl() {
        }

        public int getTicks() {
            return this.m_ticks;
        }

        public int getTickOffset() {
            return this.m_tickOffset;
        }
    }

    private static class WrapperEventListenerMask {
        private WrapperEventListener m_listener;
        private long m_mask;

        private WrapperEventListenerMask() {
        }
    }

    private static class ShutdownLock {
        private final Thread m_thread;
        private int m_count;

        private ShutdownLock(Thread thread) {
            this.m_thread = thread;
        }
    }
}

