#!/bin/sh
# Copyright(c) 2010 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library in the file COPYING.LIB;
# if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#
# @author Mladen Turk
#
#
# $1    package name    (eg. apr)
# $2    target base     (eg. workdir)
# $3    merge base      (eg. RHATews-1)
#

xb_cleanupsvn()
{
    if [ -d "$1/.svn" ]; then
        rm -rf "$1/.svn" >/dev/null 2>&1 || true
    fi
    sIFS=$IFS; IFS=$XB_LF
    for b in `ls -1 $1 2>/dev/null`
    do
        IFS=$sIFS
        if [ -d "$1/$b" ]; then
            xb_cleanupsvn $1/$b
        fi
    done
}

xb_cleanupsvn $@
exit 0
