#!/bin/sh
# Copyright(c) 2010 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library in the file COPYING.LIB;
# if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
#
# @author Mladen Turk
#

xb_tarball()
{
    o_zip=false
    o_tbz=false
    o_tgz=false
    o_out=""
    o_cmp=""
    w_dir=""
    for o
    do
        case "$o" in
        -*=*) a=`echo "$o" | $XB_GSED 's/^[-_a-zA-Z0-9]*=//'` ;;
           *) a='' ;;
        esac
        case "$o" in
            -b|--bz*        ) o_tbz=true ;     shift ;;
            -g|--gz*        ) o_tgz=true ;     shift ;;
            -z|--zip        ) o_zip=true ;     shift ;;
            -o|--out*=*     ) o_out="$a" ;     shift ;;
            -p|--pack*=*    ) o_cmp="$a" ;     shift ;;
            -w|--w*=*       ) w_dir="$a" ;     shift ;;
            *  ) break ;;
        esac
    done

    if $o_zip; then
        ext=".zip"
        cmp=zip
    elif $o_tbz; then
        cmp="$XB_BZIP -c"
        if [ ".$cmp" = . ]; then
            return 2
        fi
        ext=".tar.bz2"
    elif $o_tgz; then
        ext=".tar.gz"
        cmp="$XB_GZIP -c9"
    else
        return 22
    fi
    if [ ".$o_cmp" = . ]; then
        o_cmp=$cmp
    fi
    if [ -n "$1" ]; then
        tarball="$1$ext"
        shift
    else
        return 2
    fi
    if [ -n "$o_out" ]; then
        tarball="$o_out/$tarball"
    fi
    # Remove any previous archive
    rm -f "$tarball" >/dev/null 2>&1 || true
    taropts="-cf -"
    zipopts="-9rqyo"
    if [ ".$w_dir" != . ]; then
        if [ ! -d "$w_dir" ]; then
            mkdir -p "$w_dir" 2>/dev/null
        fi
        cd "$w_dir"
    fi
    if $xb_build_suser; then
        # Find the system tar
        for i in /bin /usr/bin /sbin /usr/sbin
        do
            if [ -x $i/tar ]; then
                XB_GTAR=$i/tar
                break
            fi
        done
    fi
    if [ "$o_tbz" = true -o "$o_tgz" = true ]; then
        $XB_GTAR --help 2>/dev/null | $XB_GREP 'owner=' 1>/dev/null
        if [ $? -eq 0 ]; then
            taropts="--owner=$xb_build_owner --group=$xb_build_group $taropts"
        fi
        $XB_GTAR --help 2>/dev/null | grep 'oldgnu' 1>/dev/null
        if [ $? -eq 0 ]; then
            taropts="--format=oldgnu $taropts"
        fi
    fi
    if $o_zip; then
        $XB_VERBOSE "Creating zip archive..."
        $XB_VERBOSE "  $o_cmp $zipopts \"$tarball\""
        $o_cmp $zipopts "$tarball" "`eval echo $@`" >/dev/null 2>&1
    else
        $XB_VERBOSE "Creating tarball..."
        $XB_VERBOSE "  $XB_GTAR $taropts $@ | $o_cmp > \"$tarball\""
        $XB_GTAR $taropts $@ 2>/dev/null | $o_cmp > "$tarball"
    fi
    return $?
}

# Call the internal function
xb_tarball $@
exit $?
