/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.inject;

import com.google.inject.MembersInjector;
import java.util.Collection;
import org.sonatype.guice.bean.inject.PropertyBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BeanInjector<B>
implements MembersInjector<B> {
    private static final ThreadLocal<boolean[]> isInjectingHolder = new ThreadLocal<boolean[]>(){

        @Override
        protected boolean[] initialValue() {
            return new boolean[]{false};
        }
    };
    private final PropertyBinding[] bindings;

    BeanInjector(Collection<PropertyBinding> bindings) {
        int n = bindings.size();
        this.bindings = new PropertyBinding[n];
        for (PropertyBinding b : bindings) {
            this.bindings[--n] = b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void injectMembers(B bean) {
        boolean[] isInjecting = isInjectingHolder.get();
        if (!isInjecting[0]) {
            isInjecting[0] = true;
            try {
                this.doInjection(bean);
            }
            finally {
                isInjecting[0] = false;
            }
        } else {
            this.doInjection(bean);
        }
    }

    public static boolean isInjecting() {
        return isInjectingHolder.get()[0];
    }

    private void doInjection(Object bean) {
        for (PropertyBinding b : this.bindings) {
            b.injectProperty(bean);
        }
    }
}

