# Copyright (c) 2000-2009, JPackage Project
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the JPackage Project nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

%define reltag .Final
%define namedversion %{version}%{reltag}
%define jarname mod-cluster

Name:		mod_cluster-native
Summary: 	JBoss mod_cluster for Apache httpd
Version: 	1.2.3
Release: 	2%{reltag}%{?dist}
Epoch:		0
License: 	LGPLv3
Group: 		Applications/System
URL:		http://www.jboss.org/
# svn export http://anonsvn.jboss.org/repos/mod_cluster/tags/1.2.3.Final/native mod_cluster-1.2.3.Final/native
# svn export http://anonsvn.jboss.org/repos/mod_cluster/tags/1.2.3.Final/test/native mod_cluster-1.2.3.Final/test/native
# tar czf mod_cluster-1.2.3.Final.tar.gz mod_cluster-1.2.3.Final
# Exported revision 934.
Source0:        mod_cluster-1.2.3.Final.tar.gz
Patch0:         mod_cluster-native-1.0.10-nmakefiles.patch
Patch1:         mod_cluster-native-JBPAPP6-1170.patch

BuildRoot:      %{_tmppath}/%{name}-buildroot
BuildRequires:	httpd-devel
BuildRequires:	autoconf
BuildRequires:	zip

#win-buildrequires: xbuild
#win-buildrequires: httpd
#sun-buildrequires: httpd

%description
JBoss mod_cluster for Apache httpd.
NOTE: Apache httpd 2.2.8 or newer is needed.

%prep
%setup -q -n mod_cluster-%{version}%{reltag}
%patch0 -p1
%patch1 -p0

%build
zip -q -r ../%{name}-%{namedversion}-src.zip *

%{!?apxs: %{expand: %%define apxs %{_sbindir}/apxs}}
%define aplibdir %(%{apxs} -q LIBEXECDIR 2>/dev/null)
pushd native
for i in advertise mod_manager mod_proxy_cluster mod_slotmem
do
pushd $i
sh buildconf
./configure --with-apxs="%{apxs}"
make CFLAGS=-fno-strict-aliasing
popd
done
popd

%install
%{!?apxs: %{expand: %%define apxs %{_sbindir}/apxs}}
%define aplibdir %(%{apxs} -q LIBEXECDIR 2>/dev/null)
install -d -m 755 $RPM_BUILD_ROOT%{_datadir}/%{name}-%{version}
install -d -m 755 $RPM_BUILD_ROOT/%{aplibdir}/
cp -p native/*/*.so ${RPM_BUILD_ROOT}/%{aplibdir}/

%clean
rm -Rf $RPM_BUILD_ROOT

%files
%{!?apxs: %{expand: %%define apxs %{_sbindir}/apxs}}
%define aplibdir %(%{apxs} -q LIBEXECDIR 2>/dev/null)
%defattr(0644,root,root,0755)
%doc JBossORG-EULA.txt
%doc lgpl.txt
%doc README.txt
%doc release.txt
%attr(0755,root,root) %{aplibdir}/*

%changelog
* Wed Nov 21 2012 Mladen Turk <mturk@redhat.com> - 0:1.2.3-2.Final
- Fix JBPAPP6-1170.

* Thu Oct 18 2012 Mladen Turk <mturk@redhat.com> - 0:1.2.3-1.Final
- Upgrade to mod_cluster 1.2.3.Final

* Fri Sep 21 2012 Mladen Turk <mturk@redhat.com> - 0:1.2.2-3.Final
- Sync version with mod_cluster package

* Fri Sep 14 2012 Mladen Turk <mturk@redhat.com> - 0:1.2.2-1.2.Final
- Rebuild with new source package content

* Thu Sep 13 2012 Vaclav Tunka <vtunka@redhat.com> - 0:1.2.2-1.Final
- Upgrade to mod_cluster 1.2.2.Final

* Wed Sep  5 2012 Mladen Turk <mturk@redhat.com> - 0:1.2.1-3.Final
- Rebuild

* Wed Jun 20 2012 Mladen Turk <mturk@redhat.com> - 0:1.2.1-2.Final
- Add mod_cluster-native.conf file

* Wed May 09 2012 Vaclav Tunka <vtunka@redhat.com> - 0:1.2.1-1.Final
- Upgrade to mod_cluster 1.2.1.Final for EAP 6 / EWS 2

* Wed Apr 18 2012 Vaclav Tunka <vtunka@redhat.com> - 0:1.2.1-1.Beta2
- Upgrade to mod_cluster 1.2.1.Beta2 for EAP 6 / EWS 2

* Mon Mar 22 2012 Mladen Turk <mturk@redhat.com> - 0:1.2.1-0.Beta1
- Upgrade to mod_cluster 1.2.1.Beta1 for EAP 6 / EWS 2

* Mon Feb 27 2012 Vaclav Tunka <vtunka@redhat.com> - 0:1.2.0-1.Final
- Upgrade to mod_cluster 1.2.0.Final for EAP 6 / EWS 2

* Wed Feb  1 2012 Mladen Turk <mturk@redhat.com> 0:1.2.0-1.Beta4
- Rebuild using git repository.
- Upgrade to mod_cluster 1.2.0.Beta4 for EAP 6 / EWS 2

* Tue Jan 10 2012 Mladen Turk <mturk@redhat.com> - 0:1.2.0-1.Beta3
- Upgrade to mod_cluster 1.2.0.Beta3 for EAP 6 / EWS 2

* Thu Dec  8 2011 Vaclav Tunka <vtunka@redhat.com> - 0:1.2.0-1.Beta1
- Upgrade to mod_cluster 1.2.0.Beta1 for EAP 6 / EWS 2

* Mon Dec  5 2011 Vaclav Tunka <vtunka@redhat.com> - 0:1.1.3-1.Final
- Upgrade to mod_cluster 1.1.3.Final for EAP 6 / EWS 2

* Wed Oct 26 2011 Vaclav Tunka <vtunka@redhat.com> - 0:1.0.10-3.4.GA_CP02
- Rebuild

* Fri Oct 21 2011 Vaclav Tunka <vtunka@redhat.com> - 0:1.0.10-3.3.GA_CP02
- Move to generated .ini file
- Add win BRs
- Makefile include for general xbuild Makefile

* Wed Oct 12 2011 Mladen Turk <mturk@redhat.com> - 0:1.0.10-3.2.GA_CP02
- Add winspec files

* Mon Aug 15 2011 Permaine Cheung <pcheung@redhat.com> - 0:1.0.10-3.1.GA_CP02
- Upgrade to 1.0.10.GA_CP02
- Remove patch for MODCLUSTER-241 as it's incoporated the tag

* Wed Aug 03 2011 Permaine Cheung <pcheung@redhat.com> - 0:1.0.10-2.2.GA_CP01
- Add patch for MODCLUSTER-241 for a one-off

* Fri Jun 10 2011 Permaine Cheung <pcheung@redhat.com> - 0:1.0.10-2.1.GA_CP01
- Upgrade to 1.0.10.GA_CP01

* Mon Apr 18 2011 Permaine Cheung <pcheung@redhat.com> - 0:1.0.10-1.1
- Upgrade to 1.0.10.GA

* Mon Mar 21 2011 Permaine Cheung <pcheung@redhat.com> - 0:1.0.9-1.1
- Upgrade to 1.0.9.GA

* Thu Feb 17 2011 Permaine Cheung <pcheung@redhat.com> - 0:1.0.8-2.1
- Fix Release tag

* Wed Feb 16 2011 Permaine Cheung <pcheung@redhat.com> - 0:1.0.8-1.1
- Upgrade to 1.0.8.GA

* Fri Jan 07 2011 Permaine Cheung <pcheung@redhat.com> - 0:1.0.6-1.1
- Upgrade to 1.0.6.GA

* Wed Nov 24 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.5-1.1
- Upgrade to 1.0.5.GA

* Wed Jul 28 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.4-1.1
- Upgrade to 1.0.4.GA
- Remove patches that are already incorporated in the tag

* Thu Jun 24 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.3-9.1
- Remove R: httpd 2.2.8 and add a note in description

* Tue Jun 22 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.3-8.1
- Build with no-strict-aliasing as suggested by rpmdiff

* Wed May 26 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.3-7.2
- Split up mod_cluster into mod-cluster and mod_cluster-native

* Tue May 25 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.3-6.1
- Add patch for JBPAPP-3936, 4046, 4307
- Adjust depmap

* Mon May 17 2010 Martha Benitez <mbenitez@redhat.com> - 0:1.0.3-3.3.1
- rebuilt

* Mon Apr 19 2010 Yiqiao Wang <yiwang@redhat.com> - 0:1.0.3-3.3
- Rebuild

* Thu Apr 01 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.3-3.2
- Build with jars
- Revert the changes to work with httpd instead of httpd22

* Tue Feb 09 2010 Yiqiao Wang <yiwang@redhat.com> - 0:1.0.3-3.1
- Merge with RHEL-4

* Mon Jan 25 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.3-2.1
- Rebuild

* Mon Jan 18 2010 Permaine Cheung <pcheung@redhat.com> - 0:1.0.3-1
- Upgrade to 1.0.3
- Merge with RHEL-4-EP-5 branch

* Fri Nov 06 2009 Permaine Cheung <pcheung@redhat.com> - 0:1.0.2-5.1
- Do not build jars as we don't have all the dependencies on RHEL 5

* Thu Nov 05 2009 Permaine Cheung <pcheung@redhat.com> - 0:1.0.2-5
- Fix location of zip

* Thu Nov 05 2009 Permaine Cheung <pcheung@redhat.com> - 0:1.0.2-4
- Fix Requires:

* Thu Nov 05 2009 Permaine Cheung <pcheung@redhat.com> - 0:1.0.2-3
- Build native .so for httpd and put them in the main package
- Rename the package that includes jars and sar for jbossas to -jbossas
- Add load-demo.war back in demo/server
- Add .so to zip
- Add src-zip

* Mon Nov 02 2009 Martha Benitez <mbenitez@redhat.com> - 0:1.0.2-2
- Add license and release notes to the main package
- Remove .dir extension from sar directory name
- Add mod_cluster.jar to sar directory
- Change sub-package names to jbossweb2 and tomcat6 to clarify versions
- Explode contents of load-demo.war inside server subdirectory in the demo sub-package

* Tue Sep 15 2009 Martha Benitez <mbenitez@redhat.com> - 0:1.0.2-1
- Brew build
- Relax version for httpd-devel
