/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http.httpclient.impl;

import java.io.IOException;
import java.net.Socket;
import org.apache.maven.wagon.providers.http.httpclient.impl.SocketHttpClientConnection;
import org.apache.maven.wagon.providers.http.httpclient.params.HttpConnectionParams;
import org.apache.maven.wagon.providers.http.httpclient.params.HttpParams;

public class DefaultHttpClientConnection
extends SocketHttpClientConnection {
    public void bind(Socket socket, HttpParams params) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.assertNotOpen();
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay(params));
        socket.setSoTimeout(HttpConnectionParams.getSoTimeout(params));
        int linger = HttpConnectionParams.getLinger(params);
        if (linger >= 0) {
            socket.setSoLinger(linger > 0, linger);
        }
        super.bind(socket, params);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        if (this.isOpen()) {
            buffer.append(this.getRemotePort());
        } else {
            buffer.append("closed");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

