JBoss EAP 6 Contributions
=========================

# Commit Messages
Commit messages should start with the BZ id for the issue being solved and should also contain the issue summary.  For example:
> [BZ-1206177] AdvancedLdapLoginModuleTestCase fails on RHEL5 and IBM JDK.

# Pull Requests
All pull requests to this repository must include the following in their description:
- URL of upstream PR related to this issue (if it exists).
- URL for the upstream JIRA (if it exists).
- URL of the downstream BZ which originally defined this issue.

Note: If no upstream issue exists, then you must at least state "No Upstream required" in the PR description.
Ideally an explanation of, or a link to a BZ comment stating, why an upstream fix is not required should be provided. 

# General Guidelines
- Only commit necessary changes. 
  - Don't refactor for the sake of it!
  - Avoid commiting changes to code formatting and the ordering of imports.
- Split solutions into multiple commits only if each commit is able to standalone (i.e. it does not depend on future commits)
