/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2018, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.wildfly.clustering.ee.cache.function;

import java.util.Collection;

/**
 * Function that operates on a collection.
 * @author Paul Ferraro
 * @param <V> the collection element type
 * @param <C> the collection type
 */
public abstract class CollectionFunction<V, C extends Collection<V>> extends AbstractFunction<Collection<V>, C> {

    public CollectionFunction(Collection<V> operand, Operations<C> operations) {
        super(operand, operations.getCopier(), operations.getFactory(), operations.isEmpty());
    }

    @Override
    public int hashCode() {
        int result = 1;
        for (V value : this.getOperand()) {
            result = 31 * result + value.hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object object) {
        if (!this.getClass().isInstance(object)) return false;
        @SuppressWarnings("unchecked")
        CollectionFunction<V, C> function = (CollectionFunction<V, C>) object;
        Collection<V> ourOperand = this.getOperand();
        Collection<V> otherOperand = function.getOperand();
        return ourOperand.size() == otherOperand.size() && ourOperand.containsAll(otherOperand);
    }
}
