<p align="center">
  <a href="https://www.redhat.com/en/technologies/jboss-middleware/application-platform">
      <img src="logo/Logo-Red_Hat-JBoss_Enterprise_Application_Platform-B-Standard-RGB.png" alt="Red Hat JBoss Enterprise Application Platform logo" title="Red Hat JBoss Enterprise Application Platform" height="200" width="700"/>
  </a>
</p>

JBoss Enterprise Application Platform (JBoss EAP) 8
===================================================
https://www.redhat.com/en/technologies/jboss-middleware/application-platform

* Fast Startup
* Small Footprint
* Modular Design
* Unified Configuration and Management

And of course Jakarta EE!

Building
-------------------

### Prerequisites:

* JDK 11 or newer - check `java -version`
* Maven 3.6.0 or newer - check `mvn -v`
* On *nix systems, make sure that the maximum number of open files for the user running the build is at least 4096
  (check `ulimit -n`) or more, depending on what other i/o intensive processes the user is running.
* Be connected to the Red Hat VPN. Necessary to download the JBoss EAP maven artifacts from the internal maven repository.
* Add the Red Hat root certificate as trusted certificate on your JDK keystore. Necessary to download the maven artifacts via HTTPS.

### How to install the Red Hat root certificate on your JDK keystore

Follow these instructions to install the Red Hat root certificate as trusted certificate on your JDK keystore:

1. Download the Red Hat root certificate:

```
wget https://password.corp.redhat.com/RH-IT-Root-CA.crt
```

2. Install it on your JDK keystore:
* For JDK 8:
   ```
   keytool -import -alias internal.redhat.com -keystore <JDK_8_Path>/jre/lib/security/cacerts -file RH-IT-Root-CA.crt -storepass changeit
   ```
* For JDK 11:
   ```
   keytool -import -alias internal.redhat.com -keystore <JDK_11_Path>/lib/security/cacerts -file RH-IT-Root-CA.crt -storepass changeit
  ```

If you are using system provided JDK(rpm installed), like: java-1.8.0-openjdk-devel, using the following command also works:
```
curl https://password.corp.redhat.com/RH-IT-Root-CA.crt -o /etc/pki/ca-trust/source/anchors/RH-IT-Root-CA.crt
update-ca-trust
```

### Building

To build with your own Maven installation:

    mvn install

Alternatively, you can use the Maven Wrapper script that downloads and installs (if necessary) the required Maven version to
`~/.m2/wrapper` and runs it from there. On Linux, run

    ./mvnw install

On Windows

    mvnw install


Starting and Stopping JBoss EAP
-------------------------------
Change to the bin directory after a successful build

$ cd build/target/jboss-eap/bin

Start the server in domain mode

    ./domain.sh

Start the server in standalone mode

    ./standalone.sh

To stop the server, press Ctrl + C, or use the admin console

    ./jboss-cli.sh --connect command=:shutdown


Contributing
------------------
* Git Setup: https://github.com/wildfly/wildfly/blob/main/docs/src/main/asciidoc/_hacking/github_setup.adoc
* Contributing: https://github.com/wildfly/wildfly/blob/main/docs/src/main/asciidoc/_hacking/contributing.adoc
* Pull request standard: https://github.com/wildfly/wildfly/blob/main/docs/src/main/asciidoc/_hacking/pullrequest_standards.adoc

Build vs. Dist directories
--------------------------

After running `mvn install`, JBoss EAP 8 will be available in two distinct directories, `build` and `dist`.

* The `build` directory contains a build of JBoss EAP 8 that is based on Maven artifact resolution for module configuration
* The `dist` directory, on the other hand, contains a full distributable build of JBoss EAP 8

Using the `build` directory makes iterating with subsystem or module development easier since there is no need to rebuild the whole of JBoss EAP 8 or copy JAR files around on every change.

The `dist` directory is better suited when a full build of JBoss EAP 8 is needed for development or test purposes.

Running the Testsuite
--------------------
The testsuite module contains several submodules including the following:

* "smoke" -- core tests that should be run as part of every build of the AS. Failures here will fail the build.
* "api" -- tests of features that involve end user use of the public JBoss AS 8 API. Should be run with no failures before any major commits.
* "cluster" -- tests of the WildFly HA clustering features. Should be run with no failures before any major commits.
* "domain" -- tests of the domain management features. Should be run with no failures before any major commits.
* "integration" -- tests of a WildFly standalone server's internals. Should be run with no failures before any major commits.
* "spec" -- tests of features that only involve end user use of the Jakarta EE spec APIs. Should be run with no failures before any major commits.

For basic smoke tests, simply: `mvn test`

To run all the tests

    mvn install -DallTests

Using Eclipse
-------------
1. Install the latest version of eclipse
2. Make sure Xmx in eclipse.ini is at least 1280M, and it's using Java 11
3. Launch eclipse and install the m2e plugin, make sure it uses your repo configs
   (get it from: http://www.eclipse.org/m2e/
   or install "Maven Integration for Eclipse" from the Eclipse Marketplace)
4. In eclipse preferences Java->Compiler->Errors/Warnings->Deprecated and restricted
   set forbidden reference to WARNING
5. In eclipse preferences Java->Code Style, import the cleanup, templates, and
   formatter configs in [ide-configs/eclipse](https://github.com/wildfly/wildfly-core/tree/master/ide-configs) in the wildfly-core repository.
6. In eclipse preferences Java->Editor->Save Actions enable "Additional Actions",
   and deselect all actions except for "Remove trailing whitespace"
7. Use import on the root pom, which will pull in all modules
8. Wait (m2e takes a while on initial import)

License
-------
* [GNU Lesser General Public License Version 2.1](http://www.gnu.org/licenses/lgpl-2.1-standalone.html)


