/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2023 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.installer.dialogs.downloader;

import java.io.File;
import java.net.URL;

public class Download {
    private URL url;
    private File outputPath;

    public Download(URL url, File outputPath) {
        this.url = url;
        this.outputPath = outputPath;
    }

    public URL getUrl() {
        return url;
    }

    public File getOutputPath() {
        return outputPath;
    }
}
