package org.jboss.installer.postinstall;

import org.jboss.installer.core.InstallationData;
import org.jboss.installer.core.LanguageUtils;

public interface PostInstallTask {
    String getName();

    String getSerializationName();

    default Class<? extends InstallationData.PostInstallConfig> getConfigClass() {
        return null;
    }

    /**
     * called by the {@code ActionExecutor} before the task is performed to provide current
     * instance of {@code LanguageUtils}.
     *
     * @param langUtils
     */
    default void setLanguageUtils(LanguageUtils langUtils) {};
}
