/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2021 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.screens;

import org.jboss.installer.common.FontResources;
import org.jboss.installer.core.InstallationData;
import org.jboss.installer.core.LanguageUtils;
import org.jboss.installer.core.Screen;
import org.jboss.installer.postinstall.task.LoggingLevelsTask;

import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

public class LoggingConfigurationScreen extends DefaultScreen{

    public static final String NAME = "LoggingConfigurationScreen";
    public static final String TITLE_KEY = "logging_configuration.title";
    public static final String SIDE_NAV_KEY = "logging_configuration.side_nav";
    public static final String DESCRIPTION_KEY = "logging_configuration.description_label";
    public static final String ROOT_LOGGER_KEY = "logging_configuration.root_logger";
    public static final String CONSOLE_LOGGER_KEY = "logging_configuration.console_logger";
    public static final String[] LOGGER_CHOICES = {"ALL", "TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL", "OFF"};
    private final JComboBox<String> rootComboBox = new JComboBox<>(LOGGER_CHOICES);
    private final JComboBox<String> consoleComboBox = new JComboBox<>(LOGGER_CHOICES);
    private final LoggingLevelsTask loggingLevelsTask = new LoggingLevelsTask();

    public LoggingConfigurationScreen(Screen parent, LanguageUtils langUtils, boolean isActive) {
        super(parent, langUtils, isActive);

        rootComboBox.setSelectedItem("INFO");
        consoleComboBox.setSelectedItem("INFO");
    }

    @Override
    public String getTitle() {
        return langUtils.getString(TITLE_KEY);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getSideNavName() {
        return langUtils.getString(SIDE_NAV_KEY);
    }

    @Override
    public JPanel getContent() {
        JPanel content = new JPanel();
        content.setLayout(new GridBagLayout());
        GridBagConstraints c = initializeConstraints();

        c.insets = new Insets(20,20, 50, 0);
        content.add(createDescription(DESCRIPTION_KEY), c);
        c.gridy++;
        addLoggerComponent(content, c, createFieldLabel(ROOT_LOGGER_KEY), rootComboBox);
        addLoggerComponent(content, c, createFieldLabel(CONSOLE_LOGGER_KEY), consoleComboBox);
        fillEmptySpace(content, c);
        return content;
    }

    @Override
    public JComponent getDefaultFocusComponent() {
        return rootComboBox;
    }

    private void addLoggerComponent(JPanel content, GridBagConstraints c, JLabel label, JComboBox<String> comboBox) {
        c.insets = new Insets(0,40, 10, 0);
        content.add(label, c);

        c.gridx = 1;
        c.insets = new Insets(0,0, 10, 140);
        comboBox.setFont(FontResources.getOpenSansRegular());
        content.add(comboBox, c);
        c.gridx = 0;
        c.gridy++;
    }

    @Override
    public void rollback(InstallationData installationData) {
        installationData.removePostInstallTask(loggingLevelsTask);
        installationData.removeConfig(LoggingLevelsTask.Config.class);
    }

    @Override
    public void record(InstallationData installationData) {
        installationData.putConfig(new LoggingLevelsTask.Config
                ((String) rootComboBox.getSelectedItem(), (String) consoleComboBox.getSelectedItem()));
        installationData.addPostInstallTask(loggingLevelsTask);
    }
}
