package org.jboss.installer.auto;

import org.jboss.installer.core.InstallationFailedException;
import org.junit.Test;

import java.nio.file.Files;

import static org.assertj.core.api.Assertions.assertThat;
import static org.junit.Assert.fail;

public class InstallationFailsIfNonEmptyFolderTest extends BaseAutomaticInstallationTest {

    @Test
    public void testInstallationFailsIfNonEmptyFolder() throws Exception {
        Files.createFile(testDir.resolve("test.txt"));

        try {
            automaticInstallation.performInstallation(installationData);
            fail("Should not be possible to install to non-empty folder");
        } catch (InstallationFailedException e) {
            // OK
        }

        assertThat(testDir.toFile().list()).containsOnly("test.txt");
    }
}
