/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2021 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.validators;

import org.jboss.installer.test.utils.MockLanguageUtils;
import org.junit.Assert;
import org.junit.Test;

import static org.jboss.installer.validators.AdminLoginValidator.CONFIRMATION_PASSWORD_MATCH_KEY;
import static org.jboss.installer.validators.AdminLoginValidator.EMPTY_PASSWORD_KEY;
import static org.jboss.installer.validators.AdminLoginValidator.EMPTY_USERNAME_KEY;
import static org.jboss.installer.validators.AdminLoginValidator.NON_ALPHANUMERIC_USERNAME_KEY;

public class AdminLoginValidatorTest {

    private final AdminLoginValidator validator = new AdminLoginValidator(new MockLanguageUtils());
    public static String EMPTY_TEXT = "";

    @Test
    public void emptyUsernameTest() {
        String username = EMPTY_TEXT;
        String password = EMPTY_TEXT;
        Assert.assertEquals(EMPTY_USERNAME_KEY, validator.validate(username, password, password).getMessage());
        password = "password";
        Assert.assertEquals(EMPTY_USERNAME_KEY, validator.validate(username, password, password).getMessage());
    }

    @Test
    public void nonAlphaNumericUsername() {
        String password = EMPTY_TEXT;
        Assert.assertEquals(NON_ALPHANUMERIC_USERNAME_KEY,
                validator.validate("foo&", password, password).getMessage());
        Assert.assertEquals(NON_ALPHANUMERIC_USERNAME_KEY,
                validator.validate("foo bar", password, password).getMessage());
        Assert.assertEquals(NON_ALPHANUMERIC_USERNAME_KEY,
                validator.validate("foo!", password, password).getMessage());
    }

    @Test
    public void emptyPasswordTest() {
        String username = "username";
        String password = EMPTY_TEXT;
        Assert.assertEquals(EMPTY_PASSWORD_KEY, validator.validate(username, password, password).getMessage());
    }

    @Test
    public void notMatchingPasswordTest() {
        String username = "username";
        String password = "password";
        String confirmPassword = "confirmPassword";
        Assert.assertEquals(CONFIRMATION_PASSWORD_MATCH_KEY, validator.validate(username, password, confirmPassword).getMessage());
    }

    @Test
    public void validPasswordTest() {
        String username = "username";
        String password = "password";
        String confirmPassword = "password";
        Assert.assertNull(validator.validate(username, password, confirmPassword).getMessage());
    }

}
