package org.jboss.installer.core.i18n;

import org.jboss.installer.core.LanguageUtils;
import org.junit.Before;
import org.junit.Test;

import java.util.Locale;

import static org.junit.Assert.assertEquals;

public class DefaultLanguageUtilsTest {

    private LanguageUtils utils;

    @Before
    public void setUp() {
        utils = DefaultLanguageUtils.builder().setLocale(new Locale("test")).build();
    }

    @Test
    public void testEvaluation() {
        String message = utils.getString("general.message_with_evaluation", "${general.evaluated}");
        assertEquals(message, "This is evaluated");
    }

    @Test
    public void testExpressionReplacement() {
        String message = utils.getString("general.message_with_expressions");
        assertEquals(message, "This is replaced and this is ${not}, this is also replaced");
    }
}
