/*
 * Copyright 2023 JBoss by Red Hat.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.as.test.manualmode.insights;

import com.fasterxml.jackson.databind.JsonNode;

public class InsightsRequest {

    private String fileName;
    private JsonNode payload;

    public InsightsRequest(String fileName, JsonNode payload) {
        this.fileName = fileName;
        this.payload = payload;
    }

    public boolean isConnect() {
        return (fileName != null) && ((fileName.endsWith("connect.json") || fileName.endsWith("connect.gz")));
    }

    public boolean isUpdate() {
        return (fileName != null) && ((fileName.endsWith("update.json") || fileName.endsWith("update.gz")));
    }

    public JsonNode getPayload() {
        return payload;
    }

    public String getFileName() {
        return fileName;
    }
}
