/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.as.test.integration.ejb.interceptor.method;

import jakarta.ejb.Stateless;
import jakarta.interceptor.Interceptors;

/**
 * @author Stuart Douglas
 */
@Stateless
@Interceptors(SecretInterceptor.class)
public class ClassifiedBean extends AbstractClassifiedBean {

    public String secretMethod() {
        return "Secret";
    }

    @Interceptors(TopSecretInterceptor.class)
    public String topSecretMethod() {
        return "TopSecret";
    }

    public String overloadedMethod(Integer i) {
        return "ArgInt:" + i.toString();
    }

    public String overloadedMethod(String str) {
        return "ArgStr:" + str;
    }

    public String methodWithByteArrayArgument(byte[] array)  {
        return "ByteArray:" + array;
    }

    public String methodWithBooleanArrayArgument(boolean[] array)  {
        return "BooleanArray:" + array;
    }

    public String methodWithCharArrayArgument(char[] array)  {
        return "CharArray:" + array;
    }

    public String methodWithDoubleArrayArgument(double[] array)  {
        return "DoubleArray:" + array;
    }

    public String methodWithFloatArrayArgument(float[] array)  {
        return "FloatArray:" + array;
    }

    public String methodWithIntArrayArgument(int[] array)  {
        return "IntArray:" + array;
    }

    public String methodWithShortArrayArgument(short[] array)  {
        return "ShortArray:" + array;
    }

    public String methodWithLongArrayArgument(long[] array)  {
        return "LongArray:" + array;
    }

    public String methodWithStringArrayArgument(String[] array)  {
        return "Array:" + array;
    }

    public String overridedMethod(String a) {
        return "Str " + a;
    }
}
