/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2024 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.postinstall.task;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;

import org.jboss.installer.auto.AutomaticInstallationParsingException;
import org.jboss.installer.auto.InstallationDataSerializer;
import org.jboss.installer.core.FlatListPostInstallConfig;

public class LoggingLevelConfig extends FlatListPostInstallConfig {
    private String rootLevel;
    private String consoleLevel;

    public LoggingLevelConfig() {
        // noop constructor for deserialization
    }

    public LoggingLevelConfig(String rootLevel, String consoleLevel) {
        this.rootLevel = rootLevel;
        this.consoleLevel = consoleLevel;
    }

    public String getRootLevel() {
        return rootLevel;
    }

    public String getConsoleLevel() {
        return consoleLevel;
    }

    @Override
    protected void acceptAttributes(Map<String, String> attributes, BiFunction<String, String, String> variableResolver) throws AutomaticInstallationParsingException {

        this.rootLevel = attributes.getOrDefault("rootLevel", null);
        this.consoleLevel = attributes.getOrDefault("consoleLevel", null);

        if (rootLevel == null || consoleLevel == null) {
            throw InstallationDataSerializer.unableToParse();
        }
    }

    @Override
    protected Map<String, String> listAttributes() {
        final HashMap<String, String> attrs = new HashMap<>();
        attrs.put("rootLevel", rootLevel);
        attrs.put("consoleLevel", consoleLevel);
        return attrs;
    }

    @Override
    protected Set<String> listVariables() {
        return Collections.emptySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LoggingLevelConfig config = (LoggingLevelConfig) o;
        return Objects.equals(rootLevel, config.rootLevel) && Objects.equals(consoleLevel, config.consoleLevel);
    }

    @Override
    public int hashCode() {
        return Objects.hash(rootLevel, consoleLevel);
    }

    @Override
    public String toString() {
        return "Config{" +
                "rootLevel='" + rootLevel + '\'' +
                ", consoleLevel='" + consoleLevel + '\'' +
                '}';
    }
}
