/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2022 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.validators;

import org.apache.commons.lang3.StringUtils;
import org.jboss.installer.core.LanguageUtils;
import org.jboss.installer.core.ValidationResult;
import org.jboss.installer.postinstall.ldap.LdapModel;

import static org.jboss.installer.screens.LDAPConnectionScreen.LDAP_SCREEN_LABEL_DIRECTORY_SERVER;
import static org.jboss.installer.screens.LDAPConnectionScreen.LDAP_SCREEN_LABEL_DISTINGUISHED_NAME;
import static org.jboss.installer.screens.LDAPConnectionScreen.LDAP_SCREEN_LABEL_DN_PASSWORD;
import static org.jboss.installer.screens.LDAPSecurityRealmScreen.LDAP_REALM_SCREEN_BASE_DN_LABEL;
import static org.jboss.installer.screens.LDAPSecurityRealmScreen.LDAP_REALM_SCREEN_USERNAME_FILTER_LABEL;
import static org.jboss.installer.screens.domain.LdapSecurityDomainPanel.LDAP_PASSWORD_ATTR_LABEL;
import static org.jboss.installer.screens.domain.LdapSecurityDomainPanel.LDAP_ROLE_FILTER_BASE_DN_LABEL;
import static org.jboss.installer.screens.domain.LdapSecurityDomainPanel.LDAP_ROLES_FILTER_LABEL;
import static org.jboss.installer.screens.domain.LdapSecurityDomainPanel.LDAP_ROLES_ATTR_LABEL;
import static org.jboss.installer.validators.CertificateSecurityDomainValidator.GENERIC_VALIDATION_EMPTY_FIELD;

public class LDAPSecurityDomainValidator {

    private final LanguageUtils langUtils;
    public LDAPSecurityDomainValidator(LanguageUtils langUtils) {
        this.langUtils = langUtils;
    }

    public ValidationResult validate(LdapModel config) {
        if (StringUtils.isEmpty(config.getUrl())) {
            return ValidationResult.error(langUtils.getString(GENERIC_VALIDATION_EMPTY_FIELD, langUtils.getString(LDAP_SCREEN_LABEL_DIRECTORY_SERVER)));
        }
        if (StringUtils.isEmpty(config.getLdapUsername())) {
            return ValidationResult.error(langUtils.getString(GENERIC_VALIDATION_EMPTY_FIELD, langUtils.getString(LDAP_SCREEN_LABEL_DISTINGUISHED_NAME)));
        }
        if (StringUtils.isEmpty(config.getLdapPassword())) {
            return ValidationResult.error(langUtils.getString(GENERIC_VALIDATION_EMPTY_FIELD, langUtils.getString(LDAP_SCREEN_LABEL_DN_PASSWORD)));
        }
        if (StringUtils.isEmpty(config.getSearchBaseDn())) {
            return ValidationResult.error(langUtils.getString(GENERIC_VALIDATION_EMPTY_FIELD, langUtils.getString(LDAP_REALM_SCREEN_BASE_DN_LABEL)));
        }
        if (StringUtils.isEmpty(config.getUserFilter())) {
            return ValidationResult.error(langUtils.getString(GENERIC_VALIDATION_EMPTY_FIELD, langUtils.getString(LDAP_REALM_SCREEN_USERNAME_FILTER_LABEL)));
        }
        if (StringUtils.isEmpty(config.getPasswordAttribute())) {
            return ValidationResult.error(langUtils.getString(GENERIC_VALIDATION_EMPTY_FIELD, langUtils.getString(LDAP_PASSWORD_ATTR_LABEL)));
        }
        if (StringUtils.isEmpty(config.getRoleBaseDn())) {
            return ValidationResult.error(langUtils.getString(GENERIC_VALIDATION_EMPTY_FIELD, langUtils.getString(LDAP_ROLE_FILTER_BASE_DN_LABEL)));
        }
        if (StringUtils.isEmpty(config.getRoleFilter())) {
            return ValidationResult.error(langUtils.getString(GENERIC_VALIDATION_EMPTY_FIELD, langUtils.getString(LDAP_ROLES_FILTER_LABEL)));
        }
        if (StringUtils.isEmpty(config.getRoleAttribute())) {
            return ValidationResult.error(langUtils.getString(GENERIC_VALIDATION_EMPTY_FIELD, langUtils.getString(LDAP_ROLES_ATTR_LABEL)));
        }
        return ValidationResult.ok();
    }
}
