/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2022 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.test.utils;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class TestProperties {

    private static Properties properties = new Properties();

    static {
        try {
            properties.load(TestProperties.class.getClassLoader().getResourceAsStream("test_maven.properties"));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, URL> getTestRepositories() {
        final HashMap<String, URL> res = new HashMap<>();
        final String combinedRepositories = properties.getProperty("test.repositories");
        Arrays.stream(combinedRepositories.split(","))
                .map(repoDef->repoDef.split("::"))
                .forEach(v->res.put(v[0], toUrl(v[1])));

        return res;
    }

    private static URL toUrl(String text) {
        try {
            return new URL(text);
        } catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}
