/*
 * Copyright The WildFly Authors
 * SPDX-License-Identifier: Apache-2.0
 */
package org.jboss.as.test.smoke.provisioning;

import java.io.File;
import java.nio.file.Path;

import org.junit.Assert;
import org.junit.Test;


/**
 * Confirm expected files are present in the test installation regardless of how
 * different testsuite execution modes impact how that installation is provisioned.
 */
public class ProductProvisioningTestCase {

    @Test
    public void testJBossEULAtxt() {
        checkFileExists("JBossEULA.txt");
    }

    @Test
    public void testVersiontxt() {
        checkFileExists("version.txt");
    }

    private void checkFileExists(String... relativePath) {
        String jbossHome = System.getProperty("jboss.home");
        Assert.assertTrue(jbossHome + " is not local to the smoke testsuite", jbossHome.contains("smoke"));
        File file = Path.of(jbossHome, relativePath).toFile();
        Assert.assertTrue(file + " does not exist", file.exists());
        Assert.assertFalse(file + " is a directory", file.isDirectory());
    }

}
