package org.jboss.installer.navigation;

/**
 * Represents navigation state changes that {@link org.jboss.installer.core.Screen} is allowed to make.
 */
public interface ScreenNavState {

    /**
     * enable/disable Next button in Installer navigation
     * @param enabled
     */
    void setNextEnabled(boolean enabled);

    /**
     * enable/disable Previous button in Installer navigation
     * @param enabled
     */
    void setPreviousEnabled(boolean enabled);

    /**
     * request focus to one of the nav state buttons
     */
    void requestFocus();
}
