/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2024 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.installer.postinstall;

import java.util.Arrays;

import org.jboss.installer.core.InstallationData;
import org.jboss.installer.core.InstallerRuntimeException;
import org.jboss.installer.postinstall.task.AdminHttpsConfig;
import org.jboss.installer.postinstall.task.ApplicationHttpsConfig;
import org.jboss.installer.postinstall.task.JDBCDriverConfig;
import org.jboss.installer.postinstall.task.CredentialStoreConfig;
import org.jboss.installer.postinstall.task.DatasourceConfig;
import org.jboss.installer.postinstall.task.JSFLibraryConfig;
import org.jboss.installer.postinstall.task.LDAPManagementAuthConfig;
import org.jboss.installer.postinstall.task.LoggingLevelConfig;
import org.jboss.installer.postinstall.task.PortBindingConfig;
import org.jboss.installer.postinstall.task.QuickstartsConfig;
import org.jboss.installer.postinstall.task.SecurityDomainConfig;

public enum PostInstallTask {
    AddAdminUser("add-admin"),
    InstallCredentialStore("add-credential-store", CredentialStoreConfig.class),
    AddDatasource("add-datasource", DatasourceConfig.class),
    EnableHttpsApplication("enable-application-https", ApplicationHttpsConfig.class),
    EnableHttpsAdmin("enable-https", AdminHttpsConfig.class),
    EnableIpv6("enable-ipv6"),
    UpdateJBossCliPort("change-ports-scripts"),
    AddJDBCDriverModule("add-driver-module"),
    InstallJDBCDriver("add-driver", JDBCDriverConfig.class),
    SetJsfDefaultLibrary("set-default-jsf-module"),
    AddJsfLibrary("add-jsf-module", JSFLibraryConfig.class),
    SetupLDAPManagementAuth("setup-ldap-management-auth", LDAPManagementAuthConfig.class),
    ChangeLoggingLevel("change-logging-level", LoggingLevelConfig.class),
    ChangePortConfiguration("change-port-configurations", PortBindingConfig.class),
    AddQuickstarts("add-quickstarts", QuickstartsConfig.class),
    AddSecurityDomain("add-security-domain", SecurityDomainConfig.class);



    private final String name;
    private Class<? extends InstallationData.PostInstallConfig> configClass;

    PostInstallTask(String name) {
        this.name = name;
    }
    PostInstallTask(String name, Class<? extends InstallationData.PostInstallConfig> configClass) {
        this.name = name;
        this.configClass = configClass;
    }

    public static PostInstallTask fromName(String name) {
        return Arrays.stream(values()).filter(t->t.getName().equals(name)).findFirst().orElseThrow(()->new InstallerRuntimeException("Unknown post install operation " + name));
    }

    public String getName() {
        return name;
    }

    public Class<? extends InstallationData.PostInstallConfig> getConfigClass() {
        return configClass;
    }
}
