/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2024 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.postinstall;

import java.beans.PropertyChangeSupport;
import java.io.Closeable;

import org.jboss.installer.core.InstallationData;
import org.jboss.installer.core.InstallationFailedException;

public interface PostInstallTaskRunner extends Closeable {

    String POST_INSTALL_TASK_ERROR="post.install.task.exception";
    String POST_INSTALL_TASK_LOG_ENTRY="post.install.task.log";
    String POST_INSTALL_TASK_NAME_PROPERTY = "post.install.task.name";

    void execute(InstallationData installationData, PropertyChangeSupport propertyChangeSupport) throws InstallationFailedException;

    @Override
    void close();
}
