package org.jboss.installer.postinstall;

import org.jboss.installer.core.LanguageUtils;
import org.jboss.installer.core.LoggerUtils;
import org.jboss.installer.screens.ProcessingScreen;

import java.beans.PropertyChangeSupport;

import static org.jboss.installer.postinstall.PostInstallTaskRunner.POST_INSTALL_TASK_ERROR;
import static org.jboss.installer.postinstall.PostInstallTaskRunner.POST_INSTALL_TASK_LOG_ENTRY;

public class TaskPrinter {

    private final PropertyChangeSupport propertyChangeSupport;
    private LanguageUtils langUtils;

    public TaskPrinter(PropertyChangeSupport propertyChangeSupport) {
        this.propertyChangeSupport = propertyChangeSupport;
    }

    public TaskPrinter(PropertyChangeSupport propertyChangeSupport, LanguageUtils langUtils) {
        this.propertyChangeSupport = propertyChangeSupport;
        this.langUtils = langUtils;
    }

    public void print(String msgKey, String... params) {
        propertyChangeSupport.firePropertyChange(POST_INSTALL_TASK_LOG_ENTRY, null, new ProcessingScreen.TaskLogEntry(
                msgKey, params));
        LoggerUtils.taskLog.info(langUtils.getString(msgKey, params));
    }

    public void print(Exception ex) {
        propertyChangeSupport.firePropertyChange(POST_INSTALL_TASK_ERROR, null, ex);
        LoggerUtils.taskLog.error(ex.getMessage(), ex);
    }
}
