/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2024 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.postinstall.task;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;

import org.jboss.installer.auto.AutomaticInstallationParsingException;
import org.jboss.installer.core.FlatListPostInstallConfig;

public class QuickstartsConfig extends FlatListPostInstallConfig {

    private String quickstartsTargetFolder;
    private String quickstartsRepository;
    private String quickstartsSettingsPath;
    private String quickstartsGithubRepo;
    private String quickstartsGithubBranch;

    public String getQuickstartsTargetFolder() {
        return quickstartsTargetFolder;
    }

    public void setQuickstartsTargetFolder(String quickstartsTargetFolder) {
        this.quickstartsTargetFolder = quickstartsTargetFolder;
    }

    public String getQuickstartsRepository() {
        return quickstartsRepository;
    }

    public void setQuickstartsRepository(String quickstartsRepository) {
        this.quickstartsRepository = quickstartsRepository;
    }

    public String getQuickstartsSettingsPath() {
        return quickstartsSettingsPath;
    }

    public void setQuickstartsSettingsPath(String quickstartsSettingsPath) {
        this.quickstartsSettingsPath = quickstartsSettingsPath;
    }

    public String getQuickstartsGithubRepo() {
        return quickstartsGithubRepo;
    }

    public void setQuickstartsGithubRepo(String quickstartsGithubRepo) {
        this.quickstartsGithubRepo = quickstartsGithubRepo;
    }

    public String getQuickstartsGithubBranch() {
        return quickstartsGithubBranch;
    }

    public void setQuickstartsGithubBranch(String quickstartsGithubBranch) {
        this.quickstartsGithubBranch = quickstartsGithubBranch;
    }

    @Override
    protected Map<String, String> listAttributes() {
        final HashMap<String, String> attrs = new HashMap<>();
        attrs.put("quickstartsTargetFolder", quickstartsTargetFolder);
        attrs.put("quickstartsRepository", quickstartsRepository);
        attrs.put("quickstartsSettingsPath", quickstartsSettingsPath);
        attrs.put("quickstartsGithubRepo", quickstartsGithubRepo);
        attrs.put("quickstartsGithubBranch", quickstartsGithubBranch);
        return attrs;
    }

    @Override
    protected Set<String> listVariables() {
        return Collections.emptySet();
    }

    @Override
    protected void acceptAttributes(Map<String, String> attributes, BiFunction<String, String, String> variableResolver) throws AutomaticInstallationParsingException {
        quickstartsRepository = attributes.getOrDefault("quickstartsRepository", null);
        quickstartsTargetFolder = attributes.getOrDefault("quickstartsTargetFolder", null);
        quickstartsSettingsPath = attributes.getOrDefault("quickstartsSettingsPath", null);
        quickstartsGithubRepo = attributes.getOrDefault("quickstartsGithubRepo", null);
        quickstartsGithubBranch = attributes.getOrDefault("quickstartsGithubBranch", null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        QuickstartsConfig config = (QuickstartsConfig) o;
        return Objects.equals(quickstartsTargetFolder, config.quickstartsTargetFolder) && Objects.equals(quickstartsRepository, config.quickstartsRepository) && Objects.equals(quickstartsSettingsPath, config.quickstartsSettingsPath) && Objects.equals(quickstartsGithubRepo, config.quickstartsGithubRepo) && Objects.equals(quickstartsGithubBranch, config.quickstartsGithubBranch);
    }

    @Override
    public int hashCode() {
        return Objects.hash(quickstartsTargetFolder, quickstartsRepository, quickstartsSettingsPath, quickstartsGithubRepo, quickstartsGithubBranch);
    }

    @Override
    public String toString() {
        return "Config{" +
                "quickstartsTargetFolder='" + quickstartsTargetFolder + '\'' +
                ", quickstartsRepository='" + quickstartsRepository + '\'' +
                ", quickstartsSettingsPath='" + quickstartsSettingsPath + '\'' +
                ", quickstartsGithubRepo='" + quickstartsGithubRepo + '\'' +
                ", quickstartsGithubBranch='" + quickstartsGithubBranch + '\'' +
                '}';
    }
}
