/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2024 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.postinstall.task.secdom;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class PropertiesFileConfig {
    // serialization keys
    private static final String USERS_FILE_PATH = "standaloneUsersFilePath";
    private static final String GROUPS_FILE_PATH = "standaloneGroupsFilePath";
    private static final String PLAIN_TEXT = "plainText";
    private static final String HASH_ENCODING = "hashEncoding";
    private static final String HASH_CHARSET = "hashCharset";
    // end of serialization keys
    private Path usersFilePath;
    private Path groupsFilePath;
    private boolean plainText;
    private String hashEncoding;
    private String hashCharset;

    public PropertiesFileConfig() {

    }

    public PropertiesFileConfig(Map<String, String> attributes) {
        usersFilePath = Paths.get(attributes.get(USERS_FILE_PATH));
        groupsFilePath = Paths.get(attributes.get(GROUPS_FILE_PATH));

        plainText = Boolean.parseBoolean(attributes.get(PLAIN_TEXT));
        hashEncoding = attributes.get(HASH_ENCODING);
        hashCharset = attributes.get(HASH_CHARSET);
    }

    public Map<String, String> toAttributes() {
        final HashMap<String, String> attrs = new HashMap<>();
        attrs.put(USERS_FILE_PATH, usersFilePath.toString());
        attrs.put(GROUPS_FILE_PATH, groupsFilePath.toString());
        attrs.put(PLAIN_TEXT, plainText + "");
        attrs.put(HASH_ENCODING, hashEncoding);
        attrs.put(HASH_CHARSET, hashCharset);
        return attrs;
    }

    public Path getUsersFilePath() {
        return usersFilePath;
    }

    public void setUsersFilePath(Path standaloneUsersFilePath) {
        this.usersFilePath = standaloneUsersFilePath;
    }

    public Path getGroupsFilePath() {
        return groupsFilePath;
    }

    public void setGroupsFilePath(Path standaloneGroupsFilePath) {
        this.groupsFilePath = standaloneGroupsFilePath;
    }

    public boolean isPlainText() {
        return plainText;
    }

    public void setPlainText(boolean plainText) {
        this.plainText = plainText;
    }

    public String getHashEncoding() {
        return hashEncoding;
    }

    public void setHashEncoding(String hashEncoding) {
        this.hashEncoding = hashEncoding;
    }

    public String getHashCharset() {
        return hashCharset;
    }

    public void setHashCharset(String hashCharset) {
        this.hashCharset = hashCharset;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PropertiesFileConfig that = (PropertiesFileConfig) o;
        return plainText == that.plainText && Objects.equals(usersFilePath, that.usersFilePath) && Objects.equals(groupsFilePath, that.groupsFilePath) && Objects.equals(hashEncoding, that.hashEncoding) && Objects.equals(hashCharset, that.hashCharset);
    }

    @Override
    public int hashCode() {
        return Objects.hash(usersFilePath, groupsFilePath, plainText, hashEncoding, hashCharset);
    }
}
