package org.jboss.installer.validators;

import org.jboss.installer.core.ValidationResult;
import org.jboss.installer.test.utils.MockLanguageUtils;
import org.junit.Test;

import static org.jboss.installer.validators.PasswordEqualityValidator.NO_PASSWORD;
import static org.jboss.installer.validators.PasswordEqualityValidator.NO_PASSWORD_CONFIRMATION;
import static org.jboss.installer.validators.PasswordEqualityValidator.PASSWORD_NOT_MATCHED;
import static org.junit.Assert.*;

public class PasswordEqualityValidatorTest {

    private PasswordEqualityValidator validator = new PasswordEqualityValidator(new MockLanguageUtils());

    @Test
    public void testNullPassword1GetsError() throws Exception {
        final ValidationResult res = validator.validate(null, "foo");
        assertEquals(ValidationResult.Result.ERROR, res.getResult());
        assertEquals(NO_PASSWORD, res.getMessage());
    }

    @Test
    public void testNullPassword2GetsError() throws Exception {
        final ValidationResult res = validator.validate("foo", null);
        assertEquals(ValidationResult.Result.ERROR, res.getResult());
        assertEquals(NO_PASSWORD_CONFIRMATION, res.getMessage());
    }

    @Test
    public void testEmptyPassword1GetsError() throws Exception {
        final ValidationResult res = validator.validate("", "foo");
        assertEquals(ValidationResult.Result.ERROR, res.getResult());
        assertEquals(NO_PASSWORD, res.getMessage());
    }

    @Test
    public void testEmptyPassword2GetsError() throws Exception {
        final ValidationResult res = validator.validate("foo", "");
        assertEquals(ValidationResult.Result.ERROR, res.getResult());
        assertEquals(NO_PASSWORD_CONFIRMATION, res.getMessage());
    }

    @Test
    public void testMismatchedPasswordsGetsError() throws Exception {
        final ValidationResult res = validator.validate("foo", "bar");
        assertEquals(ValidationResult.Result.ERROR, res.getResult());
        assertEquals(PASSWORD_NOT_MATCHED, res.getMessage());
    }

    @Test
    public void testMatchingPasswordsGetsOK() throws Exception {
        final ValidationResult res = validator.validate("foo", "foo");
        assertEquals(ValidationResult.Result.OK, res.getResult());
    }
}