/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2021 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.installer.test.utils;

import java.util.Locale;

import org.jboss.installer.core.LanguageUtils;

public class MockLanguageUtils implements LanguageUtils {
    @Override
    public String getString(String key) {
        return key;
    }

    @Override
    public String getString(String key, String... params) {
        if (params == null || params.length == 0) {
            return getString(key);
        } else {
            return String.format("%s [%s]", key, String.join(",", params));
        }
    }

    @Override
    public Locale getLocale() {
        return Locale.getDefault();
    }

    @Override
    public boolean hasString(String key) {
        return true;
    }
}
