/*
 * Copyright 2021 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.migration.wfly.task.hostexclude;

import org.jboss.migration.core.jboss.HostExclude;
import org.jboss.migration.core.jboss.HostExcludes;
import org.jboss.migration.core.jboss.JBossExtensionNames;
import org.jboss.migration.wfly10.config.task.hostexclude.AddHostExcludes;

/**
 * @author emmartins
 */
public class WildFly25_0AddHostExcludes<S> extends AddHostExcludes<S> {

    private static final HostExcludes HOST_EXCLUDES = HostExcludes.builder()
            .hostExclude(HostExclude.builder()
                    .name("WildFly10.0")
                    .release("WildFly10.0")
                    .excludedExtension("org.wildfly.extension.clustering.web")
                    .excludedExtension("org.wildfly.extension.core-management")
                    .excludedExtension("org.wildfly.extension.datasources-agroal")
                    .excludedExtension("org.wildfly.extension.discovery")
                    .excludedExtension("org.wildfly.extension.ee-security")
                    .excludedExtension("org.wildfly.extension.elytron")
                    .excludedExtension("org.wildfly.extension.health")
                    .excludedExtension("org.wildfly.extension.metrics")
                    .excludedExtension("org.wildfly.extension.microprofile.config-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.fault-tolerance-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.health-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.jwt-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.metrics-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.openapi-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.opentracing-smallrye")
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_MESSAGING_SMALLRYE)
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_STREAMS_OPERATORS_SMALLRYE))
            .hostExclude(HostExclude.builder()
                    .name("WildFly10.1")
                    .release("WildFly10.1")
                    .excludedExtension("org.wildfly.extension.clustering.web")
                    .excludedExtension("org.wildfly.extension.core-management")
                    .excludedExtension("org.wildfly.extension.datasources-agroal")
                    .excludedExtension("org.wildfly.extension.discovery")
                    .excludedExtension("org.wildfly.extension.ee-security")
                    .excludedExtension("org.wildfly.extension.elytron")
                    .excludedExtension("org.wildfly.extension.health")
                    .excludedExtension("org.wildfly.extension.metrics")
                    .excludedExtension("org.wildfly.extension.microprofile.config-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.fault-tolerance-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.health-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.jwt-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.metrics-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.openapi-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.opentracing-smallrye")
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_MESSAGING_SMALLRYE)
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_STREAMS_OPERATORS_SMALLRYE))
            .hostExclude(HostExclude.builder()
                    .name("WildFly11.0")
                    .release("WildFly11.0")
                    .excludedExtension("org.wildfly.extension.clustering.web")
                    .excludedExtension("org.wildfly.extension.datasources-agroal")
                    .excludedExtension("org.wildfly.extension.ee-security")
                    .excludedExtension("org.wildfly.extension.health")
                    .excludedExtension("org.wildfly.extension.metrics")
                    .excludedExtension("org.wildfly.extension.microprofile.config-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.fault-tolerance-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.health-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.jwt-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.metrics-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.openapi-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.opentracing-smallrye")
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_MESSAGING_SMALLRYE)
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_STREAMS_OPERATORS_SMALLRYE))
            .hostExclude(HostExclude.builder()
                    .name("WildFly12.0")
                    .release("WildFly12.0")
                    .excludedExtension("org.wildfly.extension.clustering.web")
                    .excludedExtension("org.wildfly.extension.datasources-agroal")
                    .excludedExtension("org.wildfly.extension.ee-security")
                    .excludedExtension("org.wildfly.extension.health")
                    .excludedExtension("org.wildfly.extension.metrics")
                    .excludedExtension("org.wildfly.extension.microprofile.config-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.fault-tolerance-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.health-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.jwt-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.metrics-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.openapi-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.opentracing-smallrye")
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_MESSAGING_SMALLRYE)
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_STREAMS_OPERATORS_SMALLRYE))
            .hostExclude(HostExclude.builder()
                    .name("WildFly13.0")
                    .release("WildFly13.0")
                    .excludedExtension("org.wildfly.extension.clustering.web")
                    .excludedExtension("org.wildfly.extension.datasources-agroal")
                    .excludedExtension("org.wildfly.extension.health")
                    .excludedExtension("org.wildfly.extension.metrics")
                    .excludedExtension("org.wildfly.extension.microprofile.config-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.fault-tolerance-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.health-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.jwt-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.metrics-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.openapi-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.opentracing-smallrye")
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_MESSAGING_SMALLRYE)
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_STREAMS_OPERATORS_SMALLRYE))
            .hostExclude(HostExclude.builder()
                    .name("WildFly14.0")
                    .release("WildFly14.0")
                    .excludedExtension("org.wildfly.extension.clustering.web")
                    .excludedExtension("org.wildfly.extension.health")
                    .excludedExtension("org.wildfly.extension.metrics")
                    .excludedExtension("org.wildfly.extension.microprofile.fault-tolerance-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.jwt-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.metrics-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.openapi-smallrye")
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_MESSAGING_SMALLRYE)
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_STREAMS_OPERATORS_SMALLRYE))
            .hostExclude(HostExclude.builder()
                    .name("WildFly15.0")
                    .release("WildFly15.0")
                    .excludedExtension("org.wildfly.extension.clustering.web")
                    .excludedExtension("org.wildfly.extension.health")
                    .excludedExtension("org.wildfly.extension.metrics")
                    .excludedExtension("org.wildfly.extension.microprofile.fault-tolerance-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.jwt-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.openapi-smallrye")
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_MESSAGING_SMALLRYE)
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_STREAMS_OPERATORS_SMALLRYE))
            .hostExclude(HostExclude.builder()
                    .name("WildFly16.0")
                    .release("WildFly16.0")
                    .excludedExtension("org.wildfly.extension.health")
                    .excludedExtension("org.wildfly.extension.metrics")
                    .excludedExtension("org.wildfly.extension.microprofile.fault-tolerance-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.jwt-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.openapi-smallrye")
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_MESSAGING_SMALLRYE)
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_STREAMS_OPERATORS_SMALLRYE))
            .hostExclude(HostExclude.builder()
                    .name("WildFly17.0")
                    .release("WildFly17.0")
                    .excludedExtension("org.wildfly.extension.health")
                    .excludedExtension("org.wildfly.extension.metrics")
                    .excludedExtension("org.wildfly.extension.microprofile.fault-tolerance-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.jwt-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.openapi-smallrye")
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_MESSAGING_SMALLRYE)
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_STREAMS_OPERATORS_SMALLRYE))
            .hostExclude(HostExclude.builder()
                    .name("WildFly18.0")
                    .release("WildFly18.0")
                    .excludedExtension("org.wildfly.extension.health")
                    .excludedExtension("org.wildfly.extension.metrics")
                    .excludedExtension("org.wildfly.extension.microprofile.fault-tolerance-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.jwt-smallrye")
                    .excludedExtension("org.wildfly.extension.microprofile.openapi-smallrye")
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_MESSAGING_SMALLRYE)
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_STREAMS_OPERATORS_SMALLRYE))
            .hostExclude(HostExclude.builder()
                    .name("WildFly19.0")
                    .release("WildFly19.0")
                    .excludedExtension("org.wildfly.extension.health")
                    .excludedExtension("org.wildfly.extension.metrics")
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_MESSAGING_SMALLRYE)
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_STREAMS_OPERATORS_SMALLRYE))
            .hostExclude(HostExclude.builder()
                    .name("WildFly20.0")
                    .release("WildFly20.0")
                    .excludedExtension("org.wildfly.extension.health")
                    .excludedExtension("org.wildfly.extension.metrics")
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_MESSAGING_SMALLRYE)
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_STREAMS_OPERATORS_SMALLRYE))
            .hostExclude(HostExclude.builder()
                    .name("WildFly21.0")
                    .release("WildFly21.0")
                    .excludedExtension("org.wildfly.extension.health")
                    .excludedExtension("org.wildfly.extension.metrics")
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_MESSAGING_SMALLRYE)
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_STREAMS_OPERATORS_SMALLRYE))
            .hostExclude(HostExclude.builder()
                    .name("WildFly22.0")
                    .release("WildFly22.0")
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_MESSAGING_SMALLRYE)
                    .excludedExtension(JBossExtensionNames.MICROPROFILE_REACTIVE_STREAMS_OPERATORS_SMALLRYE))
            .build();

    public WildFly25_0AddHostExcludes() {
        super(HOST_EXCLUDES);
    }
}
