# Build instructions
JDK 11+ and Apache Maven 3.6+ are needed to build the project.

`mvn clean install` will build the executable jar in target as well as run all the tests.

# Running installer

## Running GUI mode

`java -jar target/jboss-eap-installer-<VERSION>.jar`

## Running scripted installation

On the last screen of GUI installer, user has a choice to generate an installation script. That script can be used to execute a scripted installation:

`java -jar target/jboss-eap-installer-<VERSION>.jar <PATH/TO/SCRIPT_FILE>`

# Project properties

Apart from the component versions there is a number of properties used to customize the installation:

## [pom.xml](pom.xml) properties

| Property                | Description                                                                                                                                                           | Example                                                                                                                           |
|-------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------|
| eap.release.version     | The version used in the installer title or in the default folders. Does not affect which version of EAP/WF is installed                                               | 8.1                                                                                                                               |
| prospero.eap.profile    | The Prospero profile used to provision the server. Note it needs to be available in the Prospero distribution.                                                        | eap-8.1                                                                                                                           |
| prospero.eap.fpl        | The Feature Pack Location of the server's galleon FP. Used to apply changes to provisioning configuration (e.g. exclude packages)                                     | org.wildfly:wildfly-ee-galleon-pack::zip                                                                                          |
| myfaces.feature-pack.ga | The Maven GA of the feature pack providing MyFaces extenion. Used in the JSF post-intallation task                                                                    | org.wildfly:wildfly-myfaces-feature-pack                                                                                          |
| product.repositories    | Comma separated list of the default Maven repositories used by the Installer | central::https://repo1.maven.org/maven2/ |
| test.repositories       | Comma separated list of the Maven repositories used by the tests to provision the server. Used to override the default repositories e.g. to add an internal repository | central::https://repo1.maven.org/maven2/ |

# Task runner design

After the EAP is installed, the user can choose to perform additional configuration. Some of the tasks use JBoss CLI to perform changes to the EAP configurations. The installer doesn't include the client dependencies in the "fat" jar to reduce the amount of rebuilds required.

In order to do this, the tasks depending on the EAP client code are separated into a separate `tasks.jar`. This jar is then shipped inside the installer "fat" jar, but not included in the default classloader. After the initial provisioning, the installer will extract the `tasks.jar` into a temp folder and create a new classloader adding the extracted jar and provisioned `jboss-cli-client.jar`. This classloader will than be used to execute configured tasks.

The tasks listed in the `PostInstallTask` need to be implemented in the `tasks` module. The tasks can define a `Config` class used to pass configuration options set by the user in the GUI to the task implementation.

The tasks are executed by `PostInstallRunner` implemented in the `tasks` module.

# Project structure

## Core

This is the main component of the Installer. Most of the code should live in this module unless it has dependency on WildFly code that is dynamically loaded after the installation.

This module contains the classes required to pass task configurations between the GUI and the task implementations in `tasks` module.

## Tasks

This module contains code related to implementations of tasks that can be performed after the installation. Code in this module can use `wildfly-cli:client` dependencies which are unavailable to the other modules.

## Dist

This module assembles the final "fat" jar. It can also contain tests that verify integration between `core` and `tasks` code.

## Tests util

Testing utility code used in tests that is shared between other modules.
