/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodDirector;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpClient {
    private static final Log LOG = LogFactory.getLog(HttpClient.class);
    private HttpConnectionManager httpConnectionManager;
    private HttpState state = new HttpState();
    private HttpClientParams params = null;
    private HostConfiguration hostConfiguration = new HostConfiguration();

    public HttpClient() {
        this(new HttpClientParams());
    }

    public HttpClient(HttpClientParams httpClientParams) {
        if (httpClientParams == null) {
            throw new IllegalArgumentException("Params may not be null");
        }
        this.params = httpClientParams;
        this.httpConnectionManager = null;
        Class clazz = httpClientParams.getConnectionManagerClass();
        if (clazz != null) {
            try {
                this.httpConnectionManager = (HttpConnectionManager)clazz.newInstance();
            }
            catch (Exception exception) {
                LOG.warn((Object)"Error instantiating connection manager class, defaulting to SimpleHttpConnectionManager", (Throwable)exception);
            }
        }
        if (this.httpConnectionManager == null) {
            this.httpConnectionManager = new SimpleHttpConnectionManager();
        }
        if (this.httpConnectionManager != null) {
            this.httpConnectionManager.getParams().setDefaults(this.params);
        }
    }

    public HttpClient(HttpClientParams httpClientParams, HttpConnectionManager httpConnectionManager) {
        if (httpConnectionManager == null) {
            throw new IllegalArgumentException("httpConnectionManager cannot be null");
        }
        if (httpClientParams == null) {
            throw new IllegalArgumentException("Params may not be null");
        }
        this.params = httpClientParams;
        this.httpConnectionManager = httpConnectionManager;
        this.httpConnectionManager.getParams().setDefaults(this.params);
    }

    public HttpClient(HttpConnectionManager httpConnectionManager) {
        this(new HttpClientParams(), httpConnectionManager);
    }

    public synchronized HttpState getState() {
        return this.state;
    }

    public synchronized void setState(HttpState httpState) {
        this.state = httpState;
    }

    public synchronized void setStrictMode(boolean bl) {
        if (bl) {
            this.params.makeStrict();
        } else {
            this.params.makeLenient();
        }
    }

    public synchronized boolean isStrictMode() {
        return false;
    }

    public synchronized void setTimeout(int n) {
        this.params.setSoTimeout(n);
    }

    public synchronized void setHttpConnectionFactoryTimeout(long l) {
        this.params.setConnectionManagerTimeout(l);
    }

    public synchronized void setConnectionTimeout(int n) {
        this.httpConnectionManager.getParams().setConnectionTimeout(n);
    }

    public int executeMethod(HttpMethod httpMethod) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpClient.executeMethod(HttpMethod)");
        return this.executeMethod(null, httpMethod, null);
    }

    public int executeMethod(HostConfiguration hostConfiguration, HttpMethod httpMethod) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpClient.executeMethod(HostConfiguration,HttpMethod)");
        return this.executeMethod(hostConfiguration, httpMethod, null);
    }

    public int executeMethod(HostConfiguration hostConfiguration, HttpMethod httpMethod, HttpState httpState) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpClient.executeMethod(HostConfiguration,HttpMethod,HttpState)");
        if (httpMethod == null) {
            throw new IllegalArgumentException("HttpMethod parameter may not be null");
        }
        HostConfiguration hostConfiguration2 = this.getHostConfiguration();
        if (hostConfiguration == null) {
            hostConfiguration = hostConfiguration2;
        }
        URI uRI = httpMethod.getURI();
        if (hostConfiguration == hostConfiguration2 || uRI.isAbsoluteURI()) {
            hostConfiguration = (HostConfiguration)hostConfiguration.clone();
            if (uRI.isAbsoluteURI()) {
                hostConfiguration.setHost(uRI);
            }
        }
        HttpMethodDirector httpMethodDirector = new HttpMethodDirector(this.getHttpConnectionManager(), hostConfiguration, this.params, httpState == null ? this.getState() : httpState);
        httpMethodDirector.executeMethod(httpMethod);
        return httpMethod.getStatusCode();
    }

    public String getHost() {
        return this.hostConfiguration.getHost();
    }

    public int getPort() {
        return this.hostConfiguration.getPort();
    }

    public synchronized HostConfiguration getHostConfiguration() {
        return this.hostConfiguration;
    }

    public synchronized void setHostConfiguration(HostConfiguration hostConfiguration) {
        this.hostConfiguration = hostConfiguration;
    }

    public synchronized HttpConnectionManager getHttpConnectionManager() {
        return this.httpConnectionManager;
    }

    public synchronized void setHttpConnectionManager(HttpConnectionManager httpConnectionManager) {
        this.httpConnectionManager = httpConnectionManager;
        if (this.httpConnectionManager != null) {
            this.httpConnectionManager.getParams().setDefaults(this.params);
        }
    }

    public HttpClientParams getParams() {
        return this.params;
    }

    public void setParams(HttpClientParams httpClientParams) {
        if (httpClientParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        this.params = httpClientParams;
    }

    static {
        if (LOG.isDebugEnabled()) {
            try {
                LOG.debug((Object)("Java version: " + System.getProperty("java.version")));
                LOG.debug((Object)("Java vendor: " + System.getProperty("java.vendor")));
                LOG.debug((Object)("Java class path: " + System.getProperty("java.class.path")));
                LOG.debug((Object)("Operating system name: " + System.getProperty("os.name")));
                LOG.debug((Object)("Operating system architecture: " + System.getProperty("os.arch")));
                LOG.debug((Object)("Operating system version: " + System.getProperty("os.version")));
                Provider[] providerArray = Security.getProviders();
                for (int i = 0; i < providerArray.length; ++i) {
                    Provider provider = providerArray[i];
                    LOG.debug((Object)(provider.getName() + " " + provider.getVersion() + ": " + provider.getInfo()));
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }
}

