/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.provider;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import org.opensaml.ReplayCache;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLException;
import org.w3c.dom.Element;

public class MemoryReplayCacheProvider
implements ReplayCache {
    private TreeMap replayExpMap = new TreeMap();
    private HashSet replayCache = new HashSet();
    private int skew = 1000 * SAMLConfig.instance().getIntProperty("org.opensaml.clock-skew");

    public MemoryReplayCacheProvider(Element element) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check(String string, Date date) throws SAMLException {
        MemoryReplayCacheProvider memoryReplayCacheProvider = this;
        synchronized (memoryReplayCacheProvider) {
            Set<Long> set = this.replayExpMap.headMap(new Long(date.getTime() - (long)this.skew)).keySet();
            Iterator<Long> iterator = set.iterator();
            while (iterator.hasNext()) {
                this.replayCache.remove(this.replayExpMap.get(iterator.next()));
            }
            set.clear();
            if (!this.replayCache.add(string)) {
                return false;
            }
            long l = date.getTime() + (long)this.skew;
            while (this.replayExpMap.containsKey(new Long(l))) {
                ++l;
            }
            this.replayExpMap.put(new Long(l), string);
            return true;
        }
    }
}

