/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Vector;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Membership;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.GmsImpl;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.protocols.pbcast.MergeData;
import org.jgroups.util.Digest;
import org.jgroups.util.MutableDigest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoordGmsImpl
extends GmsImpl {
    private volatile boolean merging = false;
    private final MergeTask merge_task = new MergeTask();
    private final Vector<MergeData> merge_rsps = new Vector(11);
    private ViewId merge_id = null;
    private Future<?> merge_canceller_future = null;
    private final Lock merge_canceller_lock = new ReentrantLock();
    private final Long MAX_SUSPEND_TIMEOUT = new Long(30000L);

    public CoordGmsImpl(GMS g) {
        super(g);
    }

    private void setMergeId(ViewId merge_id) {
        this.merge_id = merge_id;
        if (this.merge_id != null) {
            this.stopMergeCanceller();
            this.startMergeCanceller();
        } else {
            this.stopMergeCanceller();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startMergeCanceller() {
        this.merge_canceller_lock.lock();
        try {
            if (this.merge_canceller_future == null || this.merge_canceller_future.isDone()) {
                MergeCanceller task = new MergeCanceller(this.merge_id, this.gms.merge_timeout);
                this.merge_canceller_future = this.gms.timer.schedule(task, this.gms.merge_timeout, TimeUnit.MILLISECONDS);
            }
            Object var3_2 = null;
            this.merge_canceller_lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.merge_canceller_lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopMergeCanceller() {
        this.merge_canceller_lock.lock();
        try {
            if (this.merge_canceller_future != null) {
                this.merge_canceller_future.cancel(true);
                this.merge_canceller_future = null;
            }
            Object var2_1 = null;
            this.merge_canceller_lock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.merge_canceller_lock.unlock();
            throw throwable;
        }
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.cancelMerge();
    }

    @Override
    public void join(Address mbr) {
        this.wrongMethod("join");
    }

    @Override
    public void joinWithStateTransfer(Address mbr) {
        this.wrongMethod("join");
    }

    @Override
    public void leave(Address mbr) {
        if (mbr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"member's address is null !");
            }
            return;
        }
        if (mbr.equals(this.gms.local_addr)) {
            this.leaving = true;
        }
        this.gms.getViewHandler().add(new GmsImpl.Request(2, mbr, false, null));
        this.gms.getViewHandler().stop(true);
        this.gms.getViewHandler().waitUntilCompleted(this.gms.leave_timeout);
    }

    @Override
    public void handleJoinResponse(JoinRsp join_rsp) {
    }

    @Override
    public void handleLeaveResponse() {
    }

    @Override
    public void suspect(Address mbr) {
        if (mbr.equals(this.gms.local_addr)) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"I am the coord and I'm suspected -- will probably leave shortly");
            }
            return;
        }
        LinkedHashSet<GmsImpl.Request> suspected = new LinkedHashSet<GmsImpl.Request>(1);
        suspected.add(new GmsImpl.Request(3, mbr, true, null));
        this.handleMembershipChange(suspected);
    }

    @Override
    public void unsuspect(Address mbr) {
    }

    @Override
    public void merge(Vector<Address> other_coords) {
        if (this.merging) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("merge already in progress, discarded MERGE event (I am " + this.gms.local_addr + ")"));
            }
            return;
        }
        if (other_coords == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"list of other coordinators is null. Will not start merge.");
            }
            return;
        }
        if (other_coords.size() <= 1) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("number of coordinators found is " + other_coords.size() + "; will not perform merge"));
            }
            return;
        }
        Membership tmp = new Membership(other_coords);
        tmp.sort();
        Address merge_leader = tmp.elementAt(0);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Determining merge leader from coordinators: " + tmp));
        }
        if (merge_leader.equals(this.gms.local_addr) || this.gms.merge_leader) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("I (" + this.gms.local_addr + ") will be the leader. Starting the merge task for " + other_coords));
            }
            this.startMergeTask(other_coords);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("I (" + this.gms.local_addr + ") am not the merge leader, " + "waiting for merge leader (" + merge_leader + ") to initiate merge"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMergeRequest(Address sender, ViewId merge_id) {
        block15: {
            block14: {
                if (sender == null) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"sender == null; cannot send back a response");
                    }
                    return;
                }
                if (this.merging) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)("For merge participant " + this.gms.local_addr + " merge is already in progress"));
                    }
                    this.sendMergeRejectedResponse(sender, merge_id);
                    return;
                }
                this.merging = true;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Suspending view handler at " + this.gms.local_addr));
                }
                this.gms.getViewHandler().suspend(merge_id);
                this.setMergeId(merge_id);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(this.gms.local_addr + " got merge request from " + sender + ", merge_id=" + merge_id));
                }
                View view = new View(this.gms.view_id.copy(), this.gms.members.getMembers());
                boolean suceesfulFlush = false;
                try {
                    suceesfulFlush = this.gms.startFlush(view);
                    Object var7_5 = null;
                    if (!suceesfulFlush) break block14;
                    Digest digest = this.gms.getDigest();
                    this.sendMergeResponse(sender, view, digest);
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    if (suceesfulFlush) {
                        Digest digest = this.gms.getDigest();
                        this.sendMergeResponse(sender, view, digest);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)(this.gms.local_addr + " responded to " + sender + ", merge_id=" + merge_id));
                        }
                    } else {
                        this.sendMergeRejectedResponse(sender, merge_id);
                        this.gms.getViewHandler().resume(merge_id);
                        this.merging = false;
                        if (this.log.isWarnEnabled()) {
                            this.log.warn((Object)("Since flush failed at " + this.gms.local_addr + " rejected merge to " + sender + ", merge_id=" + merge_id));
                        }
                    }
                    throw throwable;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(this.gms.local_addr + " responded to " + sender + ", merge_id=" + merge_id));
                }
                break block15;
            }
            this.sendMergeRejectedResponse(sender, merge_id);
            this.gms.getViewHandler().resume(merge_id);
            this.merging = false;
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("Since flush failed at " + this.gms.local_addr + " rejected merge to " + sender + ", merge_id=" + merge_id));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMergeResponse(MergeData data, ViewId merge_id) {
        if (merge_id == null || this.merge_id == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("merge_id (" + merge_id + ") or this.merge_id (" + this.merge_id + ") is null (sender=" + data.getSender() + ")."));
            }
            return;
        }
        if (!this.merge_id.equals(merge_id)) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("this.merge_id (" + this.merge_id + ") is different from merge_id (" + merge_id + ')'));
            }
            return;
        }
        Vector<MergeData> vector = this.merge_rsps;
        synchronized (vector) {
            if (!this.merge_rsps.contains(data)) {
                this.merge_rsps.addElement(data);
                this.merge_rsps.notifyAll();
            }
        }
    }

    @Override
    public void handleMergeView(MergeData data, ViewId merge_id) {
        if (merge_id == null || this.merge_id == null || !this.merge_id.equals(merge_id)) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"merge_ids don't match (or are null); merge view discarded");
            }
            return;
        }
        Vector<Address> newViewMembers = new Vector<Address>(data.view.getMembers());
        newViewMembers.removeAll(this.gms.members.getMembers());
        this.gms.castViewChangeWithDest(data.view, data.digest, null, newViewMembers);
        if (this.gms.flushProtocolInStack) {
            Message ack = new Message(data.getSender(), null, null);
            ack.setFlag((byte)1);
            GMS.GmsHeader ack_hdr = new GMS.GmsHeader(12);
            ack.putHeader(this.gms.getName(), ack_hdr);
            this.gms.getDownProtocol().down(new Event(1, ack));
        }
        this.merging = false;
        this.gms.getViewHandler().resume(merge_id);
    }

    @Override
    public void handleMergeCancelled(ViewId merge_id) {
        this.gms.stopFlush();
        if (merge_id != null && this.merge_id != null && this.merge_id.equals(merge_id)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("merge was cancelled at merge participant " + this.gms.local_addr + " (merge_id=" + merge_id + ")"));
            }
            this.setMergeId(null);
            this.merging = false;
            this.gms.getViewHandler().resume(merge_id);
        } else if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("merge was supposed to be cancelled at merge participant " + this.gms.local_addr + " (merge_id=" + merge_id + "), but it is not since merge ids do not match"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelMerge() {
        ViewId tmp = this.merge_id;
        if (this.merge_id != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("cancelling merge (merge_id=" + this.merge_id + ')'));
        }
        this.setMergeId(null);
        this.stopMergeTask();
        this.merging = false;
        Vector<MergeData> vector = this.merge_rsps;
        synchronized (vector) {
            this.merge_rsps.clear();
        }
        this.gms.getViewHandler().resume(tmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleMembershipChange(Collection<GmsImpl.Request> requests) {
        boolean hasJoiningMembers;
        boolean joinAndStateTransferInitiated;
        block30: {
            block29: {
                joinAndStateTransferInitiated = false;
                LinkedHashSet<Address> new_mbrs = new LinkedHashSet<Address>(requests.size());
                LinkedHashSet<Address> suspected_mbrs = new LinkedHashSet<Address>(requests.size());
                LinkedHashSet<Address> leaving_mbrs = new LinkedHashSet<Address>(requests.size());
                block8: for (GmsImpl.Request req : requests) {
                    switch (req.type) {
                        case 1: {
                            new_mbrs.add(req.mbr);
                            break;
                        }
                        case 6: {
                            new_mbrs.add(req.mbr);
                            joinAndStateTransferInitiated = true;
                            break;
                        }
                        case 2: {
                            if (req.suspected) {
                                suspected_mbrs.add(req.mbr);
                                break;
                            }
                            leaving_mbrs.add(req.mbr);
                            break;
                        }
                        case 3: {
                            suspected_mbrs.add(req.mbr);
                            continue block8;
                        }
                    }
                }
                new_mbrs.remove(this.gms.local_addr);
                if (this.gms.view_id == null) {
                    if (!this.log.isDebugEnabled()) return;
                    this.log.debug((Object)("gms.view_id is null, I'm not the coordinator anymore (leaving=" + this.leaving + "); the new coordinator will handle the leave request"));
                    return;
                }
                Vector<Address> current_members = this.gms.members.getMembers();
                leaving_mbrs.retainAll(current_members);
                if (suspected_mbrs.remove(this.gms.local_addr) && this.log.isWarnEnabled()) {
                    this.log.warn((Object)"I am the coord and I'm being suspected -- will probably leave shortly");
                }
                suspected_mbrs.retainAll(current_members);
                Iterator it = new_mbrs.iterator();
                while (it.hasNext()) {
                    JoinRsp join_rsp;
                    Address mbr = (Address)it.next();
                    if (!this.gms.members.contains(mbr)) continue;
                    if (this.gms.reject_join_from_existing_member) {
                        join_rsp = new JoinRsp("member " + mbr + " is already part of the group, JOIN request is rejected");
                    } else {
                        if (this.log.isWarnEnabled()) {
                            this.log.warn((Object)(mbr + " already present; returning existing view " + this.gms.view));
                        }
                        join_rsp = new JoinRsp(new View(this.gms.view_id, this.gms.members.getMembers()), this.gms.getDigest());
                    }
                    this.gms.sendJoinResponse(join_rsp, mbr);
                    it.remove();
                }
                if (new_mbrs.isEmpty() && leaving_mbrs.isEmpty() && suspected_mbrs.isEmpty()) {
                    if (!this.log.isTraceEnabled()) return;
                    this.log.trace((Object)"found no members to add or remove, will not create new view");
                    return;
                }
                View new_view = this.gms.getNextView(new_mbrs, leaving_mbrs, suspected_mbrs);
                this.gms.up(new Event(86, new_view));
                this.gms.down(new Event(86, new_view));
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("new=" + new_mbrs + ", suspected=" + suspected_mbrs + ", leaving=" + leaving_mbrs + ", new view: " + new_view));
                }
                JoinRsp join_rsp = null;
                hasJoiningMembers = !new_mbrs.isEmpty();
                try {
                    boolean successfulFlush = this.gms.startFlush(new_view);
                    if (!successfulFlush && hasJoiningMembers) {
                        this.sendLeaveResponses(leaving_mbrs);
                        Object var16_12 = null;
                        if (hasJoiningMembers) {
                            this.gms.getDownProtocol().down(new Event(66));
                        }
                        break block29;
                    }
                    if (hasJoiningMembers) {
                        this.gms.getDownProtocol().down(new Event(65, this.MAX_SUSPEND_TIMEOUT));
                        Digest tmp = this.gms.getDigest();
                        MutableDigest join_digest = null;
                        if (tmp == null) {
                            this.log.error((Object)"received null digest from GET_DIGEST: will cause JOIN to fail");
                        } else {
                            join_digest = new MutableDigest(tmp.size() + new_mbrs.size());
                            join_digest.add(tmp);
                            for (Address member : new_mbrs) {
                                join_digest.add(member, 0L, 0L);
                            }
                        }
                        join_rsp = new JoinRsp(new_view, join_digest != null ? join_digest.copy() : null);
                    }
                    this.sendLeaveResponses(leaving_mbrs);
                    this.gms.castViewChangeWithDest(new_view, null, join_rsp, new_mbrs);
                    break block30;
                }
                catch (Throwable throwable) {
                    Object var16_14 = null;
                    if (hasJoiningMembers) {
                        this.gms.getDownProtocol().down(new Event(66));
                    }
                    if (!joinAndStateTransferInitiated) {
                        this.gms.stopFlush();
                    }
                    if (!this.leaving) throw throwable;
                    this.gms.initState();
                    throw throwable;
                }
            }
            if (!joinAndStateTransferInitiated) {
                this.gms.stopFlush();
            }
            if (!this.leaving) return;
            this.gms.initState();
            return;
        }
        Object var16_13 = null;
        if (hasJoiningMembers) {
            this.gms.getDownProtocol().down(new Event(66));
        }
        if (!joinAndStateTransferInitiated) {
            this.gms.stopFlush();
        }
        if (!this.leaving) return;
        this.gms.initState();
    }

    @Override
    public void handleViewChange(View new_view, Digest digest) {
        Vector<Address> mbrs = new_view.getMembers();
        if (this.log.isDebugEnabled()) {
            if (digest != null) {
                this.log.debug((Object)("view=" + new_view + ", digest=" + digest));
            } else {
                this.log.debug((Object)("view=" + new_view));
            }
        }
        if (this.leaving && !mbrs.contains(this.gms.local_addr)) {
            return;
        }
        this.gms.installView(new_view, digest);
    }

    @Override
    public void handleExit() {
        this.cancelMerge();
    }

    @Override
    public void stop() {
        super.stop();
        this.stopMergeTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startMergeTask(Vector<Address> coords) {
        MergeTask mergeTask = this.merge_task;
        synchronized (mergeTask) {
            this.merge_task.start(coords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopMergeTask() {
        MergeTask mergeTask = this.merge_task;
        synchronized (mergeTask) {
            this.merge_task.stop();
        }
    }

    private void sendLeaveResponses(Collection<Address> leaving_members) {
        for (Address address : leaving_members) {
            Message msg = new Message(address, null, null);
            msg.setFlag((byte)1);
            GMS.GmsHeader hdr = new GMS.GmsHeader(4);
            msg.putHeader(this.gms.getName(), hdr);
            this.gms.getDownProtocol().down(new Event(1, msg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getMergeDataFromSubgroupCoordinators(Vector<Address> coords, long timeout) {
        boolean gotAllResponses = false;
        long start = System.currentTimeMillis();
        Vector<MergeData> vector = this.merge_rsps;
        synchronized (vector) {
            this.merge_rsps.removeAllElements();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Merge leader " + this.gms.local_addr + " sending MERGE_REQ to " + coords));
            }
            for (Address coord : coords) {
                Message msg = new Message(coord, null, null);
                msg.setFlag((byte)1);
                GMS.GmsHeader hdr = new GMS.GmsHeader(6);
                hdr.mbr = this.gms.local_addr;
                hdr.merge_id = this.merge_id;
                msg.putHeader(this.gms.getName(), hdr);
                this.gms.getDownProtocol().down(new Event(1, msg));
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Merge leader " + this.gms.local_addr + " sent MERGE_REQ to " + coord));
            }
            int num_rsps_expected = coords.size();
            long curr_time = System.currentTimeMillis();
            long end_time = curr_time + timeout;
            while (end_time > curr_time && !gotAllResponses) {
                long time_to_wait = end_time - curr_time;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Merge leader " + this.gms.local_addr + " waiting " + time_to_wait + " msecs for merge responses"));
                }
                if (this.merge_rsps.size() < num_rsps_expected) {
                    try {
                        this.merge_rsps.wait(500L);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Merge leader " + this.gms.local_addr + " expects " + num_rsps_expected + " responses, so far got " + this.merge_rsps.size() + " responses"));
                }
                gotAllResponses = this.merge_rsps.size() >= num_rsps_expected;
                curr_time = System.currentTimeMillis();
            }
            long stop = System.currentTimeMillis();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Merge leader " + this.gms.local_addr + " collected " + this.merge_rsps.size() + " merge response(s) in " + (stop - start) + " ms"));
            }
        }
        return gotAllResponses;
    }

    private ViewId generateMergeId() {
        return new ViewId(this.gms.local_addr, System.currentTimeMillis());
    }

    private MergeData consolidateMergeData(Vector<MergeData> merge_rsps) {
        Digest new_digest;
        Address new_coord;
        long logical_time = 0L;
        Membership new_mbrs = new Membership();
        Vector<View> subgroups = new Vector<View>(11);
        for (MergeData tmp_data : merge_rsps) {
            View tmp_view;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Merge leader " + this.gms.local_addr + " is consolidating merge data " + tmp_data));
            }
            if ((tmp_view = tmp_data.getView()) == null) continue;
            ViewId tmp_vid = tmp_view.getVid();
            if (tmp_vid != null) {
                logical_time = Math.max(logical_time, tmp_vid.getId());
            }
            new_mbrs.add(tmp_view.getMembers());
            subgroups.addElement((View)tmp_view.clone());
        }
        new_mbrs.sort();
        Address address = new_coord = new_mbrs.size() > 0 ? new_mbrs.elementAt(0) : null;
        if (new_coord == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"new_coord == null");
            }
            return null;
        }
        ViewId new_vid = new ViewId(new_coord, logical_time + 1L);
        MergeView new_view = new MergeView(new_vid, new_mbrs.getMembers(), subgroups);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Merge leader " + this.gms.local_addr + " computed new merged view that will be " + new_view));
        }
        if ((new_digest = this.consolidateDigests(merge_rsps, new_mbrs.size())) == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Merge leader " + this.gms.local_addr + "could not consolidate digest for merge"));
            }
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Merge leader " + this.gms.local_addr + "consolidated digest=" + new_digest));
        }
        MergeData ret = new MergeData(this.gms.local_addr, new_view, new_digest);
        return ret;
    }

    private Digest consolidateDigests(Vector<MergeData> merge_rsps, int num_mbrs) {
        MutableDigest retval = new MutableDigest(num_mbrs);
        for (MergeData data : merge_rsps) {
            Digest tmp_digest = data.getDigest();
            if (tmp_digest == null) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)"tmp_digest == null; skipping");
                continue;
            }
            retval.merge(tmp_digest);
        }
        return retval.copy();
    }

    private void sendMergeView(Vector<Address> coords, MergeData combined_merge_data) {
        if (coords == null || combined_merge_data == null) {
            return;
        }
        View v = combined_merge_data.view;
        Digest d = combined_merge_data.digest;
        if (v == null || d == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"view or digest is null, cannot send consolidated merge view/digest");
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.gms.local_addr + " is sending merge view " + v.getVid() + " to coordinators " + coords));
        }
        this.gms.merge_ack_collector.reset(coords);
        int size = this.gms.merge_ack_collector.size();
        long timeout = this.gms.view_ack_collection_timeout;
        long start = System.currentTimeMillis();
        for (Address coord : coords) {
            Message msg = new Message(coord, null, null);
            GMS.GmsHeader hdr = new GMS.GmsHeader(8);
            hdr.view = v;
            hdr.my_digest = d;
            hdr.merge_id = this.merge_id;
            msg.putHeader(this.gms.getName(), hdr);
            this.gms.getDownProtocol().down(new Event(1, msg));
        }
        if (this.gms.flushProtocolInStack) {
            try {
                this.gms.merge_ack_collector.waitForAllAcks(timeout);
                long stop = System.currentTimeMillis();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("received all ACKs (" + size + ") for merged view " + v + " in " + (stop - start) + "ms"));
                }
            }
            catch (TimeoutException e) {
                this.log.warn((Object)("Merge coordinator " + this.gms.local_addr + " failed to collect all ACKs for merge (" + size + ") for view " + v + " after " + timeout + "ms, missing ACKs from " + this.gms.merge_ack_collector.printMissing() + ", local_addr=" + this.gms.local_addr));
            }
        }
    }

    private void sendMergeResponse(Address sender, View view, Digest digest) {
        Message msg = new Message(sender, null, null);
        msg.setFlag((byte)1);
        GMS.GmsHeader hdr = new GMS.GmsHeader(7);
        hdr.merge_id = this.merge_id;
        hdr.view = view;
        hdr.my_digest = digest;
        msg.putHeader(this.gms.getName(), hdr);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("response=" + hdr));
        }
        this.gms.getDownProtocol().down(new Event(1, msg));
    }

    private void sendMergeCancelledMessage(Vector<Address> coords, ViewId merge_id) {
        if (coords == null || merge_id == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"coords or merge_id == null");
            }
            return;
        }
        for (Address coord : coords) {
            Message msg = new Message(coord, null, null);
            GMS.GmsHeader hdr = new GMS.GmsHeader(9);
            hdr.merge_id = merge_id;
            msg.putHeader(this.gms.getName(), hdr);
            this.gms.getDownProtocol().down(new Event(1, msg));
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Merge leader " + this.gms.local_addr + " send cancel merge to " + coord));
        }
    }

    private void removeRejectedMergeRequests(Vector<Address> coords) {
        Iterator<MergeData> it = this.merge_rsps.iterator();
        while (it.hasNext()) {
            MergeData data = it.next();
            if (!data.merge_rejected) continue;
            if (data.getSender() != null && coords != null) {
                coords.removeElement(data.getSender());
            }
            it.remove();
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("removed element " + data));
        }
    }

    private class MergeCanceller
    implements Runnable {
        private Object my_merge_id = null;
        private long timeout;

        MergeCanceller(Object my_merge_id, long timeout) {
            this.my_merge_id = my_merge_id;
            this.timeout = timeout;
        }

        public void run() {
            if (CoordGmsImpl.this.merge_id != null && this.my_merge_id.equals(CoordGmsImpl.this.merge_id)) {
                if (CoordGmsImpl.this.log.isDebugEnabled()) {
                    CoordGmsImpl.this.log.debug((Object)("At " + CoordGmsImpl.this.gms.local_addr + " cancelling merge due to timer timeout (" + this.timeout + " ms)"));
                }
                CoordGmsImpl.this.cancelMerge();
            } else if (CoordGmsImpl.this.log.isWarnEnabled()) {
                CoordGmsImpl.this.log.warn((Object)("At " + CoordGmsImpl.this.gms.local_addr + " timer kicked in after " + this.timeout + " ms, but no (or different) merge was in progress: " + "merge_id=" + CoordGmsImpl.this.merge_id + ", my_merge_id=" + this.my_merge_id));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MergeTask
    implements Runnable {
        Thread t = null;
        Vector<Address> coords = null;

        private MergeTask() {
        }

        public void start(Vector<Address> groupCoord) {
            Vector<Address> vector = this.coords = groupCoord != null ? new Vector<Address>(groupCoord) : null;
            if (!this.isRunning()) {
                this.t = CoordGmsImpl.this.gms.getThreadFactory().newThread(this, "MergeTask");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        public void stop() {
            Thread tmp = this.t;
            if (this.isRunning()) {
                this.t = null;
                tmp.interrupt();
            }
            this.t = null;
        }

        public boolean isRunning() {
            return this.t != null && this.t.isAlive();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (CoordGmsImpl.this.merging) {
                if (!CoordGmsImpl.this.log.isWarnEnabled()) return;
                CoordGmsImpl.this.log.warn((Object)(CoordGmsImpl.this.gms.local_addr + " running merge task, but merge is is already in progress, terminating"));
                return;
            }
            if (this.coords == null || this.coords.size() <= 1) {
                if (!CoordGmsImpl.this.log.isErrorEnabled()) return;
                CoordGmsImpl.this.log.error((Object)"coords == null or size <= 1");
                return;
            }
            if (CoordGmsImpl.this.log.isDebugEnabled()) {
                CoordGmsImpl.this.log.debug((Object)(CoordGmsImpl.this.gms.local_addr + " running merge task, coordinators are " + this.coords));
            }
            Vector<Address> coordsCopy = new Vector<Address>(this.coords);
            ViewId generatedMergeId = CoordGmsImpl.this.generateMergeId();
            try {
                try {
                    CoordGmsImpl.this.setMergeId(generatedMergeId);
                    boolean success = CoordGmsImpl.this.getMergeDataFromSubgroupCoordinators(this.coords, CoordGmsImpl.this.gms.merge_timeout);
                    if (!success) {
                        throw new Exception("Merge aborted. Merge leader did not get MergeData from all subgroup coordinators " + this.coords);
                    }
                    MergeData combined_merge_data = null;
                    Vector vector = CoordGmsImpl.this.merge_rsps;
                    synchronized (vector) {
                        CoordGmsImpl.this.removeRejectedMergeRequests(this.coords);
                        if (CoordGmsImpl.this.merge_rsps.size() <= 1) {
                            throw new Exception("Merge leader " + CoordGmsImpl.this.gms.local_addr + " did not get all merge responses from subgroup coordinators  (" + CoordGmsImpl.this.merge_rsps + ")");
                        }
                        combined_merge_data = CoordGmsImpl.this.consolidateMergeData(CoordGmsImpl.this.merge_rsps);
                        if (combined_merge_data == null) {
                            throw new Exception("Merge leader " + CoordGmsImpl.this.gms.local_addr + " could not consolidate merge");
                        }
                    }
                    CoordGmsImpl.this.sendMergeView(this.coords, combined_merge_data);
                }
                catch (Throwable ex) {
                    if (CoordGmsImpl.this.log.isWarnEnabled()) {
                        CoordGmsImpl.this.log.warn((Object)ex.getLocalizedMessage());
                    }
                    CoordGmsImpl.this.sendMergeCancelledMessage(coordsCopy, generatedMergeId);
                    Object var8_8 = null;
                    CoordGmsImpl.this.gms.getViewHandler().resume(generatedMergeId);
                    CoordGmsImpl.this.stopMergeCanceller();
                    CoordGmsImpl.this.gms.stopFlush();
                    CoordGmsImpl.this.merging = false;
                    if (CoordGmsImpl.this.log.isDebugEnabled()) {
                        CoordGmsImpl.this.log.debug((Object)("Merge leader " + CoordGmsImpl.this.gms.local_addr + " completed merge task"));
                    }
                    this.t = null;
                    return;
                }
                Object var8_7 = null;
                CoordGmsImpl.this.gms.getViewHandler().resume(generatedMergeId);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                CoordGmsImpl.this.gms.getViewHandler().resume(generatedMergeId);
                CoordGmsImpl.this.stopMergeCanceller();
                CoordGmsImpl.this.gms.stopFlush();
                CoordGmsImpl.this.merging = false;
                if (CoordGmsImpl.this.log.isDebugEnabled()) {
                    CoordGmsImpl.this.log.debug((Object)("Merge leader " + CoordGmsImpl.this.gms.local_addr + " completed merge task"));
                }
                this.t = null;
                throw throwable;
            }
            CoordGmsImpl.this.stopMergeCanceller();
            CoordGmsImpl.this.gms.stopFlush();
            CoordGmsImpl.this.merging = false;
            if (CoordGmsImpl.this.log.isDebugEnabled()) {
                CoordGmsImpl.this.log.debug((Object)("Merge leader " + CoordGmsImpl.this.gms.local_addr + " completed merge task"));
            }
            this.t = null;
        }
    }
}

