/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import org.hibernate.Hibernate;
import org.hibernate.type.SerializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SerializationHelper {
    private static final Logger log = LoggerFactory.getLogger(SerializationHelper.class);

    private SerializationHelper() {
    }

    public static Object clone(Serializable object) throws SerializationException {
        log.trace("Starting clone through serialization");
        if (object == null) {
            return null;
        }
        return SerializationHelper.deserialize(SerializationHelper.serialize(object), object.getClass().getClassLoader());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void serialize(Serializable obj, OutputStream outputStream) throws SerializationException {
        if (outputStream == null) {
            throw new IllegalArgumentException("The OutputStream must not be null");
        }
        if (log.isTraceEnabled()) {
            if (Hibernate.isInitialized(obj)) {
                log.trace("Starting serialization of object [" + obj + "]");
            } else {
                log.trace("Starting serialization of [uninitialized proxy]");
            }
        }
        ObjectOutputStream out = null;
        try {
            try {
                out = new ObjectOutputStream(outputStream);
                out.writeObject(obj);
            }
            catch (IOException ex) {
                throw new SerializationException("could not serialize", ex);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignored) {}
        if (out == null) return;
        out.close();
        return;
    }

    public static byte[] serialize(Serializable obj) throws SerializationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        SerializationHelper.serialize(obj, baos);
        return baos.toByteArray();
    }

    public static Object deserialize(InputStream inputStream) throws SerializationException {
        return SerializationHelper.deserialize(inputStream, Thread.currentThread().getContextClassLoader());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object deserialize(InputStream inputStream, ClassLoader loader) throws SerializationException {
        if (inputStream == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        log.trace("Starting deserialization of object");
        try {
            Object object;
            CustomObjectInputStream in = new CustomObjectInputStream(inputStream, loader);
            try {
                try {
                    object = in.readObject();
                    Object var5_7 = null;
                }
                catch (ClassNotFoundException e) {
                    throw new SerializationException("could not deserialize", e);
                }
                catch (IOException e) {
                    throw new SerializationException("could not deserialize", e);
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ignore) {
                // empty catch block
                return object;
            }
            in.close();
            return object;
        }
        catch (IOException e) {
            throw new SerializationException("could not deserialize", e);
        }
    }

    public static Object deserialize(byte[] objectData) throws SerializationException {
        return SerializationHelper.deserialize(objectData, Thread.currentThread().getContextClassLoader());
    }

    public static Object deserialize(byte[] objectData, ClassLoader loader) throws SerializationException {
        if (objectData == null) {
            throw new IllegalArgumentException("The byte[] must not be null");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(objectData);
        return SerializationHelper.deserialize(bais, loader);
    }

    private static final class CustomObjectInputStream
    extends ObjectInputStream {
        private final ClassLoader loader;

        private CustomObjectInputStream(InputStream in, ClassLoader loader) throws IOException {
            super(in);
            this.loader = loader;
        }

        protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            String className = v.getName();
            log.trace("Attempting to locate class [" + className + "]");
            if (this.loader != null) {
                try {
                    return Class.forName(className, false, this.loader);
                }
                catch (ClassNotFoundException e) {
                    log.trace("Unable to locate class using given classloader");
                }
            }
            return super.resolveClass(v);
        }
    }
}

