/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.management.recording;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.namespace.QName;
import org.jboss.wsf.framework.management.recording.AbstractRecordProcessor;
import org.jboss.wsf.framework.management.recording.HostFilter;
import org.jboss.wsf.framework.management.recording.MemoryBufferRecorderMBean;
import org.jboss.wsf.framework.management.recording.OperationFilter;
import org.jboss.wsf.spi.management.recording.Record;
import org.jboss.wsf.spi.management.recording.RecordFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryBufferRecorder
extends AbstractRecordProcessor
implements MemoryBufferRecorderMBean,
Serializable {
    private static final long serialVersionUID = 5180978625780333738L;
    private Map<String, List<Record>> recentRecords = Collections.synchronizedMap(new HashMap());
    private ConcurrentLinkedQueue<String> recentRecordGroups = new ConcurrentLinkedQueue();
    private int size = 0;
    private int maxSize = 50;

    public MemoryBufferRecorder() {
        this.name = "MemoryBufferRecorder";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRecord(Record record) {
        Map<String, List<Record>> map = this.recentRecords;
        synchronized (map) {
            List<Record> list = this.recentRecords.get(record.getGroupID());
            if (list == null) {
                list = new LinkedList<Record>();
                this.recentRecords.put(record.getGroupID(), list);
                while (this.size > this.maxSize) {
                    this.deleteOldestRecord();
                }
                this.recentRecordGroups.offer(record.getGroupID());
                ++this.size;
            }
            list.add(record);
        }
    }

    private void deleteOldestRecord() {
        String id = this.recentRecordGroups.poll();
        if (id != null) {
            this.recentRecords.remove(id);
            --this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<Record>> getRecentRecords() {
        Map<String, List<Record>> map = this.recentRecords;
        synchronized (map) {
            return new HashMap<String, List<Record>>(this.recentRecords);
        }
    }

    @Override
    public Set<String> getClientHosts() {
        Map<String, List<Record>> map = this.getRecentRecords();
        HashSet<String> hosts = new HashSet<String>();
        for (List<Record> list : map.values()) {
            for (Record record : list) {
                if (!Record.MessageType.INBOUND.equals((Object)record.getMessageType()) || record.getSourceHost() == null) continue;
                hosts.add(record.getSourceHost());
            }
        }
        return hosts;
    }

    @Override
    public Map<String, List<Record>> getMatchingRecords(RecordFilter[] filters) {
        Map<String, List<Record>> map = this.getRecentRecords();
        HashMap<String, List<Record>> result = new HashMap<String, List<Record>>();
        block0: for (List<Record> list : map.values()) {
            for (Record record : list) {
                boolean match = true;
                for (int i = 0; i < filters.length && match; ++i) {
                    match = match && filters[i].match(record);
                }
                if (!match) continue;
                result.put(record.getGroupID(), list);
                continue block0;
            }
        }
        return result;
    }

    @Override
    public Map<String, List<Record>> getRecordsByClientHost(String clientHost) {
        RecordFilter[] filters = new RecordFilter[]{new HostFilter(clientHost, true)};
        return this.getMatchingRecords(filters);
    }

    @Override
    public String getRecordsByClientHostAsHTMLTable(boolean groupRecords, boolean showDetails, String clientHost) {
        return this.toHtml(groupRecords, showDetails, this.getRecordsByClientHost(clientHost));
    }

    @Override
    public Map<String, List<Record>> getRecordsByOperation(String namespace, String localPart) {
        RecordFilter[] filters = new RecordFilter[]{new OperationFilter(new QName(namespace, localPart))};
        return this.getMatchingRecords(filters);
    }

    @Override
    public String getRecordsByOperationAsHTMLTable(boolean groupRecords, boolean showDetails, String namespace, String localPart) {
        return this.toHtml(groupRecords, showDetails, this.getRecordsByOperation(namespace, localPart));
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxSize(int maxSize) {
        Map<String, List<Record>> map = this.recentRecords;
        synchronized (map) {
            while (maxSize < this.size) {
                this.deleteOldestRecord();
            }
            this.maxSize = maxSize;
        }
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public String getRecordsAsHTMLTable(boolean groupRecords, boolean showDetails) {
        Map<String, List<Record>> records = this.getRecentRecords();
        return this.toHtml(groupRecords, showDetails, records);
    }

    private String toHtml(boolean groupRecords, boolean showDetails, Map<String, List<Record>> records) {
        StringBuffer sb = new StringBuffer();
        sb.append("</pre></span>");
        if (!groupRecords) {
            this.openTable(sb, showDetails);
        }
        for (String key : records.keySet()) {
            if (groupRecords) {
                this.openTable(sb, showDetails);
            }
            for (Record record : records.get(key)) {
                this.appendRecordRow(sb, record, showDetails);
            }
            if (!groupRecords) continue;
            this.closeTable(sb);
        }
        if (!groupRecords) {
            this.closeTable(sb);
        }
        sb.append("<pre><span class='OpResult'>");
        return sb.toString();
    }

    private void openTable(StringBuffer sb, boolean showDetails) {
        sb.append("<table border='1'><tr class='AttributesHeader'><th>Group ID</th><th>Type</th><th>Date</th><th>From</th><th>To</th><th>Operation</th>");
        if (showDetails) {
            sb.append("<th>Headers</th><th>Envelope</th>");
        }
        sb.append("</tr><tr>");
    }

    private void closeTable(StringBuffer sb) {
        sb.append("</tr></table><br />");
    }

    private void appendRecordRow(StringBuffer sb, Record record, boolean showDetails) {
        sb.append("<tr><td><pre>");
        sb.append(record.getGroupID() != null ? record.getGroupID() : "[Not available]");
        sb.append("</pre></td>");
        sb.append("<td><pre>");
        sb.append(record.getMessageType() != null ? record.getMessageType() : "[Not available]");
        sb.append("</pre></td>");
        sb.append("<td><pre>");
        sb.append(record.getDate() != null ? record.getDate() : "[Not available]");
        sb.append("</pre></td>");
        sb.append("<td><pre>");
        sb.append(record.getSourceHost() != null ? record.getSourceHost() : "[Not available]");
        sb.append("</pre></td>");
        sb.append("<td><pre>");
        sb.append(record.getDestinationHost() != null ? record.getDestinationHost() : "[Not available]");
        sb.append("</pre></td>");
        sb.append("<td><pre>");
        sb.append(record.getOperation() != null ? record.getOperation() : "[Not available]");
        sb.append("</pre></td>");
        if (showDetails) {
            sb.append("<td><pre>");
            if (record.getHeaders() != null) {
                for (String headerName : record.getHeaders().keySet()) {
                    sb.append(headerName);
                    sb.append(": ");
                    sb.append(record.getHeaders().get(headerName));
                    sb.append("<br />");
                }
            } else {
                sb.append("[Not available]");
            }
            sb.append("</pre></td>");
            sb.append("<td><pre>");
            sb.append(record.getEnvelope() != null ? record.getEnvelope().replaceAll("<", "&lt;").replaceAll(">", "&gt;") : "[Not available]");
            sb.append("</pre></td>");
        }
        sb.append("</tr>");
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MemoryBufferRecorder cl = (MemoryBufferRecorder)super.clone();
        cl.recentRecords = Collections.synchronizedMap(new HashMap());
        for (String key : this.recentRecords.keySet()) {
            LinkedList<Record> list = new LinkedList<Record>();
            for (Record record : this.recentRecords.get(key)) {
                list.add(record);
            }
            cl.recentRecords.put(key, list);
        }
        cl.recentRecordGroups = new ConcurrentLinkedQueue();
        for (String id : this.recentRecordGroups) {
            cl.recentRecordGroups.add(id);
        }
        cl.maxSize = this.maxSize;
        cl.size = this.size;
        return cl;
    }
}

