/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.dbi.EnvironmentImpl;
import java.util.zip.Checksum;

public class Adler32
implements Checksum {
    private long adler = 1L;
    private static final int BASE = 65521;
    private static final int NMAX = 5552;

    public static Checksum makeChecksum() {
        if (EnvironmentImpl.JAVA5_AVAILABLE) {
            return new java.util.zip.Adler32();
        }
        return new Adler32();
    }

    public void update(int b) {
        long s1 = this.adler & 0xFFFFL;
        long s2 = this.adler >> 16 & 0xFFFFL;
        s1 = (s1 + (long)(b & 0xFF)) % 65521L;
        s2 = (s1 + s2) % 65521L;
        this.adler = s2 << 16 | s1;
    }

    public void update(byte[] b, int off, int len) {
        long s1 = this.adler & 0xFFFFL;
        long s2 = this.adler >> 16 & 0xFFFFL;
        while (len > 0) {
            int k = len < 5552 ? len : 5552;
            len -= k;
            while (k-- > 0) {
                s2 += (s1 += (long)(b[off++] & 0xFF));
            }
            s1 %= 65521L;
            s2 %= 65521L;
        }
        this.adler = s2 << 16 | s1;
    }

    public void reset() {
        this.adler = 1L;
    }

    public long getValue() {
        return this.adler;
    }
}

