/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.classloader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaDataFactory;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.classloading.spi.metadata.RequirementsMetaData;
import org.jboss.classloading.spi.metadata.helpers.AbstractRequirement;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.deployer.AbstractOptionalVFSRealDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RequirementIntegrationDeployer<T>
extends AbstractOptionalVFSRealDeployer<T> {
    private Set<String> integrationModuleNames;

    public RequirementIntegrationDeployer(Class<T> input) {
        super(input);
        this.setStage(DeploymentStages.DESCRIBE);
        this.addInput(ClassLoadingMetaData.class);
        this.setOutput(ClassLoadingMetaData.class);
    }

    public String getIntegrationModuleName() {
        if (this.integrationModuleNames == null || this.integrationModuleNames.isEmpty()) {
            return null;
        }
        if (this.integrationModuleNames.size() == 1) {
            return this.integrationModuleNames.iterator().next();
        }
        throw new IllegalArgumentException("Multiple integration module names: " + this.integrationModuleNames);
    }

    public void setIntegrationModuleName(String integrationModuleName) {
        this.integrationModuleNames = Collections.singleton(integrationModuleName);
    }

    public Set<String> getIntegrationModuleNames() {
        return this.integrationModuleNames;
    }

    public void setIntegrationModuleNames(Set<String> integrationModuleNames) {
        this.integrationModuleNames = integrationModuleNames;
    }

    public void start() {
        if (this.integrationModuleNames == null || this.integrationModuleNames.isEmpty()) {
            throw new IllegalArgumentException("No integration module names.");
        }
    }

    public void deploy(VFSDeploymentUnit unit, T metaData) throws DeploymentException {
        ClassLoadingMetaData clmd = (ClassLoadingMetaData)unit.getAttachment(ClassLoadingMetaData.class);
        if (clmd == null) {
            this.log.warn((Object)("Missing ClassLoadingMetaData: " + unit));
            return;
        }
        RequirementsMetaData requirements = clmd.getRequirements();
        AbstractRequirement integrationModule = this.hasIntegrationModuleRequirement(unit, requirements);
        if (integrationModule != null) {
            ClassLoadingMetaDataFactory factory = ClassLoadingMetaDataFactory.getInstance();
            ArrayList<AbstractRequirement> added = new ArrayList<AbstractRequirement>();
            try {
                for (String integrationModuleName : this.integrationModuleNames) {
                    Requirement integrationRequirement = factory.createRequireModule(integrationModuleName, integrationModule.getVersionRange());
                    requirements.addRequirement(integrationRequirement);
                    added.add(integrationModule);
                }
            }
            catch (Throwable t) {
                for (int i = added.size() - 1; i >= 0; --i) {
                    requirements.removeRequirement((Requirement)added.get(i));
                }
                throw DeploymentException.rethrowAsDeploymentException((String)"Error adding integration requirement.", (Throwable)t);
            }
        }
    }

    public void undeploy(VFSDeploymentUnit unit, T deployment) {
        RequirementsMetaData requirements;
        AbstractRequirement integrationModule;
        ClassLoadingMetaData clmd = (ClassLoadingMetaData)unit.getAttachment(ClassLoadingMetaData.class);
        if (clmd != null && (integrationModule = this.hasIntegrationModuleRequirement(unit, requirements = clmd.getRequirements())) != null) {
            ClassLoadingMetaDataFactory factory = ClassLoadingMetaDataFactory.getInstance();
            for (String integrationModuleName : this.integrationModuleNames) {
                try {
                    Requirement integrationRequirement = factory.createRequireModule(integrationModuleName, integrationModule.getVersionRange());
                    requirements.removeRequirement(integrationRequirement);
                }
                catch (Throwable t) {
                    this.log.warn((Object)("Error during requirement removal: " + integrationModuleName), t);
                }
            }
        }
    }

    protected AbstractRequirement hasIntegrationModuleRequirement(VFSDeploymentUnit unit, RequirementsMetaData requirements) {
        return this.hasIntegrationModuleRequirement(requirements);
    }

    protected abstract AbstractRequirement hasIntegrationModuleRequirement(RequirementsMetaData var1);
}

