/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.async;

import java.lang.annotation.Annotation;
import java.util.Date;
import org.jboss.seam.Component;
import org.jboss.seam.annotations.async.Duration;
import org.jboss.seam.annotations.async.Expiration;
import org.jboss.seam.annotations.async.FinalExpiration;
import org.jboss.seam.annotations.async.IntervalCron;
import org.jboss.seam.annotations.async.IntervalDuration;
import org.jboss.seam.async.CronSchedule;
import org.jboss.seam.async.Dispatcher;
import org.jboss.seam.async.QuartzDispatcher;
import org.jboss.seam.async.Schedule;
import org.jboss.seam.async.TimerSchedule;
import org.jboss.seam.async.TransactionCompletionEvent;
import org.jboss.seam.async.TransactionSuccessEvent;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.transaction.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDispatcher<T, S extends Schedule>
implements Dispatcher<T, S> {
    public static final String EXECUTING_ASYNCHRONOUS_CALL = "org.jboss.seam.core.executingAsynchronousCall";

    public static Dispatcher instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("no application context active");
        }
        return (Dispatcher)Component.getInstance("org.jboss.seam.async.dispatcher");
    }

    @Override
    public void scheduleTransactionSuccessEvent(String type, Object ... parameters) {
        Transaction.instance().registerSynchronization(new TransactionSuccessEvent(type, parameters));
    }

    @Override
    public void scheduleTransactionCompletionEvent(String type, Object ... parameters) {
        Transaction.instance().registerSynchronization(new TransactionCompletionEvent(type, parameters));
    }

    protected Schedule createSchedule(InvocationContext invocation) {
        DispatcherParameters dispatcherParameters = this.extractAndValidateParameters(invocation);
        if (dispatcherParameters.getIntervalCron() == null) {
            return new TimerSchedule(dispatcherParameters.getDuration(), dispatcherParameters.getExpiration(), dispatcherParameters.getIntervalDuration(), dispatcherParameters.getFinalExpiration());
        }
        return new CronSchedule(dispatcherParameters.getDuration(), dispatcherParameters.getExpiration(), dispatcherParameters.getIntervalCron(), dispatcherParameters.getFinalExpiration());
    }

    protected TimerSchedule createTimerSchedule(InvocationContext invocation) {
        DispatcherParameters dispatcherParameters = this.extractAndValidateParameters(invocation);
        return this.createTimerSchedule(dispatcherParameters);
    }

    private TimerSchedule createTimerSchedule(DispatcherParameters dispatcherParameters) {
        return new TimerSchedule(dispatcherParameters.getDuration(), dispatcherParameters.getExpiration(), dispatcherParameters.getIntervalDuration(), dispatcherParameters.getFinalExpiration());
    }

    protected DispatcherParameters extractAndValidateParameters(InvocationContext invocation) {
        DispatcherParameters dispatcherParameters = new DispatcherParameters();
        for (int i = 0; i < invocation.getMethod().getParameterAnnotations().length; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = invocation.getMethod().getParameterAnnotations()[i]) {
                if (annotation.annotationType().equals(Duration.class)) {
                    if (invocation.getParameters()[i] instanceof Long) {
                        dispatcherParameters.setDuration((Long)invocation.getParameters()[i]);
                        continue;
                    }
                    if (invocation.getParameters()[i] == null) continue;
                    throw new IllegalArgumentException("@Duration on " + invocation.getTarget().getClass() + ":" + invocation.getMethod().getName() + " must be a Long");
                }
                if (annotation.annotationType().equals(Expiration.class)) {
                    if (invocation.getParameters()[i] instanceof Date) {
                        dispatcherParameters.setExpiration((Date)invocation.getParameters()[i]);
                        continue;
                    }
                    if (invocation.getParameters()[i] == null) continue;
                    throw new IllegalArgumentException("@Expiration on " + invocation.getTarget().getClass() + ":" + invocation.getMethod().getName() + " must be a java.util.Date");
                }
                if (annotation.annotationType().equals(FinalExpiration.class)) {
                    if (!(this instanceof QuartzDispatcher)) {
                        throw new IllegalArgumentException("Can only use @FinalExpiration with the QuartzDispatcher");
                    }
                    if (invocation.getParameters()[i] instanceof Date) {
                        dispatcherParameters.setFinalExpiration((Date)invocation.getParameters()[i]);
                        continue;
                    }
                    if (invocation.getParameters()[i] == null) continue;
                    throw new IllegalArgumentException("@FinalExpiration on " + invocation.getTarget().getClass() + ":" + invocation.getMethod().getName() + " must be a java.util.Date");
                }
                if (annotation.annotationType().equals(IntervalCron.class)) {
                    if (!(this instanceof QuartzDispatcher)) {
                        throw new IllegalArgumentException("Can only use @IntervalCron with the QuartzDispatcher");
                    }
                    if (invocation.getParameters()[i] instanceof String) {
                        dispatcherParameters.setIntervalCron((String)invocation.getParameters()[i]);
                        continue;
                    }
                    if (invocation.getParameters()[i] == null) continue;
                    throw new IllegalArgumentException("@IntervalCron on " + invocation.getTarget().getClass() + ":" + invocation.getMethod().getName() + " must be a String");
                }
                if (!annotation.annotationType().equals(IntervalDuration.class)) continue;
                if (invocation.getParameters()[i] instanceof Long) {
                    dispatcherParameters.setIntervalDuration((Long)invocation.getParameters()[i]);
                    continue;
                }
                if (invocation.getParameters()[i] == null) continue;
                throw new IllegalArgumentException("@IntervalDuration on " + invocation.getTarget().getClass() + ":" + invocation.getMethod().getName() + " must be a Long");
            }
        }
        if (dispatcherParameters.getIntervalCron() != null && dispatcherParameters.getIntervalDuration() != null) {
            throw new IllegalArgumentException("Can only use one of @IntervalCron and @IntervalDuration");
        }
        return dispatcherParameters;
    }

    public class DispatcherParameters {
        private Date expiration;
        private Date finalExpiration;
        private Long duration;
        private Long intervalDuration;
        private String intervalCron;

        public String getIntervalCron() {
            return this.intervalCron;
        }

        public Long getDuration() {
            return this.duration;
        }

        public Date getExpiration() {
            return this.expiration;
        }

        public Date getFinalExpiration() {
            return this.finalExpiration;
        }

        public Long getIntervalDuration() {
            return this.intervalDuration;
        }

        public void setIntervalCron(String cron) {
            this.intervalCron = cron;
        }

        public void setDuration(Long duration) {
            this.duration = duration;
        }

        public void setExpiration(Date expiration) {
            this.expiration = expiration;
        }

        public void setFinalExpiration(Date finalExpiration) {
            this.finalExpiration = finalExpiration;
        }

        public void setIntervalDuration(Long intervalDuration) {
            this.intervalDuration = intervalDuration;
        }
    }
}

