/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client;

import com.sun.istack.Nullable;
import com.sun.xml.ws.client.ResponseContext;
import com.sun.xml.ws.client.ResponseContextReceiver;
import com.sun.xml.ws.util.CompletedFuture;
import java.util.Map;
import java.util.concurrent.FutureTask;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Response;
import javax.xml.ws.WebServiceException;

public final class AsyncResponseImpl<T>
extends FutureTask<T>
implements Response<T>,
ResponseContextReceiver {
    private final AsyncHandler<T> handler;
    private ResponseContext responseContext;
    private final Runnable callable;

    public AsyncResponseImpl(Runnable runnable, @Nullable AsyncHandler<T> handler) {
        super(runnable, null);
        this.callable = runnable;
        this.handler = handler;
    }

    @Override
    public void run() {
        try {
            this.callable.run();
        }
        catch (WebServiceException e) {
            this.set(null, e);
        }
        catch (Throwable e) {
            this.set(null, new WebServiceException(e));
        }
    }

    public ResponseContext getContext() {
        return this.responseContext;
    }

    @Override
    public void setResponseContext(ResponseContext rc) {
        this.responseContext = rc;
    }

    public void set(T v, Throwable t) {
        if (this.handler != null) {
            try {
                class CallbackFuture<T>
                extends CompletedFuture<T>
                implements Response<T> {
                    public CallbackFuture(T v, Throwable t) {
                        super(v, t);
                    }

                    @Override
                    public Map<String, Object> getContext() {
                        return AsyncResponseImpl.this.getContext();
                    }
                }
                this.handler.handleResponse(new CallbackFuture<T>(v, t));
            }
            catch (Throwable e) {
                super.setException(e);
                return;
            }
        }
        if (t != null) {
            super.setException(t);
        } else {
            super.set(v);
        }
    }
}

