/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.validation.basic;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.validation.AbstractKernelBeanValidator;
import org.jboss.kernel.spi.validation.KernelBeanValidator;

public class BasicKernelBeanValidator
extends AbstractKernelBeanValidator {
    public static final String DISABLED_PROPERTY_KEY = KernelBeanValidator.class.getSimpleName() + ".disabled";
    private boolean disabled;

    public void setKernel(Kernel kernel) throws Throwable {
        super.setKernel(kernel);
        SecurityManager sm = System.getSecurityManager();
        this.disabled = sm != null ? AccessController.doPrivileged(new DisabledFlagReader()) : BasicKernelBeanValidator.readDisabledFlag();
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    protected static boolean readDisabledFlag() {
        return Boolean.parseBoolean(System.getProperty(DISABLED_PROPERTY_KEY, "true"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DisabledFlagReader
    implements PrivilegedAction<Boolean> {
        private DisabledFlagReader() {
        }

        @Override
        public Boolean run() {
            return BasicKernelBeanValidator.readDisabledFlag();
        }
    }
}

