/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.identity.plugins;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.RoleType;
import org.jboss.security.identity.plugins.SimpleRole;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRoleGroup
extends SimpleRole
implements RoleGroup {
    private static final long serialVersionUID = 1L;
    private ArrayList<Role> roles = new ArrayList();
    private static final String ROLES_IDENTIFIER = "Roles";

    public SimpleRoleGroup(String roleName) {
        super(roleName);
    }

    public SimpleRoleGroup(String roleName, List<Role> roles) {
        super(roleName);
        if (this.roles == null) {
            this.roles = new ArrayList();
        }
        this.roles.addAll(roles);
    }

    public SimpleRoleGroup(Group rolesGroup) {
        super(rolesGroup.getName());
        Enumeration principals = rolesGroup.members();
        while (principals.hasMoreElements()) {
            this.roles.add(new SimpleRole(((Principal)principals.nextElement()).getName()));
        }
    }

    public SimpleRoleGroup(Set<Principal> rolesAsPrincipals) {
        super(ROLES_IDENTIFIER);
        for (Principal p : rolesAsPrincipals) {
            this.roles.add(new SimpleRole(p.getName()));
        }
    }

    @Override
    public RoleType getType() {
        return RoleType.group;
    }

    public synchronized void addRole(Role role) {
        this.roles.add(role);
    }

    public synchronized void addAll(List<Role> roles) {
        if (roles != null) {
            this.roles.addAll(roles);
        }
    }

    public synchronized void removeRole(Role role) {
        this.roles.remove(role);
    }

    public synchronized void clearRoles() {
        this.roles.clear();
    }

    public List<Role> getRoles() {
        return Collections.unmodifiableList(this.roles);
    }

    @Override
    public synchronized Object clone() throws CloneNotSupportedException {
        SimpleRoleGroup clone = (SimpleRoleGroup)super.clone();
        if (clone != null) {
            clone.roles = (ArrayList)this.roles.clone();
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Role anotherRole) {
        boolean isContained = false;
        if (anotherRole.getType() == RoleType.simple) {
            SimpleRoleGroup simpleRoleGroup = this;
            synchronized (simpleRoleGroup) {
                for (Role r : this.roles) {
                    isContained = r.containsAll(anotherRole);
                    if (!isContained) continue;
                    return true;
                }
            }
        } else {
            RoleGroup anotherRG = (RoleGroup)anotherRole;
            List anotherRoles = anotherRG.getRoles();
            for (Role r : anotherRoles) {
                if (this.containsAll(r)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean containsAtleastOneRole(RoleGroup anotherRole) {
        if (anotherRole == null) {
            throw new IllegalArgumentException("anotherRole is null");
        }
        List roleList = anotherRole.getRoles();
        for (Role r : roleList) {
            if (!this.containsAll(r)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean containsRole(Role role) {
        for (Role r : this.roles) {
            if (!r.containsAll(role)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getRoleName());
        builder.append("(");
        SimpleRoleGroup simpleRoleGroup = this;
        synchronized (simpleRoleGroup) {
            for (Role role : this.roles) {
                builder.append(role.toString()).append(",");
            }
        }
        builder.append(")");
        return builder.toString();
    }
}

