/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.MessageBody;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.URLEncodedString;
import java.io.IOException;
import java.io.OutputStream;

class URLEncodedMessageBody
extends MessageBody {
    URLEncodedMessageBody(PostMethodWebRequest request) {
        super(request);
    }

    @Override
    String getContentType() {
        return "application/x-www-form-urlencoded" + (!HttpUnitOptions.isPostIncludesCharset() ? "" : "; charset=" + this.getRequest().getCharacterSet());
    }

    @Override
    void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.getParameterString().getBytes());
    }

    private String getParameterString() {
        try {
            URLEncodedString encoder = new URLEncodedString();
            this.getRequest().getParameterHolder().recordParameters(encoder);
            return encoder.getString();
        }
        catch (IOException e) {
            throw new RuntimeException("Programming error: " + e);
        }
    }
}

