/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.util.CorbaLoc;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class PrintIOR {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        var1_1 = org.omg.CORBA.ORB.init(var0, null);
        var2_2 = (ORB)var1_1;
        var3_3 = var2_2.getConfiguration().getLogger("jacorb.print_ior");
        var5_4 = null;
        if (var0.length != 2) {
            System.err.println("Usage: java PrintIOR [ -i ior_str | -f filename ]");
            System.exit(1);
        }
        if (var0[0].equals("-f")) {
            try {
                var6_5 = new BufferedReader(new FileReader(var0[1]), 2048);
                var4_7 = var6_5.readLine();
                if (var4_7 == null) ** GOTO lbl29
                var5_4 = var4_7;
                while (var4_7 != null) {
                    var4_7 = var6_5.readLine();
                    if (var4_7 == null) continue;
                    var5_4 = var5_4 + var4_7;
                }
            }
            catch (IOException var6_6) {
                var6_6.printStackTrace();
                System.exit(1);
            }
        } else if (var0[0].equals("-i")) {
            var5_4 = var0[1];
        } else {
            System.err.println("Usage: java PrintIOR [ -i ior_str | -f filename ]");
            System.exit(1);
        }
lbl29:
        // 5 sources

        if (var3_3.isDebugEnabled()) {
            var3_3.debug("Under " + System.getProperty("os.name") + " the encoding name is " + System.getProperty("file.encoding") + " and the canonical encoding name is " + new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding());
        }
        var6_5 = new PrintWriter(System.out, true);
        if (var5_4.startsWith("IOR:")) {
            var7_8 = new ParsedIOR(var2_2, var5_4);
            PrintIOR.printIOR(var7_8, (PrintWriter)var6_5);
        } else {
            var6_5.println("Sorry, we only unparse IORs in the standard IOR URL scheme");
        }
        var1_1.shutdown(true);
    }

    public static void printIOR(ParsedIOR parsedIOR, PrintWriter printWriter) {
        IOR iOR = parsedIOR.getIOR();
        printWriter.println("------IOR components-----");
        printWriter.println("TypeId\t:\t" + iOR.type_id);
        List list = parsedIOR.getProfiles();
        printWriter.println("TAG_INTERNET_IOP Profiles:");
        for (int i = 0; i < list.size(); ++i) {
            printWriter.println("\tProfile Id:\t\t" + i);
            IIOPProfile iIOPProfile = (IIOPProfile)list.get(i);
            printWriter.println("\tIIOP Version:\t\t" + iIOPProfile.version().major + "." + iIOPProfile.version().minor);
            printWriter.println("\tHost:\t\t\t" + ((IIOPAddress)iIOPProfile.getAddress()).getOriginalHost());
            int n = ((IIOPAddress)iIOPProfile.getAddress()).getPort();
            if (n < 0) {
                n += 65536;
            }
            printWriter.println("\tPort:\t\t\t" + n);
            printWriter.println("\tObject key (URL):\t" + CorbaLoc.parseKey(iIOPProfile.get_object_key()));
            printWriter.print("\tObject key (hex):\t0x");
            PrintIOR.dumpHex(iIOPProfile.get_object_key(), printWriter);
            printWriter.println();
            if (iIOPProfile.version().minor >= 1) {
                if (iIOPProfile.getComponents().size() > 0) {
                    printWriter.println("\t-- Found " + iIOPProfile.getComponents().size() + " Tagged Components--");
                }
                PrintIOR.printTaggedComponents(iIOPProfile.getComponents().asArray(), printWriter);
            }
            printWriter.print("\n");
        }
        TaggedComponentList taggedComponentList = parsedIOR.getMultipleComponents();
        if (taggedComponentList.size() > 0) {
            printWriter.println("Components in MULTIPLE_COMPONENTS profile: " + taggedComponentList.size());
            PrintIOR.printTaggedComponents(taggedComponentList.asArray(), printWriter);
        }
    }

    private static void printTaggedComponents(TaggedComponent[] taggedComponentArray, PrintWriter printWriter) {
        block11: for (int i = 0; i < taggedComponentArray.length; ++i) {
            switch (taggedComponentArray[i].tag) {
                case 20: {
                    printWriter.println("\t#" + i + ": TAG_SSL_SEC_TRANS");
                    PrintIOR.printSSLTaggedComponent(taggedComponentArray[i], printWriter);
                    continue block11;
                }
                case 33: {
                    printWriter.println("\t#" + i + ": TAG_CSI_SEC_MECH_LIST");
                    PrintIOR.printCSIMechComponent(taggedComponentArray[i], printWriter);
                    continue block11;
                }
                case 35: {
                    printWriter.println("\t#" + i + ": TAG_SECIOP_SEC_TRANS");
                    continue block11;
                }
                case 3: {
                    printWriter.println("\t#" + i + ": TAG_ALTERNATE_IIOP_ADDRESS");
                    PrintIOR.printAlternateAddress(taggedComponentArray[i], printWriter);
                    continue block11;
                }
                case 1: {
                    printWriter.println("\t#" + i + ": TAG_CODE_SETS");
                    PrintIOR.printCodeSetComponent(taggedComponentArray[i], printWriter);
                    continue block11;
                }
                case 25: {
                    printWriter.println("\t#" + i + ": TAG_JAVA_CODEBASE");
                    PrintIOR.printJavaCodebaseComponent(taggedComponentArray[i], printWriter);
                    continue block11;
                }
                case 0: {
                    printWriter.println("\t#" + i + ": TAG_ORB_TYPE");
                    PrintIOR.printOrbTypeComponent(taggedComponentArray[i], printWriter);
                    continue block11;
                }
                case 2: {
                    printWriter.println("\t#" + i + ": TAG_POLICIES");
                    PrintIOR.printPolicyComponent(taggedComponentArray[i], printWriter);
                    continue block11;
                }
                case 34: {
                    printWriter.println("\t#" + i + ": TAG_NULL_TAG");
                    continue block11;
                }
                default: {
                    printWriter.println("\tUnknown tag : " + taggedComponentArray[i].tag);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printCSIMechComponent(TaggedComponent taggedComponent, PrintWriter printWriter) {
        CDRInputStream cDRInputStream = new CDRInputStream((org.omg.CORBA.ORB)null, taggedComponent.component_data);
        try {
            cDRInputStream.openEncapsulatedArray();
            CompoundSecMechList compoundSecMechList = CompoundSecMechListHelper.read(cDRInputStream);
            if (compoundSecMechList != null) {
                printWriter.println("\t\tis stateful: " + compoundSecMechList.stateful);
                for (int i = 0; i < compoundSecMechList.mechanism_list.length; ++i) {
                    printWriter.println("\t\tCompoundSecMech #" + i);
                    printWriter.println("\t\t\ttarget_requires: " + compoundSecMechList.mechanism_list[i].target_requires);
                    printWriter.print("\t\t\ttransport mechanism tag: ");
                    switch (compoundSecMechList.mechanism_list[i].transport_mech.tag) {
                        case 36: {
                            printWriter.println("TAG_TLS_SEC_TRANS");
                            PrintIOR.printTlsSecTrans(compoundSecMechList.mechanism_list[i].transport_mech.component_data, printWriter);
                            break;
                        }
                        case 34: {
                            printWriter.println("TAG_NULL_TAG");
                            break;
                        }
                        default: {
                            printWriter.println("Unknown tag : " + compoundSecMechList.mechanism_list[i].transport_mech.tag);
                        }
                    }
                    printWriter.println("\t\t\tAS_ContextSec target_supports: " + compoundSecMechList.mechanism_list[i].as_context_mech.target_supports);
                    printWriter.println("\t\t\tAS_ContextSec target_requires: " + compoundSecMechList.mechanism_list[i].as_context_mech.target_requires);
                    printWriter.print("\t\t\tAS_ContextSec mech: ");
                    PrintIOR.dumpHex(compoundSecMechList.mechanism_list[i].as_context_mech.client_authentication_mech, printWriter);
                    printWriter.println();
                    printWriter.print("\t\t\tAS_ContextSec target_name: ");
                    PrintIOR.printNTExportedName(compoundSecMechList.mechanism_list[i].as_context_mech.target_name, printWriter);
                    printWriter.println("\t\t\tSAS_ContextSec target_supports: " + compoundSecMechList.mechanism_list[i].sas_context_mech.target_supports);
                    printWriter.println("\t\t\tSAS_ContextSec target_requires: " + compoundSecMechList.mechanism_list[i].sas_context_mech.target_requires);
                    for (int j = 0; j < compoundSecMechList.mechanism_list[i].sas_context_mech.supported_naming_mechanisms.length; ++j) {
                        printWriter.print("\t\t\tSAS_ContextSec Naming mech: ");
                        PrintIOR.dumpHex(compoundSecMechList.mechanism_list[i].sas_context_mech.supported_naming_mechanisms[j], printWriter);
                        printWriter.println();
                    }
                    printWriter.println("\t\t\tSAS_ContextSec Naming types: " + compoundSecMechList.mechanism_list[i].sas_context_mech.supported_identity_types);
                    printWriter.println();
                }
            }
        }
        finally {
            cDRInputStream.close();
        }
    }

    private static void printNTExportedName(byte[] byArray, PrintWriter printWriter) {
        if (byArray.length < 2 || byArray[0] != 4 || byArray[1] != 1) {
            PrintIOR.dumpHex(byArray, printWriter);
            printWriter.println();
            return;
        }
        int n = (byArray[2] << 8) + byArray[3];
        if (n > byArray.length - 8) {
            PrintIOR.dumpHex(byArray, printWriter);
            printWriter.println();
            return;
        }
        int n2 = (byArray[n + 4] << 24) + (byArray[n + 5] << 16) + (byArray[n + 6] << 8) + byArray[n + 7];
        if (n + n2 > byArray.length - 8) {
            PrintIOR.dumpHex(byArray, printWriter);
            printWriter.println();
            return;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n + 8, byArray2, 0, n2);
        printWriter.println(new String(byArray2));
    }

    private static void printTlsSecTrans(byte[] byArray, PrintWriter printWriter) {
        CDRInputStream cDRInputStream = new CDRInputStream((org.omg.CORBA.ORB)null, byArray);
        try {
            cDRInputStream.openEncapsulatedArray();
            TLS_SEC_TRANS tLS_SEC_TRANS = TLS_SEC_TRANSHelper.read(cDRInputStream);
            printWriter.println("\t\t\tTLS SEC TRANS target requires: " + tLS_SEC_TRANS.target_requires);
            printWriter.println("\t\t\tTLS SEC TRANS target supports: " + tLS_SEC_TRANS.target_supports);
            for (int i = 0; i < tLS_SEC_TRANS.addresses.length; ++i) {
                int n = tLS_SEC_TRANS.addresses[i].port;
                if (n < 0) {
                    n += 65536;
                }
                printWriter.println("\t\t\tTLS SEC TRANS address: " + tLS_SEC_TRANS.addresses[i].host_name + ":" + n);
            }
        }
        catch (Exception exception) {
            printWriter.print("\t\t\tTLS SEC TRANS: ");
            PrintIOR.dumpHex(byArray, printWriter);
            printWriter.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printCodeSetComponent(TaggedComponent taggedComponent, PrintWriter printWriter) {
        CDRInputStream cDRInputStream = new CDRInputStream((org.omg.CORBA.ORB)null, taggedComponent.component_data);
        try {
            cDRInputStream.openEncapsulatedArray();
            CodeSetComponentInfo codeSetComponentInfo = CodeSetComponentInfoHelper.read(cDRInputStream);
            if (codeSetComponentInfo != null) {
                int n;
                printWriter.println("\t\tForChar native code set Id: " + CodeSet.csName(codeSetComponentInfo.ForCharData.native_code_set));
                printWriter.print("\t\tChar Conversion Code Sets: ");
                for (n = 0; n < codeSetComponentInfo.ForCharData.conversion_code_sets.length; ++n) {
                    printWriter.println(CodeSet.csName(codeSetComponentInfo.ForCharData.conversion_code_sets[n]));
                    if (n >= codeSetComponentInfo.ForCharData.conversion_code_sets.length - 1) continue;
                    printWriter.print(", ");
                }
                if (codeSetComponentInfo.ForCharData.conversion_code_sets.length == 0) {
                    printWriter.print("\n");
                }
                printWriter.println("\t\tForWChar native code set Id: " + CodeSet.csName(codeSetComponentInfo.ForWcharData.native_code_set));
                printWriter.print("\t\tWChar Conversion Code Sets: ");
                for (n = 0; n < codeSetComponentInfo.ForWcharData.conversion_code_sets.length; ++n) {
                    printWriter.println(CodeSet.csName(codeSetComponentInfo.ForWcharData.conversion_code_sets[n]));
                    if (n >= codeSetComponentInfo.ForWcharData.conversion_code_sets.length - 1) continue;
                    printWriter.print(", ");
                }
                if (codeSetComponentInfo.ForCharData.conversion_code_sets.length == 0) {
                    printWriter.print("\n");
                }
            }
        }
        finally {
            cDRInputStream.close();
        }
    }

    private static void printSSLTaggedComponent(TaggedComponent taggedComponent, PrintWriter printWriter) {
        SSL sSL = null;
        if (taggedComponent.tag == 20) {
            CDRInputStream cDRInputStream = new CDRInputStream((org.omg.CORBA.ORB)null, taggedComponent.component_data);
            try {
                cDRInputStream.openEncapsulatedArray();
                sSL = SSLHelper.read(cDRInputStream);
            }
            catch (Exception exception) {
                return;
            }
            int n = sSL.port;
            if (n < 0) {
                n += 65536;
            }
            printWriter.print("\t\ttarget_supports\t:\t");
            PrintIOR.decodeAssociationOption(sSL.target_supports, printWriter);
            printWriter.println();
            printWriter.print("\t\ttarget_requires\t:\t");
            PrintIOR.decodeAssociationOption(sSL.target_requires, printWriter);
            printWriter.println();
            printWriter.println("\t\tSSL Port\t:\t" + n);
        }
    }

    private static void decodeAssociationOption(int n, PrintWriter printWriter) {
        boolean bl = true;
        if ((n & 1) != 0) {
            if (!bl) {
                printWriter.print(", ");
            }
            printWriter.print("NoProtection");
            bl = false;
        }
        if ((n & 2) != 0) {
            if (!bl) {
                printWriter.print(", ");
            }
            printWriter.print("Integrity");
            bl = false;
        }
        if ((n & 4) != 0) {
            if (!bl) {
                printWriter.print(", ");
            }
            printWriter.print("Confidentiality");
            bl = false;
        }
        if ((n & 8) != 0) {
            if (!bl) {
                printWriter.print(", ");
            }
            printWriter.print("DetectReplay");
            bl = false;
        }
        if ((n & 0x10) != 0) {
            if (!bl) {
                printWriter.print(", ");
            }
            printWriter.print("DetectMisordering");
            bl = false;
        }
        if ((n & 0x20) != 0) {
            if (!bl) {
                printWriter.print(", ");
            }
            printWriter.print("EstablishTrustInTarget");
            bl = false;
        }
        if ((n & 0x40) != 0) {
            if (!bl) {
                printWriter.print(", ");
            }
            printWriter.print("EstablishTrustInClient");
            bl = false;
        }
        if ((n & 0x80) != 0) {
            if (!bl) {
                printWriter.print(", ");
            }
            printWriter.print("NoDelegation");
            bl = false;
        }
        if ((n & 0x100) != 0) {
            if (!bl) {
                printWriter.print(", ");
            }
            printWriter.print("SimpleDelegation");
            bl = false;
        }
        if ((n & 0x200) != 0) {
            if (!bl) {
                printWriter.print(", ");
            }
            printWriter.print("CompositeDelegation");
            bl = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printJavaCodebaseComponent(TaggedComponent taggedComponent, PrintWriter printWriter) {
        CDRInputStream cDRInputStream = new CDRInputStream((org.omg.CORBA.ORB)null, taggedComponent.component_data);
        try {
            cDRInputStream.openEncapsulatedArray();
            String string = cDRInputStream.read_string();
            printWriter.println("\t\tCodebase: " + string);
        }
        finally {
            cDRInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printOrbTypeComponent(TaggedComponent taggedComponent, PrintWriter printWriter) {
        CDRInputStream cDRInputStream = new CDRInputStream((org.omg.CORBA.ORB)null, taggedComponent.component_data);
        try {
            cDRInputStream.openEncapsulatedArray();
            int n = cDRInputStream.read_long();
            printWriter.print("\t\tType: " + n);
            if (n == 1245790976) {
                printWriter.println(" (JacORB)");
            } else {
                printWriter.println(" (Foreign)");
            }
        }
        finally {
            cDRInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printAlternateAddress(TaggedComponent taggedComponent, PrintWriter printWriter) {
        CDRInputStream cDRInputStream = new CDRInputStream((org.omg.CORBA.ORB)null, taggedComponent.component_data);
        try {
            cDRInputStream.openEncapsulatedArray();
            printWriter.println("\t\tAddress: " + IIOPAddress.read(cDRInputStream));
        }
        finally {
            cDRInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpHex(byte[] byArray) {
        PrintWriter printWriter = new PrintWriter(System.out);
        try {
            PrintIOR.dumpHex(byArray, printWriter);
        }
        finally {
            printWriter.close();
        }
    }

    private static void dumpHex(byte[] byArray, PrintWriter printWriter) {
        for (int i = 0; i < byArray.length; ++i) {
            int n = (byArray[i] & 0xFF) / 16;
            int n2 = (byArray[i] & 0xFF) % 16;
            char c = (char)(n > 9 ? 65 + (n - 10) : 48 + n);
            char c2 = (char)(n2 > 9 ? 65 + (n2 - 10) : 48 + n2);
            printWriter.print(c);
            printWriter.print(c2);
            printWriter.print(' ');
        }
    }

    public static String dump(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(byArray[i]);
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static String dump(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static String dump(byte by) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(hexDigit[by >> 4 & 0xF]);
        stringBuffer.append(hexDigit[by & 0xF]);
        return stringBuffer.toString();
    }

    public static String dump(short s) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(hexDigit[s >> 12 & 0xF]);
        stringBuffer.append(hexDigit[s >> 9 & 0xF]);
        stringBuffer.append(hexDigit[s >> 4 & 0xF]);
        stringBuffer.append(hexDigit[s & 0xF]);
        return stringBuffer.toString();
    }

    public static String dump(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(hexDigit[n >> 28 & 0xF]);
        stringBuffer.append(hexDigit[n >> 24 & 0xF]);
        stringBuffer.append(hexDigit[n >> 20 & 0xF]);
        stringBuffer.append(hexDigit[n >> 16 & 0xF]);
        stringBuffer.append(hexDigit[n >> 12 & 0xF]);
        stringBuffer.append(hexDigit[n >> 8 & 0xF]);
        stringBuffer.append(hexDigit[n >> 4 & 0xF]);
        stringBuffer.append(hexDigit[n & 0xF]);
        return stringBuffer.toString();
    }

    public static String dump(byte[] byArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if (0 == i % 16) {
                stringBuffer.append('\n');
            }
            char c = byArray[i] > 31 && byArray[i] < 127 ? (char)((char)byArray[i]) : (char)' ';
            stringBuffer.append(':');
            stringBuffer.append(hexDigit[byArray[i] >> 4 & 0xF]);
            stringBuffer.append(hexDigit[byArray[i] & 0xF]);
            stringBuffer.append(' ');
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printPolicyComponent(TaggedComponent taggedComponent, PrintWriter printWriter) {
        CDRInputStream cDRInputStream = new CDRInputStream((org.omg.CORBA.ORB)null, taggedComponent.component_data);
        try {
            int n = 0;
            cDRInputStream.openEncapsulatedArray();
            int n2 = cDRInputStream.read_long();
            while (n2-- != 0) {
                int n3 = cDRInputStream.read_long();
                printWriter.print("\t\t#" + n++ + ": ");
                cDRInputStream.openEncapsulation();
                switch (n3) {
                    case 45: {
                        printWriter.println("RTCORBA::PRIORITY_BANDED_CONNECTION");
                        n3 = cDRInputStream.read_long();
                        for (long i = 0L; i < (long)n3; ++i) {
                            short s = cDRInputStream.read_short();
                            short s2 = cDRInputStream.read_short();
                            printWriter.println("\t\t\tBand " + i + ": " + s + "-" + s2);
                        }
                        break;
                    }
                    case 40: {
                        printWriter.print("RTCORBA::PRIORITY_MODEL");
                        n3 = cDRInputStream.read_long();
                        switch (n3) {
                            case 0: {
                                printWriter.print(" (CLIENT_PROPAGATED, ");
                                break;
                            }
                            case 1: {
                                printWriter.print(" (SERVER_DECLARED, ");
                                break;
                            }
                            default: {
                                printWriter.print(" (Unknown, ");
                            }
                        }
                        short s = cDRInputStream.read_short();
                        printWriter.println(s + ")");
                        break;
                    }
                    default: {
                        printWriter.println("Unknown (" + n3 + ")");
                    }
                }
                cDRInputStream.closeEncapsulation();
            }
        }
        finally {
            cDRInputStream.close();
        }
    }
}

