/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.async;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.Callable;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import javax.ejb.TimerService;
import javax.interceptor.Interceptors;
import org.jboss.seam.Component;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.async.AbstractDispatcher;
import org.jboss.seam.async.Asynchronous;
import org.jboss.seam.async.AsynchronousEvent;
import org.jboss.seam.async.AsynchronousInvocation;
import org.jboss.seam.async.LocalTimerServiceDispatcher;
import org.jboss.seam.async.TimerSchedule;
import org.jboss.seam.ejb.SeamInterceptor;
import org.jboss.seam.intercept.InvocationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@Name(value="org.jboss.seam.async.dispatcher")
@Interceptors(value={SeamInterceptor.class})
@Install(value=false, precedence=0)
public class TimerServiceDispatcher
extends AbstractDispatcher<Timer, TimerSchedule>
implements LocalTimerServiceDispatcher {
    @Resource
    TimerService timerService;

    @PostConstruct
    public void postConstruct() {
    }

    @Timeout
    public void dispatch(Timer timer) {
        ((Asynchronous)timer.getInfo()).execute(timer);
    }

    @Override
    public Timer scheduleTimedEvent(String type, TimerSchedule schedule, Object ... parameters) {
        return new TimerProxy(this.scheduleWithTimerService(schedule, new AsynchronousEvent(type, parameters)));
    }

    @Override
    public Timer scheduleAsynchronousEvent(String type, Object ... parameters) {
        return new TimerProxy(this.timerService.createTimer(0L, (Serializable)new AsynchronousEvent(type, parameters)));
    }

    @Override
    public Timer scheduleInvocation(InvocationContext invocation, Component component) {
        return new TimerProxy(this.scheduleWithTimerService(this.createTimerSchedule(invocation), new AsynchronousInvocation(invocation, component)));
    }

    private Timer scheduleWithTimerService(TimerSchedule schedule, Asynchronous asynchronous) {
        if (schedule.getIntervalDuration() != null) {
            if (schedule.getExpiration() != null) {
                return this.timerService.createTimer(schedule.getExpiration(), schedule.getIntervalDuration().longValue(), (Serializable)asynchronous);
            }
            if (schedule.getDuration() != null) {
                return this.timerService.createTimer(schedule.getDuration().longValue(), schedule.getIntervalDuration().longValue(), (Serializable)asynchronous);
            }
            return this.timerService.createTimer(0L, schedule.getIntervalDuration().longValue(), (Serializable)asynchronous);
        }
        if (schedule.getExpiration() != null) {
            return this.timerService.createTimer(schedule.getExpiration(), (Serializable)asynchronous);
        }
        if (schedule.getDuration() != null) {
            return this.timerService.createTimer(schedule.getDuration().longValue(), (Serializable)asynchronous);
        }
        return this.timerService.createTimer(0L, (Serializable)asynchronous);
    }

    @Override
    public Object call(Callable task) {
        try {
            return task.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static LocalTimerServiceDispatcher instance() {
        return (LocalTimerServiceDispatcher)AbstractDispatcher.instance();
    }

    static class TimerHandleProxy
    implements TimerHandle,
    Serializable {
        private static final long serialVersionUID = 6913362944260154627L;
        TimerHandle handle;

        public TimerHandleProxy(TimerHandle handle) {
            this.handle = handle;
        }

        public Timer getTimer() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
            Timer timer = (Timer)TimerServiceDispatcher.instance().call(new Callable(){

                public Object call() {
                    try {
                        return TimerHandleProxy.this.handle.getTimer();
                    }
                    catch (NoSuchObjectLocalException nsoe) {
                        return null;
                    }
                }
            });
            if (timer == null) {
                throw new NoSuchObjectLocalException();
            }
            return new TimerProxy(timer);
        }
    }

    static class TimerProxy
    implements Timer {
        Timer timer;

        public TimerProxy(Timer timer) throws IllegalStateException, NoSuchObjectLocalException, EJBException {
            this.timer = timer;
        }

        public void cancel() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
            TimerServiceDispatcher.instance().call(new Callable(){

                public Object call() {
                    TimerProxy.this.timer.cancel();
                    return null;
                }
            });
        }

        public TimerHandle getHandle() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
            TimerHandle handle = (TimerHandle)TimerServiceDispatcher.instance().call(new Callable(){

                public Object call() {
                    return TimerProxy.this.timer.getHandle();
                }
            });
            return new TimerHandleProxy(handle);
        }

        public Serializable getInfo() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
            return (Serializable)TimerServiceDispatcher.instance().call(new Callable(){

                public Object call() {
                    return TimerProxy.this.timer.getInfo();
                }
            });
        }

        public Date getNextTimeout() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
            return (Date)TimerServiceDispatcher.instance().call(new Callable(){

                public Object call() {
                    return TimerProxy.this.timer.getNextTimeout();
                }
            });
        }

        public long getTimeRemaining() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
            return (Long)TimerServiceDispatcher.instance().call(new Callable(){

                public Object call() {
                    return TimerProxy.this.timer.getTimeRemaining();
                }
            });
        }
    }
}

