/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.util.TagParser;
import java.util.Map;

public class DefaultDocletTag
implements DocletTag {
    private final String name;
    private final String value;
    private final int lineNumber;
    private String[] parameters;
    private Map namedParameters;
    private AbstractJavaEntity context;

    public DefaultDocletTag(String name, String value, AbstractJavaEntity context, int lineNumber) {
        this.name = name;
        this.value = value;
        this.context = context;
        this.lineNumber = lineNumber;
    }

    public DefaultDocletTag(String name, String value) {
        this(name, value, null, 0);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String[] getParameters() {
        if (this.parameters == null) {
            this.parameters = TagParser.parseWords(this.value);
        }
        return this.parameters;
    }

    @Override
    public Map getNamedParameterMap() {
        if (this.namedParameters == null) {
            this.namedParameters = TagParser.parseNamedParameters(this.value);
        }
        return this.namedParameters;
    }

    @Override
    public String getNamedParameter(String key) {
        return (String)this.getNamedParameterMap().get(key);
    }

    @Override
    public final AbstractJavaEntity getContext() {
        return this.context;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }
}

