/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.aop.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javassist.CtMember;
import org.jboss.annotation.factory.AnnotationCreator;
import org.jboss.aop.annotation.AnnotationRepository;
import org.jboss.ejb3.metadata.annotation.AnnotationRepositoryToMetaData;
import org.jboss.ejb3.metadata.annotation.ExtendedAnnotationRepository;
import org.jboss.logging.Logger;

public class CachingAnnotationRepository
extends AnnotationRepository
implements ExtendedAnnotationRepository {
    private static final Logger log = Logger.getLogger(CachingAnnotationRepository.class);
    private static final Object NULL = new Object();
    private AnnotationRepositoryToMetaData delegate;
    private ClassLoader classLoader;
    private Map<Class<?>, Object> classAnnotationsCache = new ConcurrentHashMap();
    private ConcurrentHashMap<Member, Map<Class<?>, Object>> memberCache = new ConcurrentHashMap();

    public CachingAnnotationRepository(AnnotationRepositoryToMetaData delegate, ClassLoader classLoader) {
        assert (delegate != null);
        assert (classLoader != null);
        this.delegate = delegate;
        this.classLoader = classLoader;
    }

    public void addAnnotation(CtMember m, String annotation) {
        log.error((Object)"EJBTHREE-1914: Unsupported");
        throw new UnsupportedOperationException("EJBTHREE-1914: Unsupported");
    }

    public void addAnnotation(Member m, String annotation, Object value) {
        this.addAnnotation(m, this.loadClass(annotation), (Object)this.initAnnotation(value));
    }

    public void addAnnotation(Member m, Class annotation, Object value) {
        Map<Class<?>, Object> annotationCache = this.getAnnotationCache(m);
        annotationCache.put(annotation, value);
        this.delegate.addAnnotation(m, annotation, value);
    }

    public void addClassAnnotation(Class annotationType, Object value) {
        this.classAnnotationsCache.put(annotationType, value);
        this.delegate.addClassAnnotation(annotationType, value);
    }

    public void addClassAnnotation(String annotation, String value) {
        this.addClassAnnotation(this.loadClass(annotation), this.initAnnotation(value));
    }

    public void disableAnnotation(Member m, String annotation) {
        this.delegate.disableAnnotation(m, annotation);
    }

    public void disableAnnotation(String annotation) {
        this.delegate.disableAnnotation(annotation);
    }

    public void enableAnnotation(String annotation) {
        this.delegate.enableAnnotation(annotation);
    }

    protected Map<Class<?>, Object> getAnnotationCache(Member m) {
        Map<Class<?>, Object> annotationCache = this.memberCache.get(m);
        if (annotationCache == null) {
            annotationCache = new ConcurrentHashMap();
            this.memberCache.put(m, annotationCache);
        }
        return annotationCache;
    }

    public Map getAnnotations() {
        log.error((Object)"EJBTHREE-1914: Unsupported");
        throw new UnsupportedOperationException("EJBTHREE-1914: Unsupported");
    }

    public Map getClassAnnotations() {
        log.error((Object)"EJBTHREE-1914: Unsupported");
        throw new UnsupportedOperationException("EJBTHREE-1914: Unsupported");
    }

    public boolean hasAnnotation(Class<?> cls, Class<? extends Annotation> annotationType) {
        return this.delegate.hasAnnotation(cls, annotationType);
    }

    public boolean hasAnnotation(Class<?> cls, Member member, Class<? extends Annotation> annotationType) {
        return this.delegate.hasAnnotation(cls, member, annotationType);
    }

    public boolean hasAnnotation(CtMember m, String annotation) {
        log.error((Object)"EJBTHREE-1914: Unsupported");
        throw new UnsupportedOperationException("EJBTHREE-1914: Unsupported");
    }

    public boolean hasAnnotation(Member m, Class annotation) {
        return this.resolveAnnotation(m, annotation) != null;
    }

    public boolean hasAnnotation(Member m, String annotation) {
        return this.hasAnnotation(m, this.loadClass(annotation));
    }

    public boolean hasClassAnnotation(Class annotationType) {
        return this.resolveClassAnnotation(annotationType) != null;
    }

    public boolean hasClassAnnotation(String annotation) {
        return this.hasClassAnnotation(this.loadClass(annotation));
    }

    protected Annotation initAnnotation(Object annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Null annotation");
        }
        if (annotation instanceof Annotation) {
            return (Annotation)annotation;
        }
        if (!(annotation instanceof String)) {
            throw new IllegalArgumentException("Not an annotation: " + annotation);
        }
        try {
            return (Annotation)AnnotationCreator.createAnnotation((String)((String)annotation), (ClassLoader)this.classLoader);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating annotation: " + annotation, e);
        }
    }

    public boolean isDisabled(Class annotation) {
        return this.delegate.isDisabled(annotation);
    }

    public boolean isDisabled(Member m, Class annotation) {
        return this.delegate.isDisabled(m, annotation);
    }

    public boolean isDisabled(Member m, String annotation) {
        log.error((Object)"EJBTHREE-1914: Unsupported");
        throw new UnsupportedOperationException("EJBTHREE-1914: Unsupported");
    }

    public boolean isDisabled(String annotation) {
        log.error((Object)"EJBTHREE-1914: Unsupported");
        throw new UnsupportedOperationException("EJBTHREE-1914: Unsupported");
    }

    protected Class<?> loadClass(String className) {
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)e.getMessage(), (Throwable)e);
            }
            throw new RuntimeException(e);
        }
    }

    public <A extends Annotation> A resolveAnnotation(Class<?> cls, Class<A> annotationType) {
        return (A)this.delegate.resolveAnnotation(cls, annotationType);
    }

    public <A extends Annotation> A resolveAnnotation(Class<?> cls, Member member, Class<A> annotationType) {
        return (A)this.delegate.resolveAnnotation(cls, member, annotationType);
    }

    public Object resolveAnnotation(Member m, Class annotationType) {
        Map<Class<?>, Object> annotationCache = this.getAnnotationCache(m);
        Object annotation = annotationCache.get(annotationType);
        if (annotation == null) {
            annotation = this.delegate.resolveAnnotation(m, annotationType);
            if (annotation != null) {
                annotationCache.put(annotationType, annotation);
            } else {
                annotationCache.put(annotationType, NULL);
            }
        }
        if (annotation == NULL) {
            annotation = null;
        }
        return annotation;
    }

    protected Object resolveAnnotation(Member m, String annotation) {
        log.error((Object)"EJBTHREE-1914: Unsupported");
        throw new UnsupportedOperationException("EJBTHREE-1914: Unsupported");
    }

    public Object resolveClassAnnotation(Class annotationType) {
        Object annotation = this.classAnnotationsCache.get(annotationType);
        if (annotation == null) {
            annotation = this.delegate.resolveClassAnnotation(annotationType);
            if (annotation != null) {
                this.classAnnotationsCache.put(annotationType, annotation);
            } else {
                this.classAnnotationsCache.put(annotationType, NULL);
            }
        }
        if (annotation == NULL) {
            annotation = null;
        }
        return annotation;
    }
}

